/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TDAlignType;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.DomUtil;

public class Caption
extends Div {
    private static final String FIRST_CAPTION = "ui-cptn-first";
    private String m_caption;
    private TD m_buttonpart;
    private List<SmallImgButton> m_btns = Collections.EMPTY_LIST;
    private Table m_table;
    private TD m_ttltd;
    private Img m_icon;
    private Div m_ttldiv;

    public Caption() {
    }

    public Caption(String ttl) {
        this.m_caption = ttl;
    }

    public Caption(String ttl, boolean isFirst) {
        this(ttl);
        this.setFirst(isFirst);
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(String caption) {
        if (DomUtil.isEqual((Object)this.m_caption, (Object)caption)) {
            return;
        }
        this.m_caption = caption;
        this.forceRebuild();
    }

    @Override
    public void createContent() throws Exception {
        this.addCssClass("ui-cptn");
        this.m_table = new Table();
        this.add(this.m_table);
        this.m_table.setCellPadding("0");
        this.m_table.setCellSpacing("0");
        this.m_table.setTableWidth("100%");
        TBody b = new TBody();
        this.m_table.add(b);
        this.m_ttltd = b.addRowAndCell();
        this.m_ttltd.setCssClass("ui-cptn-ttl");
        this.m_ttltd.setNowrap(true);
        this.m_ttldiv = new Div();
        this.m_ttltd.add(this.m_ttldiv);
        this.m_ttldiv.add(this.m_caption);
        TD right = b.addCell();
        right.setCssClass("ui-cptn-btn");
        this.m_buttonpart = right;
        right.setAlign(TDAlignType.RIGHT);
        if (this.m_icon != null) {
            this.m_buttonpart.add(this.m_icon);
        }
        for (SmallImgButton btn : this.m_btns) {
            this.m_buttonpart.add(btn);
        }
    }

    public void addIcon(String src) {
        if (this.m_icon == null) {
            this.m_icon = new Img(src);
            if (this.isBuilt()) {
                this.m_buttonpart.add(0, this.m_icon);
            }
        } else {
            this.m_icon.setSrc(src);
        }
        this.m_icon.setAlign(ImgAlign.RIGHT);
    }

    public void addButton(String image, String hint, IClicked<NodeBase> handler) {
        SmallImgButton ib = new SmallImgButton(image);
        ib.setClicked(handler);
        this.internallyAddButton(ib, hint);
    }

    public void addButton(String image, String hint, String onClickJs) {
        SmallImgButton ib = new SmallImgButton(image);
        ib.setOnClickJS(onClickJs);
        this.internallyAddButton(ib, hint);
    }

    private void internallyAddButton(SmallImgButton ib, String hint) {
        if (this.m_btns == Collections.EMPTY_LIST) {
            this.m_btns = new ArrayList<SmallImgButton>();
        }
        ib.setTitle(hint);
        this.m_btns.add(ib);
        if (this.isBuilt() && this.m_buttonpart != null) {
            this.m_buttonpart.add(ib);
        }
    }

    public void setFirst(boolean isFirst) {
        if (isFirst) {
            this.addCssClass(FIRST_CAPTION);
        } else {
            this.removeCssClass(FIRST_CAPTION);
        }
    }

    public boolean isFirst() {
        return this.hasCssClass(FIRST_CAPTION);
    }
}

