/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.layout.CaptionType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TDAlignType;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.DomUtil;

public class Caption2
extends Div {
    private String m_caption;
    private TD m_right;
    private List<SmallImgButton> m_btns = Collections.EMPTY_LIST;
    private Table m_table;
    private TD m_left;
    private TD m_middle;
    private Img m_icon;
    private Div m_ttldiv;
    @Nonnull
    private String m_rootCss = CaptionType.Default.getCssClass();

    public Caption2(@Nonnull CaptionType type) {
        this.m_rootCss = type.getCssClass();
    }

    public Caption2(@Nonnull CaptionType type, @Nonnull String caption) {
        this.m_rootCss = type.getCssClass();
        this.m_caption = caption;
    }

    public Caption2(@Nonnull String cssClass) {
        this.m_rootCss = cssClass;
    }

    public Caption2(@Nonnull String cssClass, @Nonnull String title) {
        this.m_rootCss = cssClass;
        this.m_caption = title;
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(String caption) {
        if (DomUtil.isEqual((Object)this.m_caption, (Object)caption)) {
            return;
        }
        this.m_caption = caption;
        this.forceRebuild();
    }

    @Override
    public void createContent() throws Exception {
        this.addCssClass(this.m_rootCss + " ui-cptn2");
        Table tbl = this.m_table = new Table();
        this.add(tbl);
        tbl.setCellPadding("0");
        tbl.setCellSpacing("0");
        tbl.setTableWidth("100%");
        TBody b = new TBody();
        tbl.add(b);
        TD td = this.m_left = b.addRowAndCell();
        td.setCssClass(this.m_rootCss + " ui-cptn2-left");
        td = this.m_middle = b.addCell();
        td.setCssClass("ui-cptn2-middle");
        this.m_middle.setNowrap(true);
        Div d = this.m_ttldiv = new Div();
        this.m_middle.add(d);
        d.add(this.m_caption);
        TD right = this.m_right = b.addCell();
        right.setCssClass("ui-cptn2-right");
        right.setAlign(TDAlignType.RIGHT);
        if (this.m_icon != null) {
            this.m_left.add(this.m_icon);
        }
        for (SmallImgButton btn : this.m_btns) {
            this.m_right.add(btn);
        }
    }

    public void setIcon(@Nonnull String src) {
        Img img = this.m_icon;
        if (img == null) {
            img = this.m_icon = new Img(src);
            if (this.isBuilt()) {
                this.m_left.removeAllChildren();
                this.m_left.add(0, img);
            }
        } else {
            img.setSrc(src);
        }
        img.setAlign(ImgAlign.RIGHT);
    }

    public void addButton(@Nonnull String image, @Nullable String hint, @Nonnull IClicked<NodeBase> handler) {
        SmallImgButton ib = new SmallImgButton(image);
        ib.setClicked(handler);
        this.internallyAddButton(ib, hint);
    }

    public void addButton(@Nonnull String image, @Nullable String hint, @Nonnull String onClickJs) {
        SmallImgButton ib = new SmallImgButton(image);
        ib.setOnClickJS(onClickJs);
        this.internallyAddButton(ib, hint);
    }

    private void internallyAddButton(@Nonnull SmallImgButton ib, @Nullable String hint) {
        if (this.m_btns == Collections.EMPTY_LIST) {
            this.m_btns = new ArrayList<SmallImgButton>();
        }
        ib.setTitle(hint);
        this.m_btns.add(ib);
        if (this.isBuilt() && this.m_right != null) {
            this.m_right.add(ib);
        }
    }
}

