/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TDAlignType;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.DomUtil;

public class CaptionedHeader
extends Table {
    private String m_caption;
    private TD m_buttonpart;
    private List<SmallImgButton> m_btns = Collections.EMPTY_LIST;
    private String m_icon;

    public CaptionedHeader() {
    }

    public CaptionedHeader(String ttl) {
        this.m_caption = ttl;
    }

    public CaptionedHeader(String ttl, String icon) {
        this.m_caption = ttl;
        this.m_icon = icon;
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(String caption) {
        if (DomUtil.isEqual((Object)this.m_caption, (Object)caption)) {
            return;
        }
        this.m_caption = caption;
        this.forceRebuild();
    }

    @Override
    public void createContent() throws Exception {
        this.addCssClass("ui-chdr");
        this.setCellPadding("0");
        this.setCellSpacing("0");
        this.setTableWidth("100%");
        TBody b = this.addBody();
        TD left = b.addRowAndCell();
        left.setCssClass("ui-chdr-l");
        TD ttltd = b.addCell();
        ttltd.setCssClass("ui-chdr-c");
        ttltd.setNowrap(true);
        Div ttl = new Div();
        ttltd.add(ttl);
        ttl.setCssClass("ui-chdr-ttl");
        if (this.m_icon != null) {
            Img img = new Img(this.m_icon);
            img.setAlign(ImgAlign.CENTER);
            ttl.add(img);
        }
        ttl.add(this.m_caption);
        TD right = b.addCell();
        right.setCssClass("ui-chdr-r");
        this.m_buttonpart = right;
        right.setAlign(TDAlignType.RIGHT);
        for (SmallImgButton btn : this.m_btns) {
            this.m_buttonpart.add(btn);
        }
    }

    public void addButton(String image, String hint, IClicked<NodeBase> handler) {
        SmallImgButton ib = new SmallImgButton(image);
        ib.setClicked(handler);
        this.internallyAddButton(ib, hint);
    }

    public void addButton(String image, String hint, String onClickJs) {
        SmallImgButton ib = new SmallImgButton(image);
        ib.setOnClickJS(onClickJs);
        this.internallyAddButton(ib, hint);
    }

    private void internallyAddButton(SmallImgButton ib, String hint) {
        if (this.m_btns == Collections.EMPTY_LIST) {
            this.m_btns = new ArrayList<SmallImgButton>();
        }
        ib.setTitle(hint);
        this.m_btns.add(ib);
        if (this.isBuilt() && this.m_buttonpart != null) {
            this.m_buttonpart.add(ib);
        }
    }

    public String getIcon() {
        return this.m_icon;
    }

    public void setIcon(String icon) {
        if (DomUtil.isEqual((Object)icon, (Object)this.m_icon)) {
            return;
        }
        this.m_icon = icon;
        this.forceRebuild();
    }
}

