/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.layout.ButtonBar;
import to.etc.domui.component.layout.IButtonBar;
import to.etc.domui.component.layout.Window;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.util.IExecute;
import to.etc.domui.util.Msgs;

public class Dialog
extends Window {
    public static final String RSN_SAVE = "save";
    private ButtonBar m_buttonBar;
    @Nullable
    private IExecute m_onSave;

    public Dialog() {
    }

    public Dialog(boolean modal, boolean resizable, int width, int height, String title) {
        super(modal, resizable, width, height, title);
    }

    public Dialog(boolean modal, boolean resizable, String title) {
        super(modal, resizable, title);
    }

    public Dialog(boolean resizable, String title) {
        super(resizable, title);
    }

    public Dialog(String title) {
        super(title);
    }

    public Dialog(int width, int height, String title) {
        super(width, height, title);
    }

    @Override
    @Nonnull
    public Dialog size(int width, int height) {
        super.size(width, height);
        return this;
    }

    @Override
    @Nonnull
    public Dialog resizable() {
        super.resizable();
        return this;
    }

    @Override
    @Nonnull
    public Dialog modal(boolean yes) {
        super.modal(yes);
        return this;
    }

    @Override
    @Nonnull
    public Dialog modal() {
        super.modal();
        return this;
    }

    @Override
    @Nonnull
    public Dialog title(@Nonnull String set) {
        super.title(set);
        return this;
    }

    public void setButtonsOnBottom(boolean onbottom) {
        if (this.m_buttonBar != null) {
            throw new IllegalStateException("The button bar has already been set.");
        }
        this.createButtonBar(onbottom);
    }

    private void createButtonBar(boolean onbottom) {
        Div area;
        if (this.m_buttonBar != null) {
            return;
        }
        this.m_buttonBar = new ButtonBar();
        Div div = area = onbottom ? this.getBottomContent() : this.getTopContent();
        if (area.getHeight() == null) {
            area.setHeight("34px");
        }
        area.add(this.m_buttonBar);
    }

    protected void createButtons() throws Exception {
        this.createSaveButton();
        this.createCancelButton();
    }

    public IButtonBar getButtonBar() {
        if (this.m_buttonBar == null) {
            this.createButtonBar(true);
        }
        return this.m_buttonBar;
    }

    protected void createCancelButton() {
        this.createCancelButton(Msgs.BUNDLE.getString("edlg.cancel"));
    }

    protected void createCancelButton(@Nonnull String text) {
        this.createCancelButton(text, "THEME/btnCancel.png");
    }

    protected void createCancelButton(@Nonnull String text, @Nonnull String image) {
        DefaultButton b = this.getButtonBar().addButton(text, image, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                Dialog.this.buttonCancel();
            }
        });
        b.setTestID("cancelButton");
    }

    @Nonnull
    protected DefaultButton createSaveButton() {
        return this.createSaveButton(Msgs.BUNDLE.getString("edlg.okay"), "THEME/btnSave.png");
    }

    @Nonnull
    protected DefaultButton createSaveButton(String caption, String iconUrl) {
        DefaultButton b = this.getButtonBar().addButton(caption, iconUrl, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                Dialog.this.buttonSave();
            }
        });
        b.setTestID("saveButton");
        return b;
    }

    protected void buttonCancel() throws Exception {
        this.closePressed();
    }

    protected void buttonSave() throws Exception {
        block6: {
            this.clearGlobalMessage();
            if (!this.onSaveBind()) {
                return;
            }
            if (!this.onValidate()) {
                return;
            }
            if (!this.onSave()) {
                return;
            }
            try {
                IExecute onSave = this.getOnSave();
                if (null != onSave) {
                    onSave.execute();
                }
                this.callCloseHandler(RSN_SAVE);
            }
            catch (Exception x) {
                if (this.onCloseException(x)) break block6;
                throw x;
            }
        }
        this.close();
    }

    protected boolean onSaveBind() throws Exception {
        return true;
    }

    protected boolean onValidate() throws Exception {
        return true;
    }

    protected boolean onCloseException(Exception x) throws Exception {
        return false;
    }

    protected boolean onSave() throws Exception {
        return true;
    }

    @Nullable
    public IExecute getOnSave() {
        return this.m_onSave;
    }

    public void setOnSave(@Nullable IExecute onSave) {
        this.m_onSave = onSave;
    }
}

