/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.dom.css.VisibilityType;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.errors.PropagatingErrorFenceHandler;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.DomUtil;

public class ErrorMessageDiv
extends Div
implements IErrorMessageListener {
    private List<UIMessage> m_msgList = new ArrayList<UIMessage>();

    public ErrorMessageDiv(NodeContainer parent) {
        this(parent, false);
    }

    public ErrorMessageDiv(NodeContainer parent, boolean propagateThroughFence) {
        if (propagateThroughFence) {
            PropagatingErrorFenceHandler handler = new PropagatingErrorFenceHandler(parent);
            parent.setErrorFence(handler);
        } else {
            parent.setErrorFence();
        }
        DomUtil.getMessageFence(parent).addErrorListener(this);
        this.setCssClass("ui-emd");
        this.setVisibility(VisibilityType.HIDDEN);
    }

    public ErrorMessageDiv() {
        this.setCssClass("ui-emd");
        this.setVisibility(VisibilityType.HIDDEN);
    }

    public void setAsErrorFence(NodeContainer parent) {
        parent.setErrorFence();
        DomUtil.getMessageFence(parent).addErrorListener(this);
    }

    @Override
    public void errorMessageAdded(@Nonnull UIMessage m) {
        if (this.m_msgList.contains(m)) {
            return;
        }
        if (m.getType() != MsgType.INFO) {
            List<Div> errorDivs = this.getChildren(Div.class);
            for (Div errorDiv : errorDivs) {
                Object userObject = errorDiv.getUserObject();
                if (!(userObject instanceof UIMessage) || ((UIMessage)userObject).getType() != MsgType.INFO) continue;
                this.m_msgList.remove(userObject);
                errorDiv.remove();
            }
        }
        this.m_msgList.add(m);
        this.createErrorUI(m);
    }

    protected void createErrorUI(UIMessage m) {
        if (this.getVisibility() != VisibilityType.VISIBLE) {
            this.setVisibility(VisibilityType.VISIBLE);
        }
        NodeContainer nc = this.createErrorLine(m);
        this.add(nc);
    }

    protected NodeContainer createErrorLine(UIMessage m) {
        Div d = new Div();
        this.add(d);
        d.setCssClass("ui-emd-msg ui-emd-" + m.getType().name().toLowerCase());
        d.setUserObject(m);
        DomUtil.renderErrorMessage(d, m);
        NodeBase errorNode = m.getErrorNode();
        if (errorNode != null) {
            errorNode.addCssClass("ui-input-err");
        }
        return d;
    }

    @Override
    public void errorMessageRemoved(@Nonnull UIMessage m) {
        if (!this.m_msgList.remove(m)) {
            return;
        }
        for (NodeBase b : this) {
            if (b.getUserObject() != m) continue;
            b.remove();
            NodeBase errorNode = m.getErrorNode();
            if (errorNode == null) break;
            errorNode.removeCssClass("ui-input-err");
            break;
        }
        if (this.getChildCount() == 0) {
            this.setVisibility(VisibilityType.HIDDEN);
        }
    }
}

