/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import to.etc.domui.component.layout.CaptionedPanel;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;

public class ErrorPanel
extends CaptionedPanel
implements IErrorMessageListener {
    private IErrorFence m_errorFence;
    private MsgType m_highestType;

    public ErrorPanel() {
        super(Msgs.BUNDLE.getString("ui.error.header"), (NodeContainer)new Div());
        this.setDisplay(DisplayType.NONE);
        this.getTitleContainer().setCssClass("ui-err-caption");
        this.setCssClass("ui-err-outer");
    }

    @Override
    public void onAddedToPage(Page p) {
        super.onAddedToPage(p);
        this.m_errorFence = DomUtil.getMessageFence(this);
        this.m_errorFence.addErrorListener(this);
    }

    @Override
    public void onRemoveFromPage(Page p) {
        super.onRemoveFromPage(p);
        this.m_errorFence.removeErrorListener(this);
    }

    @Override
    public void errorMessageAdded(@Nonnull UIMessage m) {
        NodeBase errorNode;
        Div d = new Div();
        d.setUserObject(m);
        DomUtil.renderErrorMessage(d, m);
        this.getContent().add(d);
        if (this.getContent().getChildCount() == 1) {
            this.setDisplay(DisplayType.BLOCK);
        }
        if ((errorNode = m.getErrorNode()) != null) {
            errorNode.addCssClass("ui-input-err");
        }
        if (this.m_highestType == null || m.getType().getOrder() > this.m_highestType.getOrder()) {
            this.m_highestType = m.getType();
            this.updateRepresentation();
        }
    }

    private void updateRepresentation() {
        if (this.m_highestType == null) {
            return;
        }
        switch (this.m_highestType) {
            default: {
                throw new IllegalStateException((Object)((Object)this.m_highestType) + " - ?");
            }
            case INFO: {
                this.setTitle(Msgs.BUNDLE.getString("ui.info.header"));
                break;
            }
            case WARNING: {
                this.setTitle(Msgs.BUNDLE.getString("ui.warning.header"));
                break;
            }
            case ERROR: {
                this.setTitle(Msgs.BUNDLE.getString("ui.error.header"));
            }
        }
    }

    @Override
    public void errorMessageRemoved(@Nonnull UIMessage m) {
        MsgType highest = null;
        int i = this.getContent().getChildCount();
        while (--i >= 0) {
            NodeBase b = this.getContent().getChild(i);
            if (b.getUserObject() == m) {
                NodeBase errorNode;
                b.remove();
                if (this.getContent().getChildCount() == 0) {
                    this.setDisplay(DisplayType.NONE);
                }
                if ((errorNode = m.getErrorNode()) == null) continue;
                errorNode.removeCssClass("ui-input-err");
                continue;
            }
            if (!(b.getUserObject() instanceof UIMessage)) continue;
            UIMessage uim = (UIMessage)b.getUserObject();
            if (uim == null) {
                throw new IllegalStateException("No user message found in userObject");
            }
            if (highest == null) {
                highest = uim.getType();
                continue;
            }
            if (uim.getType().getOrder() <= highest.getOrder()) continue;
            highest = uim.getType();
        }
        if (this.m_highestType != highest) {
            this.m_highestType = highest;
            this.updateRepresentation();
        }
    }
}

