/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.layout.Rect;
import to.etc.domui.dom.css.PositionType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;

public class FloatingDiv
extends Div {
    public static final String RSN_CLOSE = "closed";
    protected static final int DEFWIDTH = 640;
    protected static final int DEFHEIGHT = 400;
    protected static final int MINWIDTH = 256;
    protected static final int MINHEIGHT = 200;
    private boolean m_modal;
    private boolean m_resizable;
    private boolean m_autoClose = true;
    @Nullable
    private IWindowClosed m_onClose;
    @Nullable
    private Div m_hider;

    public FloatingDiv() {
    }

    public FloatingDiv(boolean modal) {
        this(modal, false, -1, -1);
    }

    public FloatingDiv(boolean modal, boolean resizable) {
        this(modal, resizable, -1, -1);
    }

    public FloatingDiv(boolean modal, boolean resizable, int widthinpx, int heightinpx) {
        this.m_modal = modal;
        this.m_resizable = resizable;
        this.setDimensions(widthinpx, heightinpx);
    }

    @Nonnull
    public FloatingDiv size(int width, int height) {
        this.setDimensions(width, height);
        return this;
    }

    @Nonnull
    public FloatingDiv resizable() {
        this.m_resizable = true;
        return this;
    }

    @Nonnull
    public FloatingDiv modal(boolean yes) {
        this.m_modal = yes;
        return this;
    }

    @Nonnull
    public FloatingDiv modal() {
        return this.modal(true);
    }

    @Nonnull
    public FloatingDiv width(int pxsl) {
        this.setWidth(pxsl + "px");
        return this;
    }

    public void setDimensions(int width, int height) {
        if (width > 0) {
            if (width < 250) {
                throw new IllegalArgumentException("The width=" + width + " is invalid: it cannot be smaller than 250.");
            }
            this.setWidth(width + "px");
        }
        if (height > 0) {
            if (height < 100) {
                throw new IllegalArgumentException("The height=" + height + " is invalid: it cannot be smaller than 100.");
            }
            this.setHeight(height + "px");
        }
    }

    public boolean isModal() {
        return this.m_modal;
    }

    public boolean isResizable() {
        return this.m_resizable;
    }

    @Nullable
    public Div internalGetHider() {
        return this.m_hider;
    }

    public void internalSetHider(@Nullable Div hider) {
        this.m_hider = hider;
    }

    @Override
    public void onRemoveFromPage(Page p) {
        super.onRemoveFromPage(p);
        p.internalRemoveFloater(this);
    }

    @Override
    protected void beforeCreateContent() {
        super.beforeCreateContent();
        this.addCssClass("ui-flw");
        this.deactivateHiddenAccessKeys();
        if (this.getZIndex() <= 0) {
            FloatingDiv parentFloatingDiv = this.findParent(FloatingDiv.class);
            if (parentFloatingDiv != null) {
                this.setZIndex(parentFloatingDiv.getZIndex() + 100);
            } else {
                this.setZIndex(100);
            }
        }
        if (this.getTestID() == null) {
            this.setTestID("popup_" + this.getZIndex());
        }
        this.setPosition(PositionType.FIXED);
        if (this.getWidth() != null && this.getWidth().endsWith("%")) {
            int widthPerc = DomUtil.percentSize(this.getWidth());
            if (widthPerc != -1) {
                this.setMarginLeft("-" + widthPerc / 2 + "%");
                this.setLeft("50%");
            }
        } else {
            int width = DomUtil.pixelSize(this.getWidth());
            if (-1 == width) {
                StringBuilder sb = new StringBuilder();
                this.appendJQuerySelector(sb);
                sb.append(".center();");
                this.appendCreateJS(sb.toString());
            } else {
                int top;
                int left = DomUtil.pixelSize(this.getLeft());
                if (-1 == left) {
                    this.setMarginLeft("-" + width / 2 + "px");
                    this.setLeft("50%");
                }
                if (-1 == (top = DomUtil.pixelSize(this.getTop()))) {
                    this.setMarginTop("0px");
                    this.setTop("5%");
                }
            }
        }
        if (this.isResizable()) {
            this.appendCreateJS("$('#" + this.getActualID() + "').resizable({minHeight: " + 200 + ", minWidth: " + 256 + ", resize: WebUI.floatingDivResize, stop: WebUI.notifySizePositionChanged});");
        }
    }

    public boolean isAutoClose() {
        return this.m_autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.m_autoClose = autoClose;
    }

    @Nullable
    public final IWindowClosed getOnClose() {
        return this.m_onClose;
    }

    public final void setOnClose(@Nullable IWindowClosed onClose) {
        this.m_onClose = onClose;
    }

    protected final void callCloseHandler(@Nonnull String closeReason) throws Exception {
        if (null == closeReason) {
            throw new IllegalArgumentException("Close reason cannot be null");
        }
        this.onClosed(closeReason);
        if (null != this.m_onClose) {
            this.m_onClose.closed(closeReason);
        }
    }

    protected void onClosed(@Nonnull String closeReason) throws Exception {
    }

    public void closePressed() throws Exception {
        this.close();
        this.callCloseHandler(RSN_CLOSE);
    }

    @OverridingMethodsMustInvokeSuper
    public void close() {
        this.reactivateHiddenAccessKeys();
        this.remove();
    }

    public static void close(@Nonnull NodeBase node) {
        while (!(node instanceof FloatingDiv)) {
            if (node == null) {
                return;
            }
            node = node.getParent();
        }
        ((FloatingDiv)node).close();
    }

    public void verticallyAlignToCenter() {
        this.setTop("50%");
        String height = this.getHeight();
        if (StringTool.isBlank((String)height) || !height.endsWith("px")) {
            throw new IllegalStateException("Unable to vertically align floater if height is not specified in px!");
        }
        this.setMarginTop("-" + Integer.parseInt(height.replace("px", "")) / 2 + "px");
    }

    private void deactivateHiddenAccessKeys() {
        this.appendCreateJS("WebUI.deactivateHiddenAccessKeys(" + this.getActualID() + ");");
    }

    private void reactivateHiddenAccessKeys() {
        this.appendJavascript("WebUI.reactivateHiddenAccessKeys('" + this.getActualID() + "');");
    }

    @Override
    public Rect getClientBounds() {
        return super.getClientBounds();
    }

    @Override
    public Dimension getBrowserWindowSize() {
        return super.getBrowserWindowSize();
    }

    @Override
    public final void setOnSizeAndPositionChange(@Nonnull INotify<NodeBase> onSizeAndPositionChange) {
        super.setOnSizeAndPositionChange(onSizeAndPositionChange);
    }
}

