/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.OverridingMethodsMustInvokeSuper;
import to.etc.domui.component.layout.Dialog;
import to.etc.domui.dom.css.CssBase;
import to.etc.domui.dom.css.VerticalAlignType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.NodeBase;

public class InputDialog<T, C extends NodeBase>
extends Dialog {
    private static int DEFAULT_WIDTH = 400;
    private static int DEFAULT_MIN_HEIGHT = 200;
    private C m_inputControl;
    private T m_instance;
    private String m_label;

    public InputDialog(C inputControl, int width, int height, String title) {
        super(width, height, title);
        this.m_inputControl = inputControl;
    }

    public InputDialog(C inputControl, String title, String label) {
        this(inputControl, true, false, DEFAULT_WIDTH, -1, title, label);
    }

    public InputDialog(C inputControl, boolean modal, boolean resizable, int width, int height, String title, String label) {
        super(modal, resizable, width, height, title);
        this.m_inputControl = inputControl;
        this.m_label = label;
    }

    public InputDialog(C inputControl, boolean modal, boolean resizable, String title, String label) {
        super(modal, resizable, DEFAULT_WIDTH, DEFAULT_MIN_HEIGHT, title);
        this.m_inputControl = inputControl;
        this.m_label = label;
    }

    public InputDialog(C inputControl, boolean resizable, String title) {
        super(true, resizable, DEFAULT_WIDTH, DEFAULT_MIN_HEIGHT, title);
        this.m_inputControl = inputControl;
    }

    public InputDialog(C inputControl, String title) {
        super(true, false, DEFAULT_WIDTH, DEFAULT_MIN_HEIGHT, title);
        this.m_inputControl = inputControl;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void createFrame() throws Exception {
        super.createFrame();
        this.createButtons();
    }

    @Override
    public void createContent() throws Exception {
        Div pnl = new Div();
        pnl.setCssClass("ui-idlg-pnl");
        if (this.m_label != null) {
            pnl.add(new Label(this.m_label));
            ((CssBase)this.getInputControl()).setVerticalAlign(VerticalAlignType.TOP);
        }
        pnl.add((NodeBase)this.getInputControl());
        this.add(pnl);
    }

    @Override
    protected void createButtons() throws Exception {
        this.setButtonsOnBottom(true);
        this.createSaveButton();
        this.createCancelButton();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected boolean onSaveBind() throws Exception {
        this.m_instance = ((IControl)this.m_inputControl).getValue();
        return true;
    }

    @Override
    protected final boolean onSave() throws Exception {
        return this.onSaveData(this.getInstance());
    }

    protected boolean onSaveData(T instance) throws Exception {
        return true;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected final boolean onValidate() throws Exception {
        return this.onValidateData(this.getInstance());
    }

    protected boolean onValidateData(T data) throws Exception {
        return true;
    }

    protected T getInstance() {
        return this.m_instance;
    }

    public C getInputControl() {
        return this.m_inputControl;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }
}

