/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Span;
import to.etc.domui.util.DomUtil;

public class MessageLine
extends Div {
    @Nullable
    private final MsgType m_type;
    @Nonnull
    private final String m_text;
    @Nullable
    private final String m_icon;

    public MessageLine(@Nonnull MsgType type, @Nonnull String text) {
        this.m_type = type;
        this.m_text = text;
        this.m_icon = null;
    }

    public MessageLine(@Nonnull String icon, @Nonnull String text) {
        this.m_icon = icon;
        this.m_text = text;
        this.m_type = null;
    }

    @Override
    public void createContent() throws Exception {
        this.addCssClass("ui-msgln");
        Img img = new Img();
        if (this.m_type != null) {
            img.setSrc("THEME/mini-" + this.m_type.name().toLowerCase() + ".png");
        } else if (this.m_icon != null) {
            img.setSrc(this.m_icon);
        } else {
            throw new IllegalArgumentException("No icon nor type.");
        }
        this.add(img);
        Span sp = new Span();
        this.add(sp);
        sp.addCssClass("ui-msgln-txt");
        DomUtil.renderHtmlString(sp, this.m_text);
    }
}

