/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.image.Point;

public final class Rect {
    private final int m_left;
    private final int m_top;
    private final int m_right;
    private final int m_bottom;

    public final int getLeft() {
        return this.m_left;
    }

    public final int getTop() {
        return this.m_top;
    }

    public final int getRight() {
        return this.m_right;
    }

    public final int getBottom() {
        return this.m_bottom;
    }

    public Rect(int left, int top, int right, int bottom) {
        this.m_left = left;
        this.m_top = top;
        this.m_right = right;
        this.m_bottom = bottom;
    }

    public Rect(@Nonnull Point position, @Nonnull Dimension size) {
        this.m_left = position.getX();
        this.m_top = position.getY();
        this.m_right = this.m_left + size.getWidth();
        this.m_bottom = this.m_top + size.getHeight();
    }

    public Rect(@Nonnull Point pointa, @Nonnull Point pointb) {
        this.m_left = pointa.getX();
        this.m_top = pointa.getY();
        this.m_right = pointb.getX();
        this.m_bottom = pointb.getY();
    }

    @Nonnull
    public Rect normalize() {
        int b;
        int t;
        int r;
        int l;
        if (this.m_left <= this.m_right && this.m_top <= this.m_bottom) {
            return this;
        }
        if (this.m_left > this.m_right) {
            l = this.m_right;
            r = this.m_left;
        } else {
            r = this.m_right;
            l = this.m_left;
        }
        if (this.m_top > this.m_bottom) {
            t = this.m_bottom;
            b = this.m_top;
        } else {
            b = this.m_bottom;
            t = this.m_top;
        }
        return new Rect(l, t, r, b);
    }

    @Nonnull
    public final Point getPosition() {
        return new Point(this.m_left, this.m_top);
    }

    @Nonnull
    public final Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return this.m_right - this.m_left;
    }

    public int getHeight() {
        return this.m_bottom - this.m_top;
    }

    @Nonnull
    public Rect move(int shiftX, int shiftY) {
        return new Rect(this.m_left + shiftX, this.m_top + shiftY, this.m_right + shiftX, this.m_bottom + shiftY);
    }

    public String toString() {
        return "rect (" + this.m_left + ", " + this.m_top + ") to (" + this.m_right + ", " + this.m_bottom + "), dims=(" + this.getDimension().getWidth() + ", " + this.getDimension().getHeight() + ")";
    }

    public boolean overlaps(@Nonnull Rect rect) {
        Rect a = this.normalize();
        Rect b = rect.normalize();
        if (a.m_right < b.m_left || a.m_left >= b.m_right) {
            return false;
        }
        return a.m_bottom >= b.m_top && a.m_top < b.m_bottom;
    }
}

