/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import to.etc.domui.component.layout.Caption2;
import to.etc.domui.component.layout.CaptionType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.JavascriptUtil;

public class SizedPanel
extends Div {
    private Div m_top;
    private Div m_middle;
    private Div m_bottom;
    private Caption2 m_caption;

    public SizedPanel() {
    }

    public SizedPanel(int width, int height) {
        this.setCssClass("ui-szdp");
        if (width > 0) {
            this.setWidth(width + "px");
        }
        if (height > 0) {
            this.setHeight(height + "px");
        }
    }

    @Nonnull
    public Caption2 caption() {
        Caption2 cap = this.m_caption;
        if (null == cap) {
            cap = this.m_caption = new Caption2(CaptionType.Panel);
            this.top().add(0, cap);
        }
        return cap;
    }

    public void setCaption(@Nonnull String title) {
        this.caption().setCaption(title);
    }

    @Override
    protected void createFrame() throws Exception {
        this.delegateTo(this.middle());
    }

    @Override
    public void onBeforeFullRender() throws Exception {
        int height = DomUtil.pixelSize(this.getHeight());
        if (height > 0) {
            JavascriptUtil.setThreePanelHeight(this.createStatement(), this.m_top, this.middle(), this.m_bottom);
        }
    }

    @Nonnull
    public Div top() {
        Div t = this.m_top;
        if (null == t) {
            t = this.m_top = new Div();
            this.undelegatedAdd(0, t);
        }
        return t;
    }

    @Nonnull
    public Div bottom() {
        Div t = this.m_bottom;
        if (null == t) {
            t = this.m_bottom = new Div();
            this.undelegatedAdd(999, t);
        }
        return t;
    }

    @Nonnull
    public Div middle() {
        Div t = this.m_middle;
        if (null == t) {
            t = this.m_middle = new Div();
            int ix = 0;
            if (this.m_top != null) {
                ix = 1;
            }
            this.add(ix, t);
        }
        return t;
    }
}

