/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.Page;

public class SplitterPanel
extends Div {
    private Div m_panelA;
    private Div m_panelB;
    private boolean m_vertical;
    private int m_minASize = 0;
    private int m_maxASize = 0;
    private int m_minBSize = 0;
    private int m_maxBSize = 0;
    private int m_closableToPerc = 90;
    private int m_initPosInPerc = -1;

    public SplitterPanel(Div panelA, Div panelB, boolean vertical) {
        this.m_panelA = panelA;
        this.m_panelB = panelB;
        this.m_vertical = vertical;
    }

    public Div getPanelA() {
        return this.m_panelA;
    }

    public Div getPanelB() {
        return this.m_panelB;
    }

    public boolean isVertical() {
        return this.m_vertical;
    }

    public int getMinASize() {
        return this.m_minASize;
    }

    public void setMinASize(int minASize) {
        this.m_minASize = minASize;
    }

    public int getMaxASize() {
        return this.m_maxASize;
    }

    public void setMaxASize(int maxASize) {
        this.m_maxASize = maxASize;
    }

    public int getMinBSize() {
        return this.m_minBSize;
    }

    public void setMinBSize(int minBSize) {
        this.m_minBSize = minBSize;
    }

    public int getMaxBSize() {
        return this.m_maxBSize;
    }

    public void setMaxBSize(int maxBSize) {
        this.m_maxBSize = maxBSize;
    }

    public int getClosableToPerc() {
        return this.m_closableToPerc;
    }

    public void setClosableToPerc(int closableToPerc) {
        this.m_closableToPerc = closableToPerc;
    }

    public int getInitPosInPerc() {
        return this.m_initPosInPerc;
    }

    public void setInitPosInPerc(int initPosInPerc) {
        this.m_initPosInPerc = initPosInPerc;
    }

    @Override
    public void createContent() throws Exception {
        if (this.m_vertical) {
            this.addCssClass("ui-splt-vert");
            this.m_panelA.removeCssClass("ui-splt-top");
            this.m_panelA.addCssClass("ui-splt-left");
            this.m_panelB.removeCssClass("ui-splt-bottom");
            this.m_panelB.addCssClass("ui-splt-right");
        } else {
            this.addCssClass("ui-splt-horz");
            this.m_panelA.removeCssClass("ui-splt-left");
            this.m_panelA.addCssClass("ui-splt-top");
            this.m_panelB.removeCssClass("ui-splt-right");
            this.m_panelB.addCssClass("ui-splt-bottom");
        }
        this.add(this.m_panelA);
        this.add(this.m_panelB);
        this.getActualID();
        this.appendCreateJS("$(document).ready(function() {" + this.getMakeSplitterJavascriptCall() + "});");
    }

    @Override
    public void onAddedToPage(Page p) {
        this.getPage().addHeaderContributor(HeaderContributor.loadJavascript("$js/jquery.splitter.js"), 100);
    }

    @Nonnull
    public String getMakeSplitterJavascriptCall() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.addParamIfPositive(params, this.m_minASize, "minAsize");
        this.addParamIfPositive(params, this.m_maxASize, "maxAsize");
        this.addParamIfPositive(params, this.m_minBSize, "minBsize");
        this.addParamIfPositive(params, this.m_maxBSize, "maxBsize");
        if (this.m_vertical) {
            params.put("splitVertical", "true");
        } else {
            params.put("splitHorizontal", "true");
        }
        params.put("A", "$('#" + this.m_panelA.getActualID() + "')");
        params.put("B", "$('#" + this.m_panelB.getActualID() + "')");
        params.put("closeableto", this.m_closableToPerc + "");
        this.addParamIfPositive(params, this.m_initPosInPerc, "initPos");
        String paramStr = params.entrySet().stream().map(a -> "'" + (String)a.getKey() + "':" + (String)a.getValue()).collect(Collectors.joining(",", "{", "}"));
        return "$('#" + this.getActualID() + "').splitter(" + paramStr + ");";
    }

    @Nonnull
    public String resizeSplitterJavascriptCall() {
        return "$('#" + this.getActualID() + "').trigger(\"resize\");";
    }

    private void addParamIfPositive(@Nonnull Map<String, String> params, int value, @Nonnull String name) {
        if (value > 0) {
            params.put(name, value + "");
        }
    }
}

