/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import to.etc.domui.component.layout.ITabHandle;
import to.etc.domui.component.layout.TabPanelBase;
import to.etc.domui.dom.html.Li;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TextNode;

public class TabBuilder {
    @Nonnull
    private TabPanelBase m_tabPanelBase;
    @Nonnull
    private TabPanelBase.TabInstance m_tabInstance;
    private int m_position;

    protected TabBuilder(@Nonnull TabPanelBase tabPanelBase, @Nonnull TabPanelBase.TabInstance tabInstance) {
        this.m_tabInstance = tabInstance;
        this.m_tabPanelBase = tabPanelBase;
    }

    @Nonnull
    public TabBuilder label(@Nonnull String label) {
        TextNode tn = new TextNode(label);
        this.m_tabInstance.setLabel(tn);
        return this;
    }

    @Nonnull
    public TabBuilder content(@Nonnull NodeBase content) {
        this.m_tabInstance.setContent(content);
        return this;
    }

    @Nonnull
    public TabBuilder image(@Nonnull String image) {
        this.m_tabInstance.setImage(image);
        return this;
    }

    @Nonnull
    public TabBuilder tab(@Nonnull Li tab) {
        this.m_tabInstance.setTab(tab);
        return this;
    }

    @Nonnull
    public TabBuilder lazy() {
        this.m_tabInstance.setLazy(true);
        return this;
    }

    @Nonnull
    public TabBuilder positionTab(int position) {
        this.m_position = position;
        return this;
    }

    @Nonnull
    public TabBuilder closable() {
        this.m_tabInstance.closable(true);
        return this;
    }

    @Nonnull
    public ITabHandle build() {
        this.m_tabPanelBase.addTabToPanel(this.m_tabInstance, this.m_position);
        return this.m_tabInstance;
    }
}

