/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.layout.IDisplayedListener;
import to.etc.domui.component.layout.ITabHandle;
import to.etc.domui.component.layout.TabBuilder;
import to.etc.domui.dom.css.ClearType;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.ATag;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Li;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.util.DomUtil;

public class TabPanelBase
extends Div {
    private List<TabInstance> m_tablist = new ArrayList<TabInstance>();
    private int m_currentTab;
    private boolean m_markErrorTabs = false;
    private ITabSelected m_onTabSelected;
    @Nullable
    private TabBuilder m_tabBuilder;
    private NodeContainer m_contentContainer;

    protected TabPanelBase(boolean markErrorTabs) {
        this.m_markErrorTabs = markErrorTabs;
        if (markErrorTabs) {
            this.setErrorFence();
        }
    }

    protected void renderTabPanels(NodeContainer labelcontainer, NodeContainer contentcontainer) {
        this.m_contentContainer = contentcontainer;
        int index = 0;
        for (TabInstance ti : this.m_tablist) {
            this.renderLabel(labelcontainer, index, ti);
            boolean isselected = this.getCurrentTab() == index;
            NodeBase content = ti.getContent();
            content.addCssClass("ui-tab-pg");
            content.setClear(ClearType.BOTH);
            if (!ti.isLazy() || isselected) {
                ti.setAdded(true);
                contentcontainer.add(content);
                if (isselected) {
                    content.setDisplay(DisplayType.BLOCK);
                    if (content instanceof IDisplayedListener) {
                        ((IDisplayedListener)((Object)content)).onDisplayStateChanged(false);
                    }
                } else {
                    content.setDisplay(DisplayType.NONE);
                }
            }
            ++index;
        }
    }

    protected void renderLabel(NodeContainer into, int index, final TabInstance ti) {
        Li li = ti.getTab();
        Li separator = new Li();
        separator.setCssClass("ui-tab-ibt");
        if (index == 0) {
            separator.addCssClass("ui-tab-ibt-first");
        }
        if (li == null || !li.isAttached()) {
            li = new Li();
            if (ti.isCloseable()) {
                li.setCssClass("ui-tab-close-li");
            } else {
                li.setCssClass("ui-tab-li");
            }
            into.add(separator);
            into.add(li);
            ti.setTab(li);
            ti.setSeparator(separator);
            if (index == this.getCurrentTab()) {
                li.addCssClass("ui-tab-sel");
            } else {
                li.removeCssClass("ui-tab-sel");
            }
        }
        List<Div> divs = li.getChildren(Div.class);
        for (Div div : divs) {
            div.remove();
        }
        Div d = new Div();
        d.setCssClass("ui-tab-div");
        Span dt = new Span();
        d.add(dt);
        if (ti.getImg() != null) {
            dt.add(ti.getImg());
        }
        dt.add(ti.getLabel());
        d.setClicked(new IClicked<Div>(){

            @Override
            public void clicked(@Nonnull Div b) throws Exception {
                TabPanelBase.this.setCurrentTab(ti);
            }
        });
        if (ti.isCloseable()) {
            ATag x = new ATag();
            d.add(x);
            x.setCssClass("ui-tab-close");
            x.setClicked(new IClicked<ATag>(){

                @Override
                public void clicked(@Nonnull ATag b) throws Exception {
                    TabPanelBase.this.closeTab(ti);
                }
            });
        }
        li.add(d);
    }

    public void closeTab(@Nonnull ITabHandle th) throws Exception {
        if (!(th instanceof TabInstance)) {
            throw new IllegalArgumentException("Only instance of TabInstance can be used for closing a tab.");
        }
        TabInstance ti = (TabInstance)th;
        int index = this.m_tablist.indexOf(ti);
        if (index < 0) {
            throw new IllegalArgumentException("Invalid index for closing a tab.");
        }
        if (index == this.getCurrentTab()) {
            int newIndex = this.selectNewCurrentTab(index);
            this.setCurrentTab(newIndex);
        }
        if (index < this.getCurrentTab()) {
            --this.m_currentTab;
        }
        ti.setAdded(false);
        this.m_tablist.remove(index);
        if (this.isBuilt()) {
            ti.getTab().remove();
            ti.getSeparator().remove();
            ti.getContent().remove();
        }
        if (ti.getOnClose() != null) {
            ti.getOnClose().onNotify(ti);
        }
    }

    private int selectNewCurrentTab(int index) {
        if (this.m_tablist.size() == 1) {
            return 0;
        }
        if (index > 0) {
            return --index;
        }
        return ++index;
    }

    @Nonnull
    public TabBuilder tab() throws Exception {
        if (null != this.m_tabBuilder) {
            throw new Exception("A new tab is already created without adding it to the panel (call the build() method on the TabBuilder)");
        }
        this.m_tabBuilder = new TabBuilder(this, new TabInstance());
        return this.m_tabBuilder;
    }

    void addTabToPanel(@Nonnull TabInstance tabInstance, int position) {
        this.m_tabBuilder = null;
        if (this.m_markErrorTabs) {
            DomUtil.getMessageFence(this).addErrorListener(tabInstance);
        }
        if (position == 0) {
            this.m_tablist.add(tabInstance);
        } else {
            this.m_tablist.add(position, tabInstance);
        }
        if (!this.isBuilt()) {
            return;
        }
        this.forceRebuild();
    }

    public void add(NodeBase content, String label) {
        this.add(content, label, false);
    }

    public void add(NodeBase content, String label, boolean lazy) {
        TextNode tn = new TextNode(label);
        this.add(content, (NodeBase)tn, lazy);
    }

    public void add(NodeBase content, String label, String icon) {
        this.add(content, label, icon, false);
    }

    public void add(NodeBase content, String label, String icon, boolean lazy) {
        TextNode tn = new TextNode(label);
        this.add(content, tn, icon, lazy);
    }

    public void add(NodeBase content, NodeBase tablabel) {
        this.add(content, tablabel, false);
    }

    public void add(NodeBase content, NodeBase tablabel, boolean lazy) {
        TabInstance tabInstance = new TabInstance(tablabel, content, null);
        tabInstance.setLazy(lazy);
        this.addTabToPanel(tabInstance, 0);
    }

    public void add(NodeBase content, NodeBase tablabel, String icon) {
        this.add(content, tablabel, icon, false);
    }

    public void add(NodeBase content, NodeBase tablabel, String icon, boolean lazy) {
        TabInstance tabInstance = new TabInstance(tablabel, content, icon);
        tabInstance.setLazy(lazy);
        this.addTabToPanel(tabInstance, 0);
    }

    @Override
    protected void onForceRebuild() {
        super.onForceRebuild();
        for (TabInstance ti : this.m_tablist) {
            if (!ti.isLazy()) continue;
            ti.setAdded(false);
        }
    }

    public int getCurrentTab() {
        return this.m_currentTab;
    }

    protected void internalSetCurrentTab(int index) {
        this.m_currentTab = index;
    }

    public boolean setCurrentTab(@Nonnull ITabHandle tabHandle) throws Exception {
        if (!(tabHandle instanceof TabInstance)) {
            throw new IllegalArgumentException("Only instance of TabInstance can be used for setting the current tab.");
        }
        TabInstance ti = (TabInstance)tabHandle;
        int index = this.m_tablist.indexOf(ti);
        if (index == -1) {
            return false;
        }
        this.setCurrentTab(index);
        return true;
    }

    private void setCurrentTab(@Nonnull TabInstance ti) throws Exception {
        int index = this.m_tablist.indexOf(ti);
        this.setCurrentTab(index);
    }

    public void setCurrentTab(int index) throws Exception {
        if (this.isBuilt()) {
            if (index == this.getCurrentTab() || index < 0 || index >= this.m_tablist.size()) {
                return;
            }
            int oldIndex = this.getCurrentTab();
            TabInstance oldti = this.m_tablist.get(this.getCurrentTab());
            TabInstance newti = this.m_tablist.get(index);
            NodeBase oldc = oldti.getContent();
            oldc.setDisplay(DisplayType.NONE);
            NodeBase newc = newti.getContent();
            if (newti.isLazy() && !newti.isAdded()) {
                this.m_contentContainer.add(newc);
                newti.setAdded(true);
            }
            newc.setDisplay(DisplayType.BLOCK);
            oldti.getTab().removeCssClass("ui-tab-sel");
            newti.getTab().addCssClass("ui-tab-sel");
            if (this.m_onTabSelected != null) {
                this.m_onTabSelected.onTabSelected(this, oldIndex, index);
            }
            if (oldti instanceof IDisplayedListener) {
                ((IDisplayedListener)((Object)oldti)).onDisplayStateChanged(false);
            }
            if (newti instanceof IDisplayedListener) {
                ((IDisplayedListener)((Object)oldti)).onDisplayStateChanged(true);
            }
        }
        this.m_currentTab = index;
    }

    public int getTabCount() {
        return this.m_tablist.size();
    }

    public void setOnTabSelected(ITabSelected onTabSelected) {
        this.m_onTabSelected = onTabSelected;
    }

    public ITabSelected getOnTabSelected() {
        return this.m_onTabSelected;
    }

    public int getTabIndex(NodeBase tabContent) {
        for (TabInstance tab : this.m_tablist) {
            if (tab.getContent() != tabContent) continue;
            return this.m_tablist.indexOf(tab);
        }
        return -1;
    }

    protected void replaceLabel(NodeContainer into, NodeBase tabContent, String tabLabel, String tabIcon) {
        int index = this.getTabIndex(tabContent);
        if (index == -1) {
            return;
        }
        TabInstance tab = this.m_tablist.get(index);
        tab.setLabel(new TextNode(tabLabel));
        tab.setImage(tabIcon);
        this.renderLabel(into, index, tab);
    }

    public static interface ITabSelected {
        public void onTabSelected(TabPanelBase var1, int var2, int var3) throws Exception;
    }

    protected class TabInstance
    implements IErrorMessageListener,
    ITabHandle {
        private NodeBase m_label;
        private NodeBase m_content;
        private Img m_img;
        private Li m_tab;
        private Li m_separator;
        private boolean m_lazy;
        private boolean m_added;
        private boolean m_closable;
        private List<UIMessage> m_msgList = new ArrayList<UIMessage>();
        @Nullable
        private INotify<ITabHandle> m_onClose;

        public TabInstance() {
        }

        public TabInstance(NodeBase label, NodeBase content, String image) {
            this.m_label = label;
            this.m_content = content;
            if (null != image) {
                this.setImage(image);
            }
        }

        public NodeBase getContent() {
            return this.m_content;
        }

        public void setContent(@Nonnull NodeBase content) {
            this.m_content = content;
        }

        public NodeBase getLabel() {
            return this.m_label;
        }

        public void setLabel(@Nonnull NodeBase label) {
            this.m_label = label;
        }

        public Li getTab() {
            return this.m_tab;
        }

        public void setTab(@Nonnull Li tab) {
            this.m_tab = tab;
        }

        public Li getSeparator() {
            return this.m_separator;
        }

        public void setSeparator(@Nonnull Li separator) {
            this.m_separator = separator;
        }

        public Img getImg() {
            return this.m_img;
        }

        public void setImage(@Nonnull Img image) {
            this.m_img = image;
        }

        public void setImage(@Nonnull String image) {
            Img img;
            this.m_img = img = this.createIcon(image);
        }

        public boolean isLazy() {
            return this.m_lazy;
        }

        public void setLazy(boolean lazy) {
            this.m_lazy = lazy;
        }

        public boolean isAdded() {
            return this.m_added;
        }

        protected void setAdded(boolean added) {
            this.m_added = added;
        }

        public boolean isCloseable() {
            return this.m_closable;
        }

        public void closable(boolean closeable) {
            this.m_closable = closeable;
        }

        @Override
        public void setOnClose(INotify<ITabHandle> notify) {
            this.m_onClose = notify;
        }

        public INotify<ITabHandle> getOnClose() {
            return this.m_onClose;
        }

        @Override
        public void errorMessageAdded(@Nonnull UIMessage m) {
            if (this.isPartOfContent(m.getErrorNode())) {
                if (this.m_msgList.contains(m)) {
                    return;
                }
                this.m_msgList.add(m);
                this.adjustUI();
            }
        }

        @Override
        public void errorMessageRemoved(@Nonnull UIMessage m) {
            if (this.isPartOfContent(m.getErrorNode())) {
                if (!this.m_msgList.remove(m)) {
                    return;
                }
                this.adjustUI();
            }
        }

        private final boolean isPartOfContent(@Nullable NodeBase errorNode) {
            while (errorNode != null) {
                if (errorNode == this.m_content) {
                    return true;
                }
                if (!errorNode.hasParent()) {
                    return false;
                }
                errorNode = errorNode.getParent();
            }
            return false;
        }

        private void adjustUI() {
            if (this.hasErrors()) {
                this.m_tab.addCssClass("ui-tab-err");
            } else {
                this.m_tab.removeCssClass("ui-tab-err");
            }
        }

        public boolean hasErrors() {
            return this.m_msgList.size() > 0;
        }

        private Img createIcon(String icon) {
            Img i = new Img();
            i.setSrc(icon);
            i.setCssClass("ui-tab-icon");
            i.setBorder(0);
            return i;
        }
    }
}

