/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.layout.FloatingDiv;
import to.etc.domui.dom.css.FloatType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.DomUtil;

public class Window
extends FloatingDiv {
    private NodeContainer m_titleBar;
    private Div m_content;
    @Nullable
    private String m_windowTitle;
    private boolean m_closable = true;
    private Img m_closeButton;
    private Img m_titleIcon;
    private Div m_topContent;
    private Div m_bottomContent;

    public Window() {
        this.init();
    }

    public Window(boolean modal, boolean resizable, int width, int height, @Nullable String title) {
        super(modal, resizable, width, height);
        if (null != title) {
            this.setWindowTitle(title);
        }
        this.init();
    }

    public Window(boolean modal, boolean resizable, String title) {
        super(modal, resizable);
        if (null != title) {
            this.setWindowTitle(title);
        }
        this.init();
    }

    public Window(boolean resizable, String title) {
        this(true, resizable, title);
    }

    public Window(String title) {
        this(true, false, title);
    }

    public Window(int width, int height, String title) {
        this(true, true, width, height, title);
    }

    @Override
    @Nonnull
    public Window size(int width, int height) {
        super.size(width, height);
        return this;
    }

    @Override
    @Nonnull
    public Window resizable() {
        super.resizable();
        return this;
    }

    @Override
    @Nonnull
    public Window modal(boolean yes) {
        super.modal(yes);
        return this;
    }

    @Override
    @Nonnull
    public Window modal() {
        super.modal();
        return this;
    }

    @Nonnull
    public Window title(@Nonnull String set) {
        this.setWindowTitle(set);
        return this;
    }

    @Override
    @Nonnull
    public Window width(int pxsl) {
        super.width(pxsl);
        return this;
    }

    private void init() {
        this.m_content = new Div();
        this.m_content.addCssClass("ui-flw-c ui-fixovfl");
        this.m_topContent = new Div();
        this.m_topContent.addCssClass("ui-flw-tc");
        this.m_bottomContent = new Div();
        this.m_bottomContent.addCssClass("ui-flw-bc");
        this.setErrorFence();
        this.delegateTo(this.m_content);
        this.m_content.setErrorFence();
    }

    @Override
    protected void createFrame() throws Exception {
        this.getPage().calculateDefaultFocus(this);
        this.m_titleBar = new Div();
        this.add(this.m_titleBar);
        this.createTitleBar();
        this.add(this.m_topContent);
        this.add(this.m_content);
        this.add(this.m_bottomContent);
        this.setErrorFence();
        if (this.getHeight() != null) {
            this.m_content.setStretchHeight(true);
        }
        this.appendCreateJS("$('#" + this.getActualID() + "').draggable({ghosting: false, zIndex:" + this.getZIndex() + ", handle: '#" + this.m_titleBar.getActualID() + "', stop: WebUI.notifySizePositionChanged});");
        this.delegateTo(this.m_content);
    }

    @Override
    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        if (null != this.m_content && this.getHeight() != null) {
            this.m_content.setStretchHeight(true);
        }
    }

    protected void createTitleBar() {
        if (this.m_titleBar == null) {
            return;
        }
        this.m_titleBar.removeAllChildren();
        this.m_titleBar.setCssClass("ui-flw-ttl");
        if (this.m_closable) {
            this.m_closeButton = new Img();
            this.m_closeButton.setSrc("THEME/close.png");
            this.m_closeButton.setFloat(FloatType.RIGHT);
            this.m_closeButton.setCssClass("ui-flw-btn-close");
            this.m_titleBar.add(this.m_closeButton);
            this.m_closeButton.setClicked(new IClicked<NodeBase>(){

                @Override
                public void clicked(@Nonnull NodeBase b) throws Exception {
                    Window.this.closePressed();
                }
            });
        }
        if (this.m_titleIcon != null) {
            this.m_titleBar.add(this.m_titleIcon);
        }
        this.m_titleBar.add(this.getWindowTitle());
    }

    private Img createIcon() {
        if (this.m_titleIcon == null) {
            this.m_titleIcon = new Img();
            this.m_titleIcon.setBorder(0);
            this.m_titleIcon.setCssClass("ui-flw-ttl-icon");
            if (this.m_titleBar != null) {
                if (this.m_closeButton != null && this.m_titleBar.getChildCount() > 0 && this.m_titleBar.getChild(0) == this.m_closeButton) {
                    this.m_titleBar.add(1, this.m_titleIcon);
                } else {
                    this.m_titleBar.add(0, this.m_titleIcon);
                }
            }
        }
        return this.m_titleIcon;
    }

    public boolean isClosable() {
        return this.m_closable;
    }

    public void setClosable(boolean closable) {
        if (this.m_closable == closable) {
            return;
        }
        this.m_closable = closable;
    }

    public String getWindowTitle() {
        return this.m_windowTitle;
    }

    public void setWindowTitle(String windowTitle) {
        if (DomUtil.isEqual((Object)windowTitle, (Object)this.m_windowTitle)) {
            return;
        }
        this.m_windowTitle = windowTitle;
        if (this.m_titleBar != null) {
            this.createTitleBar();
        }
    }

    public void setIcon(String ico) {
        this.createIcon().setSrc(ico);
    }

    public Div getBottomContent() {
        return this.m_bottomContent;
    }

    public Div getTopContent() {
        return this.m_topContent;
    }
}

