/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout.title;

import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.annotations.UIMenu;
import to.etc.domui.component.buttons.HoverButton;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.layout.ErrorMessageDiv;
import to.etc.domui.component.layout.title.BasePageTitleBar;
import to.etc.domui.component.misc.OddCharacters;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.state.IShelvedEntry;
import to.etc.domui.state.UIGoto;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.util.WrappedException;

public class AppPageTitleBar
extends BasePageTitleBar {
    private final boolean m_catchError;
    @Nonnull
    private final Img m_img = new Img();
    private TD m_buttonpart = new TD();
    private TD m_titlePart;
    private String m_imageUrl;
    private String m_hint;
    @Deprecated
    private INodeContentRenderer<String> m_titleNodeRenderer;
    private IErrorFence m_errorFence;
    private ErrorMessageDiv m_errorThingy = new ErrorMessageDiv();
    private Table m_titleTable;
    private TBody m_body;
    private boolean m_showBackButton;

    public AppPageTitleBar(boolean catchError) {
        this.m_catchError = catchError;
    }

    public AppPageTitleBar(String title, boolean catchError) {
        super(title);
        this.m_catchError = catchError;
    }

    public AppPageTitleBar(String icon, String title, boolean catchError) {
        super(title);
        this.setIcon(icon);
        this.m_catchError = catchError;
    }

    public boolean isCatchError() {
        return this.m_catchError;
    }

    public void setIcon(String s) {
        this.m_imageUrl = s;
        this.m_img.setDisplay(s == null ? DisplayType.NONE : DisplayType.INLINE);
    }

    public String getHint() {
        return this.m_hint;
    }

    public void setHint(String hint) {
        this.m_hint = hint;
    }

    public boolean isShowBackButton() {
        return this.m_showBackButton;
    }

    @Nonnull
    public AppPageTitleBar setShowBackButton(boolean showBackButton) {
        this.m_showBackButton = showBackButton;
        return this;
    }

    @Nonnull
    public TBody getBody() {
        if (null != this.m_body) {
            return this.m_body;
        }
        throw new IllegalStateException("Body null: call after createContent");
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.m_titleTable = new Table();
        this.add(this.m_titleTable);
        this.m_body = new TBody();
        this.setCssClass("ui-atl");
        this.m_titleTable.add(this.m_body);
        this.m_titleTable.setCellPadding("0");
        this.m_titleTable.setCellSpacing("0");
        this.m_titleTable.setTableBorder(0);
        TR tr = this.m_body.addRow();
        this.m_body.add(tr);
        TD td = this.m_body.addCell();
        if (this.m_showBackButton) {
            this.addBackOrCloseButton(td);
        }
        this.setIconURL();
        if (DomUtil.isBlank(this.m_img.getSrc())) {
            this.m_img.setDisplay(DisplayType.NONE);
        }
        this.m_img.setAlign(ImgAlign.LEFT);
        td.add(this.m_img);
        td.setCssClass("ui-atl-i");
        this.m_titlePart = td = this.m_body.addCell();
        td.setCssClass("ui-atl-t");
        td.setTestID("pageTitle");
        this.renderTitleCell();
        this.m_body.row().add(this.m_buttonpart);
        this.m_buttonpart.setCssClass("ui-atl-bb");
        this.addDefaultButtons(this.m_buttonpart);
        if (this.isCatchError()) {
            int cspan = AppPageTitleBar.calcColSpan(this.m_titleTable.getBody());
            TD c = this.m_titleTable.getBody().addRowAndCell();
            c.add(this.m_errorThingy);
            c.setColspan(cspan);
        }
    }

    private void addBackOrCloseButton(@Nonnull TD td) {
        List<IShelvedEntry> ps = this.getPage().getConversation().getWindowSession().getShelvedPageStack();
        if (ps.size() > 1) {
            IShelvedEntry se = ps.get(ps.size() - 2);
            if (se.isClose()) {
                this.addCloseButton(td);
                return;
            }
        } else {
            this.addCloseButton(td);
            return;
        }
        this.addBackButton(td);
    }

    private void addBackButton(@Nonnull TD td) {
        HoverButton backButton = new HoverButton("THEME/72x24_back.png", new IClicked<HoverButton>(){

            @Override
            public void clicked(@Nonnull HoverButton clickednode) throws Exception {
                UIGoto.back();
            }
        });
        td.add(backButton);
    }

    private void addCloseButton(@Nonnull TD td) {
        HoverButton button = new HoverButton("THEME/72x24_close.png", new IClicked<HoverButton>(){

            @Override
            public void clicked(@Nonnull HoverButton clickednode) throws Exception {
                AppPageTitleBar.this.getPage().getBody().closeWindow();
            }
        });
        td.add(button);
    }

    @Override
    public void onAddedToPage(Page p) {
        super.onAddedToPage(p);
        if (!this.isCatchError()) {
            return;
        }
        this.m_errorFence = DomUtil.getMessageFence(this);
        this.m_errorFence.addErrorListener(this.m_errorThingy);
    }

    @Override
    public void onRemoveFromPage(Page p) {
        super.onRemoveFromPage(p);
        if (!this.isCatchError()) {
            return;
        }
        this.m_errorFence.removeErrorListener(this.m_errorThingy);
    }

    private static int calcColSpan(TBody b) {
        int maxcol = 1;
        for (NodeBase nb : b) {
            TR row = (TR)nb;
            int thiscol = 0;
            for (NodeBase ntd : row) {
                TD td = (TD)ntd;
                if (td.getColspan() <= 1) {
                    ++thiscol;
                    continue;
                }
                thiscol += td.getColspan();
            }
            if (thiscol <= maxcol) continue;
            maxcol = thiscol;
        }
        return maxcol;
    }

    public TD getButtonpart() {
        return this.m_buttonpart;
    }

    private void setIconURL() {
        String cn;
        if (this.m_imageUrl != null) {
            this.m_img.setSrc(this.m_imageUrl);
            return;
        }
        Class<?> clz = this.getPage().getBody().getClass();
        UIMenu ma = clz.getAnnotation(UIMenu.class);
        if (ma != null && ma.iconName() != null) {
            if (ma.iconBase() != Object.class) {
                this.m_img.setSrc(ma.iconBase(), ma.iconName());
            } else {
                this.m_img.setSrc(ma.iconName());
            }
        }
        if (DomUtil.hasResource(clz, cn = DomUtil.getClassNameOnly(clz) + ".png")) {
            this.m_img.setSrc(clz, cn);
            return;
        }
        String def = this.getDefaultIcon();
        if (def == null) {
            return;
        }
        this.m_img.setSrc(def);
    }

    public String getDefaultIcon() {
        return null;
    }

    @Override
    public void setPageTitle(String ttl) {
        if (DomUtil.isEqual((Object)this.getPageTitle(), (Object)ttl)) {
            return;
        }
        super.setPageTitle(ttl);
        if (this.isBuilt()) {
            this.renderTitleCell();
        }
    }

    public void addButton(String image, String hint, IClicked<NodeBase> handler) {
        SmallImgButton ib = new SmallImgButton(image);
        this.getButtonpart().add(ib);
        ib.setTitle(hint);
        ib.setClicked(handler);
    }

    protected void addDefaultButtons(NodeContainer nc) {
        SmallImgButton ib = new SmallImgButton("THEME/btnSpecialChar.png");
        nc.add(ib);
        ib.setTitle("Toon lijst van bijzondere tekens");
        ib.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase b) throws Exception {
                OddCharacters oc = new OddCharacters();
                AppPageTitleBar.this.getPage().getBody().add(oc);
            }
        });
    }

    public TD getTitlePart() {
        return this.m_titlePart;
    }

    @Override
    public void setShowAsModified(boolean showAsModified) {
        if (super.isShowAsModified() != showAsModified) {
            super.setShowAsModified(showAsModified);
            if (this.isBuilt()) {
                this.renderTitleCell();
            }
        }
    }

    private void renderTitleCell() {
        TD titleCell = this.getTitlePart();
        if (this.m_titleNodeRenderer != null) {
            try {
                this.m_titleNodeRenderer.renderNodeContent(this, titleCell, this.getPageTitle(), this.isShowAsModified());
            }
            catch (Exception x) {
                throw WrappedException.wrap((Exception)x);
            }
        } else {
            this.internalRenderTitle();
        }
    }

    private void internalRenderTitle() {
        TD titleCell = this.getTitlePart();
        titleCell.removeAllChildren();
        if (this.isShowAsModified()) {
            titleCell.add("*" + this.getPageTitle());
        } else {
            titleCell.add(this.getPageTitle());
        }
        if (!DomUtil.isBlank(this.getHint())) {
            titleCell.setTitle(this.getHint());
        }
    }

    public INodeContentRenderer<String> getTitleNodeRenderer() {
        return this.m_titleNodeRenderer;
    }
}

