/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.LookupFactoryDate;
import to.etc.domui.component.lookup.LookupFactoryEnumAndBool;
import to.etc.domui.component.lookup.LookupFactoryNumber;
import to.etc.domui.component.lookup.LookupFactoryNumber2;
import to.etc.domui.component.lookup.LookupFactoryRelation;
import to.etc.domui.component.lookup.LookupFactoryRelationCombo;
import to.etc.domui.component.lookup.LookupFactoryString;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.NodeBase;

public final class LookupControlRegistry {
    @Nonnull
    private List<ILookupControlFactory> m_factoryList = new ArrayList<ILookupControlFactory>();

    public LookupControlRegistry() {
        this.register(new LookupFactoryString());
        this.register(new LookupFactoryDate());
        this.register(new LookupFactoryNumber());
        this.register(new LookupFactoryNumber2());
        this.register(new LookupFactoryRelation());
        this.register(new LookupFactoryEnumAndBool());
        this.register(new LookupFactoryRelationCombo());
    }

    @Nonnull
    public synchronized List<ILookupControlFactory> getFactoryList() {
        return this.m_factoryList;
    }

    public synchronized void register(@Nonnull ILookupControlFactory f) {
        this.m_factoryList = new ArrayList<ILookupControlFactory>(this.m_factoryList);
        this.m_factoryList.add(f);
    }

    @Nullable
    public ILookupControlFactory findFactory(@Nonnull SearchPropertyMetaModel pmm) {
        ILookupControlFactory best = null;
        int score = 0;
        for (ILookupControlFactory cf : this.getFactoryList()) {
            int v = cf.accepts(pmm, null);
            if (v <= score) continue;
            score = v;
            best = cf;
        }
        return best;
    }

    @Nonnull
    public ILookupControlFactory getControlFactory(@Nonnull SearchPropertyMetaModel pmm) {
        ILookupControlFactory cf = this.findFactory(pmm);
        if (cf == null) {
            throw new IllegalStateException("Cannot get a Lookup Control factory for " + pmm);
        }
        return cf;
    }

    @Nonnull
    public <T, X extends NodeBase> ILookupControlFactory getLookupQueryFactory(@Nonnull SearchPropertyMetaModel pmm, @Nonnull X control) {
        ILookupControlFactory best = null;
        int score = 0;
        for (ILookupControlFactory cf : this.getFactoryList()) {
            int v = cf.accepts(pmm, (IControl)((Object)control));
            if (v <= score) continue;
            score = v;
            best = cf;
        }
        if (best == null) {
            throw new IllegalStateException("Cannot get a Lookup Control QueryFragment factory for " + pmm + " and control " + control);
        }
        return best;
    }
}

