/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.util.Date;
import javax.annotation.Nonnull;
import to.etc.domui.component.input.DateInput;
import to.etc.domui.component.lookup.BaseAbstractLookupControlImpl;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.component.lookup.filter.DateFromTo;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.TemporalPresentationType;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Span;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.util.DateUtil;
import to.etc.webapp.query.QCriteria;

final class LookupFactoryDate
implements ILookupControlFactory {
    LookupFactoryDate() {
    }

    @Override
    public <T, X extends IControl<T>> ILookupControlInstance<?> createControl(final @Nonnull SearchPropertyMetaModel spm, X control) {
        String value;
        if (spm == null) {
            throw new IllegalStateException("? SearchPropertyModel should not be null here.");
        }
        PropertyMetaModel<?> pmm = spm != null && spm.getPropertyPath() != null && spm.getPropertyPath().size() > 0 ? spm.getPropertyPath().get(spm.getPropertyPath().size() - 1) : null;
        boolean withTime = false;
        if (pmm != null && pmm.getTemporal() == TemporalPresentationType.DATETIME && null != (value = DomUtil.getHintValue(pmm.getComponentTypeHint(), "time"))) {
            withTime = true;
        }
        final DateInput dateFrom = new DateInput();
        dateFrom.setWithTime(withTime);
        Span sp = new Span(" " + Msgs.BUNDLE.getString("ui.date.till") + " ");
        sp.setFontWeight("BOLD");
        final DateInput dateTo = new DateInput();
        dateTo.setWithTime(withTime);
        String hint = MetaUtils.findHintText(spm);
        if (hint != null) {
            dateFrom.setTitle(hint);
            dateTo.setTitle(hint);
        }
        return new BaseAbstractLookupControlImpl<DateFromTo>(new NodeBase[]{dateFrom, sp, dateTo}){

            @Override
            @Nonnull
            public ILookupControlInstance.AppendCriteriaResult appendCriteria(@Nonnull QCriteria<?> crit) throws Exception {
                Date till;
                Date from;
                if (spm == null) {
                    throw new IllegalStateException("? SearchPropertyModel should not be null here.");
                }
                try {
                    from = (Date)dateFrom.getValue();
                    if (from != null && !dateFrom.isWithTime()) {
                        from = DateUtil.truncateDate((Date)from);
                    }
                }
                catch (Exception x) {
                    return ILookupControlInstance.AppendCriteriaResult.INVALID;
                }
                try {
                    till = (Date)dateTo.getValue();
                    if (till != null && !dateTo.isWithTime()) {
                        till = DateUtil.truncateDate((Date)DateUtil.incrementDate((Date)till, (int)5, (int)1));
                    }
                }
                catch (Exception x) {
                    return ILookupControlInstance.AppendCriteriaResult.INVALID;
                }
                if (from == null && till == null) {
                    return ILookupControlInstance.AppendCriteriaResult.EMPTY;
                }
                if (from != null && till != null) {
                    if (from.getTime() > till.getTime()) {
                        dateFrom.setValue(till);
                        dateTo.setValue(from);
                        Date tmp = from;
                        from = till;
                        till = tmp;
                    }
                    crit.ge(spm.getPropertyName(), (Object)from);
                    crit.lt(spm.getPropertyName(), (Object)till);
                } else if (from != null) {
                    crit.ge(spm.getPropertyName(), (Object)from);
                } else if (till != null) {
                    crit.lt(spm.getPropertyName(), (Object)till);
                } else {
                    throw new IllegalStateException("Logic error");
                }
                return ILookupControlInstance.AppendCriteriaResult.VALID;
            }

            @Override
            public void clearInput() {
                dateFrom.setValue(null);
                dateTo.setValue(null);
            }

            @Override
            public DateFromTo getValue() {
                if (dateFrom.getValue() == null && dateTo.getValue() == null) {
                    return null;
                }
                return new DateFromTo((Date)dateFrom.getValue(), (Date)dateTo.getValue());
            }

            @Override
            public void setValue(DateFromTo value) throws Exception {
                if (value == null) {
                    dateFrom.setValue(null);
                    dateTo.setValue(null);
                    return;
                }
                dateFrom.setValue(value.getDateFrom());
                dateTo.setValue(value.getDateTo());
            }
        };
    }

    @Override
    public <T, X extends IControl<T>> int accepts(@Nonnull SearchPropertyMetaModel spm, X control) {
        PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
        if (Date.class.isAssignableFrom(pmm.getActualType()) && control == null) {
            return 2;
        }
        return 0;
    }
}

