/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import to.etc.domui.component.input.ComboFixed;
import to.etc.domui.component.input.ValueLabelPair;
import to.etc.domui.component.lookup.EqLookupControlImpl;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.dom.html.IControl;
import to.etc.webapp.nls.NlsContext;

final class LookupFactoryEnumAndBool
implements ILookupControlFactory {
    LookupFactoryEnumAndBool() {
    }

    @Override
    public <T, X extends IControl<T>> int accepts(@Nonnull SearchPropertyMetaModel spm, X control) {
        PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
        Class<?> iclz = pmm.getActualType();
        return iclz == Boolean.class || iclz == Boolean.TYPE || Enum.class.isAssignableFrom(iclz) ? 2 : 0;
    }

    @Override
    public <T, X extends IControl<T>> ILookupControlInstance<?> createControl(@Nonnull SearchPropertyMetaModel spm, X control) {
        Object ctlnode = control;
        if (ctlnode == null) {
            String hint;
            PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
            Object[] vals = pmm.getDomainValues();
            if (null == vals) {
                throw new IllegalStateException(pmm + ": no domainValues");
            }
            ClassMetaModel ecmm = null;
            ArrayList vl = new ArrayList();
            for (Object o : vals) {
                String label = pmm.getDomainValueLabel(NlsContext.getLocale(), o);
                if (label == null) {
                    if (ecmm == null) {
                        ecmm = MetaManager.findClassMeta(pmm.getActualType());
                    }
                    if ((label = ecmm.getDomainLabel(NlsContext.getLocale(), o)) == null) {
                        label = o == null ? "" : o.toString();
                    }
                }
                vl.add(new ValueLabelPair<Object>(o, label));
            }
            ComboFixed c = new ComboFixed(vl);
            String s = pmm.getDefaultHint();
            if (s != null) {
                c.setTitle(s);
            }
            if ((hint = MetaUtils.findHintText(spm)) != null) {
                c.setTitle(hint);
            }
            ctlnode = c;
        }
        return new EqLookupControlImpl(spm.getPropertyName(), ctlnode);
    }
}

