/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import to.etc.domui.component.input.ComboFixed;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.input.ValueLabelPair;
import to.etc.domui.component.lookup.AbstractLookupControlImpl;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.component.lookup.NumericRelationType;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyMetaValidator;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.NlsContext;
import to.etc.webapp.query.QCriteria;

final class LookupFactoryNumber
implements ILookupControlFactory {
    LookupFactoryNumber() {
    }

    @Override
    public <T, X extends IControl<T>> ILookupControlInstance<?> createControl(final @Nonnull SearchPropertyMetaModel spm, X control) {
        if (control != null) {
            throw new IllegalStateException();
        }
        PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
        ArrayList values = new ArrayList();
        for (NumericRelationType relationEnum : NumericRelationType.values()) {
            values.add(new ValueLabelPair<NumericRelationType>(relationEnum, MetaManager.findClassMeta(NumericRelationType.class).getDomainLabel(NlsContext.getLocale(), (Object)relationEnum)));
        }
        final Text<?> numA = this.createNumericInput(pmm);
        final Text<?> numB = this.createNumericInput(pmm);
        numB.setDisplay(DisplayType.NONE);
        final ComboFixed relationCombo = new ComboFixed(values);
        relationCombo.setOnValueChanged(new IValueChanged<ComboFixed<NumericRelationType>>(){

            @Override
            public void onValueChanged(@Nonnull ComboFixed<NumericRelationType> component) throws Exception {
                if (component.getValue() == NumericRelationType.BETWEEN) {
                    if (numB.getDisplay() == DisplayType.NONE) {
                        numB.setDisplay(DisplayType.INLINE);
                    }
                } else if (numB.getDisplay() != DisplayType.NONE) {
                    numB.setDisplay(DisplayType.NONE);
                }
            }
        });
        String hint = MetaUtils.findHintText(spm);
        if (hint != null) {
            numA.setTitle(hint);
            numB.setTitle(hint);
        }
        return new AbstractLookupControlImpl(new NodeBase[]{relationCombo, numA, numB}){

            @Override
            @Nonnull
            public ILookupControlInstance.AppendCriteriaResult appendCriteria(@Nonnull QCriteria<?> crit) throws Exception {
                NumericRelationType relation = (NumericRelationType)((Object)relationCombo.getValue());
                if (relation == null) {
                    return ILookupControlInstance.AppendCriteriaResult.EMPTY;
                }
                if (null == numA.getValueSafe()) {
                    return ILookupControlInstance.AppendCriteriaResult.INVALID;
                }
                if (relation == NumericRelationType.BETWEEN && numB.getValueSafe() == null) {
                    return ILookupControlInstance.AppendCriteriaResult.INVALID;
                }
                Object vala = numA.getValue();
                if (vala == null) {
                    return ILookupControlInstance.AppendCriteriaResult.EMPTY;
                }
                switch (relation) {
                    default: {
                        throw new IllegalStateException((Object)((Object)relation) + ": unhandled case");
                    }
                    case EQ: {
                        crit.eq(spm.getPropertyName(), vala);
                        break;
                    }
                    case LT: {
                        crit.lt(spm.getPropertyName(), vala);
                        break;
                    }
                    case LE: {
                        crit.le(spm.getPropertyName(), vala);
                        break;
                    }
                    case GT: {
                        crit.gt(spm.getPropertyName(), vala);
                        break;
                    }
                    case GE: {
                        crit.ge(spm.getPropertyName(), vala);
                        break;
                    }
                    case NOT_EQ: {
                        crit.ne(spm.getPropertyName(), vala);
                        break;
                    }
                    case BETWEEN: {
                        Object numb = numB.getValue();
                        if (null == numb) {
                            return ILookupControlInstance.AppendCriteriaResult.INVALID;
                        }
                        crit.between(spm.getPropertyName(), vala, numb);
                    }
                }
                return ILookupControlInstance.AppendCriteriaResult.VALID;
            }
        };
    }

    private <T> Text<T> createNumericInput(PropertyMetaModel<T> pmm) {
        String s;
        Class<T> iclz = pmm.getActualType();
        Text<T> numText = new Text<T>(iclz);
        if (pmm.getDisplayLength() > 0) {
            numText.setSize(pmm.getDisplayLength());
        } else if (pmm.getPrecision() > 0) {
            int size = pmm.getPrecision();
            int d = size++;
            if (pmm.getScale() > 0 && (d -= pmm.getScale()) >= 4) {
                int nd = (d - 1) / 3;
                size += nd;
            }
            numText.setSize(size);
        } else if (pmm.getLength() > 0) {
            numText.setSize(pmm.getLength() < 40 ? pmm.getLength() : 40);
        }
        IConverter<T> cvt = ConverterRegistry.findBestConverter(pmm);
        numText.setConverter(cvt);
        if (pmm.getLength() > 0) {
            numText.setMaxLength(pmm.getLength());
        }
        if ((s = pmm.getDefaultHint()) != null) {
            numText.setTitle(s);
        }
        for (PropertyMetaValidator mpv : pmm.getValidators()) {
            numText.addValidator(mpv);
        }
        return numText;
    }

    @Override
    public <T, X extends IControl<T>> int accepts(@Nonnull SearchPropertyMetaModel spm, X control) {
        if (control != null) {
            return -1;
        }
        PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
        if (DomUtil.isIntegerType(pmm.getActualType()) || DomUtil.isRealType(pmm.getActualType()) || pmm.getActualType() == BigDecimal.class) {
            String cth = pmm.getComponentTypeHint();
            if (cth != null && cth.toLowerCase().contains("numberlookupcombo")) {
                return 8;
            }
            return 2;
        }
        return -1;
    }
}

