/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.component.lookup.LookupNumberControl;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.dom.css.TextAlign;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.util.DomUtil;

final class LookupFactoryNumber2
implements ILookupControlFactory {
    LookupFactoryNumber2() {
    }

    @Override
    public <T, X extends IControl<T>> int accepts(@Nonnull SearchPropertyMetaModel spm, X control) {
        PropertyMetaModel<?> pmm;
        if (control != null) {
            if (!(control instanceof Text)) {
                return -1;
            }
            Text t = (Text)control;
            if (t.getActualType() != String.class) {
                return -1;
            }
        }
        return DomUtil.isIntegerType((pmm = MetaUtils.getLastProperty(spm)).getActualType()) || DomUtil.isRealType(pmm.getActualType()) || pmm.getActualType() == BigDecimal.class ? 4 : -1;
    }

    @Override
    public <T, X extends IControl<T>> ILookupControlInstance<?> createControl(@Nonnull SearchPropertyMetaModel spm, X control) {
        PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
        Text<String> numText = (Text<String>)control;
        if (numText == null) {
            String hint;
            numText = new Text<String>(String.class);
            if (pmm.getDisplayLength() > 0) {
                numText.setSize(pmm.getDisplayLength() + 5);
            } else if (pmm.getPrecision() > 0) {
                int size = pmm.getPrecision();
                int d = size++;
                if (pmm.getScale() > 0 && (d -= pmm.getScale()) >= 4) {
                    int nd = (d - 1) / 3;
                    size += nd;
                }
                numText.setSize(size + 5);
            } else if (pmm.getLength() > 0) {
                numText.setSize(pmm.getLength() < 40 ? pmm.getLength() + 5 : 40);
            }
            String s = pmm.getDefaultHint();
            if (s != null) {
                numText.setTitle(s);
            }
            if ((hint = MetaUtils.findHintText(spm)) != null) {
                numText.setTitle(hint);
            }
        }
        Double minmax = LookupFactoryNumber2.calcMaxValue(pmm);
        boolean monetary = NumericPresentation.isMonetary(pmm.getNumericPresentation());
        if (monetary) {
            numText.setTextAlign(TextAlign.RIGHT);
        }
        return new LookupNumberControl(pmm.getActualType(), numText, spm.getPropertyName(), -minmax.doubleValue(), minmax, monetary, !pmm.isTransient(), pmm.getScale());
    }

    private static double calcMaxValue(PropertyMetaModel<?> pmm) {
        int prec = pmm.getPrecision();
        if (prec > 0) {
            int scale = pmm.getScale();
            if (scale > 0 && scale < prec) {
                prec -= scale;
            }
            double val = Math.pow(10.0, prec);
            return val;
        }
        return Double.MAX_VALUE;
    }
}

