/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import javax.annotation.Nonnull;
import to.etc.domui.component.input.ComboLookup;
import to.etc.domui.component.lookup.EqLookupControlImpl;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.dom.html.IControl;
import to.etc.util.WrappedException;

final class LookupFactoryRelationCombo
implements ILookupControlFactory {
    LookupFactoryRelationCombo() {
    }

    @Override
    public <T, X extends IControl<T>> int accepts(@Nonnull SearchPropertyMetaModel spm, X control) {
        PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
        if (pmm.getRelationType() != PropertyRelationType.UP) {
            return -1;
        }
        if (control == null && "comboLookup".equals(pmm.getComponentTypeHint())) {
            return 10;
        }
        return 2;
    }

    @Override
    public <T, X extends IControl<T>> ILookupControlInstance<?> createControl(@Nonnull SearchPropertyMetaModel spm, X control) {
        Object input = control;
        if (input == null) {
            PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
            try {
                String hint;
                ComboLookup<?> co = ComboLookup.createLookup(pmm);
                co.setMandatory(false);
                String s = pmm.getDefaultHint();
                if (s != null) {
                    co.setTitle(s);
                }
                if ((hint = MetaUtils.findHintText(spm)) != null) {
                    co.setTitle(hint);
                }
                input = co;
            }
            catch (Exception x) {
                throw WrappedException.wrap((Exception)x);
            }
        }
        return new EqLookupControlImpl(spm.getPropertyName(), input);
    }
}

