/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import javax.annotation.Nonnull;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.lookup.BaseAbstractLookupControlImpl;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.NodeBase;
import to.etc.webapp.query.QCriteria;

final class LookupFactoryString
implements ILookupControlFactory {
    LookupFactoryString() {
    }

    @Override
    public <T, X extends IControl<T>> int accepts(@Nonnull SearchPropertyMetaModel spm, X control) {
        if (control != null) {
            if (!(control instanceof Text)) {
                return -1;
            }
            Text t = (Text)control;
            if (t.getActualType() != String.class) {
                return -1;
            }
        }
        return 1;
    }

    public <T, X extends IControl<T>> ILookupControlInstance<T> createControl(final @Nonnull SearchPropertyMetaModel spm, X control) {
        String hint;
        int sz;
        PropertyMetaModel<?> pmm = MetaUtils.getLastProperty(spm);
        Class<?> iclz = pmm.getActualType();
        if (iclz == Boolean.class || iclz == Boolean.TYPE) {
            throw new IllegalStateException("I need a tri-state checkbox component to handle boolean lookup thingies.");
        }
        final Text txt = new Text(iclz);
        if (pmm.getDisplayLength() > 0) {
            sz = pmm.getDisplayLength();
            if (sz > 40) {
                sz = 40;
            }
            txt.setSize(sz);
        } else {
            sz = 0;
            if (pmm.getLength() > 0 && (sz = pmm.getLength()) > 40) {
                sz = 40;
            }
            if (sz != 0) {
                txt.setSize(sz);
            }
        }
        if (pmm.getConverter() != null) {
            txt.setConverter(pmm.getConverter());
        }
        if (pmm.getLength() > 0) {
            txt.setMaxLength(pmm.getLength());
        }
        if ((hint = MetaUtils.findHintText(spm)) != null) {
            txt.setTitle(hint);
        }
        return new BaseAbstractLookupControlImpl<T>(new NodeBase[]{txt}){

            @Override
            @Nonnull
            public ILookupControlInstance.AppendCriteriaResult appendCriteria(@Nonnull QCriteria<?> crit) throws Exception {
                Object value = null;
                try {
                    value = txt.getValue();
                }
                catch (Exception x) {
                    return ILookupControlInstance.AppendCriteriaResult.INVALID;
                }
                if (value == null || value instanceof String && ((String)value).trim().length() == 0) {
                    return ILookupControlInstance.AppendCriteriaResult.EMPTY;
                }
                if (value instanceof String) {
                    String str = value;
                    str = str.trim().replace("*", "%") + "%";
                    crit.ilike(spm.getPropertyName(), (Object)str);
                } else {
                    crit.eq(spm.getPropertyName(), value);
                }
                return ILookupControlInstance.AppendCriteriaResult.VALID;
            }

            @Override
            public T getValue() {
                return txt.getValue();
            }

            @Override
            public void setValue(T value) {
                txt.setValue(value);
            }
        };
    }
}

