/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.controlfactory.ControlBuilder;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.input.IQueryFactory;
import to.etc.domui.component.layout.ButtonFactory;
import to.etc.domui.component.layout.CaptionedPanel;
import to.etc.domui.component.layout.IButtonContainer;
import to.etc.domui.component.lookup.AbstractLookupControlImpl;
import to.etc.domui.component.lookup.ILookupControlFactory;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.component.lookup.ILookupFilterHandler;
import to.etc.domui.component.lookup.LookupFormSavedFilterFragment;
import to.etc.domui.component.lookup.SaveSearchFilterDialog;
import to.etc.domui.component.lookup.SavedFilter;
import to.etc.domui.component.lookup.filter.LookupFilterTranslator;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.impl.SearchPropertyMetaModelImpl;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.css.VerticalAlignType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClickBase;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IReturnPressed;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TableVAlign;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.query.QContextManager;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QRestrictor;

public class LookupForm<T>
extends Div
implements IButtonContainer {
    @Nullable
    private QCriteria<T> m_rootCriteria = null;
    @Nonnull
    private Class<T> m_lookupClass;
    @Nonnull
    private ClassMetaModel m_metaModel;
    private String m_title;
    private IClicked<LookupForm<T>> m_clicker;
    private IClicked<LookupForm<T>> m_onNew;
    private DefaultButton m_newBtn;
    private IClicked<? extends LookupForm<T>> m_onClear;
    private IClicked<LookupForm<T>> m_onCancel;
    private DefaultButton m_cancelBtn;
    private DefaultButton m_collapseButton;
    private DefaultButton m_clearButton;
    @Nullable
    private DefaultButton m_filterButton;
    @Nonnull
    private List<SavedFilter> m_savedFilters = Collections.EMPTY_LIST;
    private boolean m_searchFilterEnabled;
    @Nullable
    private static ILookupFilterHandler m_lookupFilterHandler;
    @Nullable
    private LookupFormSavedFilterFragment m_lookupFormSavedFilterFragment;
    private Table m_table;
    private TBody m_tbody;
    private Div m_content;
    private NodeContainer m_collapsedPanel;
    private NodeContainer m_buttonRow;
    private ControlBuilder m_builder;
    private ButtonFactory m_buttonFactory = new ButtonFactory(this);
    private boolean m_collapsed;
    private boolean m_hasUserDefinedCriteria;
    private IClicked<NodeBase> m_onAfterRestore;
    private IClicked<NodeBase> m_onAfterCollapse;
    private IQueryFactory<T> m_queryFactory;
    private boolean m_twoColumnsMode;
    private int m_minSizeForTwoColumnsMode;
    private final List<Item> m_itemList = new ArrayList<Item>(20);
    private List<ButtonRowItem> m_buttonItemList = Collections.EMPTY_LIST;

    @Nullable
    public DefaultButton getClearButton() {
        return this.m_clearButton;
    }

    private Map<String, ILookupControlInstance<?>> getFilterItems() {
        HashMap filterValues = new HashMap();
        for (Item item : this.m_itemList) {
            String propertyName = item.getPropertyName() != null ? item.getPropertyName() : item.getLabelText();
            filterValues.put(propertyName, item.getInstance());
        }
        return filterValues;
    }

    public Map<String, ?> getFilterValues() {
        Map<String, ILookupControlInstance<?>> filterItems = this.getFilterItems();
        HashMap filterValues = new HashMap();
        for (Map.Entry<String, ILookupControlInstance<?>> entry : filterItems.entrySet()) {
            if (entry.getValue().getValue() == null) continue;
            filterValues.put(entry.getKey(), entry.getValue().getValue());
        }
        return filterValues;
    }

    private void setSavedFilters(List<SavedFilter> savedFilters) {
        this.m_savedFilters = savedFilters;
    }

    public boolean isSearchFilterEnabled() {
        return this.m_searchFilterEnabled;
    }

    public void setSearchFilterEnabled(boolean searchFilterEnabled) {
        this.m_searchFilterEnabled = searchFilterEnabled;
    }

    public LookupForm(@Nonnull Class<T> lookupClass, String ... propertyList) {
        this(lookupClass, (ClassMetaModel)null, propertyList);
    }

    public LookupForm(@Nonnull Class<T> lookupClass, @Nullable ClassMetaModel cmm, String ... propertyList) {
        this.m_lookupClass = lookupClass;
        this.m_metaModel = cmm != null ? cmm : MetaManager.findClassMeta(lookupClass);
        this.m_builder = DomApplication.get().getControlBuilder();
        for (String prop : propertyList) {
            this.addProperty(prop);
        }
        this.defineDefaultButtons();
    }

    public LookupForm(@Nonnull QCriteria<T> rootCriteria, String ... propertyList) {
        this(DomUtil.nullChecked(rootCriteria.getBaseClass()), (ClassMetaModel)null, propertyList);
        this.m_rootCriteria = rootCriteria;
    }

    @Nonnull
    public ClassMetaModel getMetaModel() {
        return this.m_metaModel;
    }

    @Nonnull
    public Class<T> getLookupClass() {
        if (null == this.m_lookupClass) {
            throw new NullPointerException("The LookupForm's 'lookupClass' cannot be null");
        }
        return this.m_lookupClass;
    }

    @Override
    public void createContent() throws Exception {
        TD searchRootCell;
        TR searchRootRow;
        TBody searchRootTableBody;
        Object searchRootTable;
        if (this.isSearchFilterEnabled()) {
            this.addFilterButton();
            this.loadSearchQueries();
        }
        Div sroot = new Div();
        sroot.setCssClass("ui-lf-mainContent");
        if (this.getPageTitle() != null) {
            CaptionedPanel cp = new CaptionedPanel(this.getPageTitle(), (NodeContainer)sroot);
            this.add(cp);
            this.m_content = cp;
        } else {
            this.add(sroot);
            this.m_content = sroot;
        }
        if (this.m_itemList.size() == 0) {
            this.setDefaultItems();
        }
        NodeContainer searchContainer = sroot;
        if (this.containsItemBreaks(this.m_itemList)) {
            searchRootTable = new Table();
            ((NodeBase)searchRootTable).setCssClass("ui-lf-multi");
            sroot.add((NodeBase)searchRootTable);
            searchRootTableBody = new TBody();
            ((NodeContainer)searchRootTable).add(searchRootTableBody);
            searchRootRow = new TR();
            searchRootTableBody.add(searchRootRow);
            searchRootCell = new TD();
            searchRootCell.setValign(TableVAlign.TOP);
            searchRootCell.setVerticalAlign(VerticalAlignType.TOP);
            searchRootRow.add(searchRootCell);
            searchContainer = searchRootCell;
        }
        if (this.isSearchFilterEnabled()) {
            if (this.containsItemBreaks(this.m_itemList)) {
                this.m_tbody.add("This is not implemented yet!");
            }
            searchRootTable = new Table();
            ((NodeBase)searchRootTable).setCssClass("ui-lf-multi");
            sroot.add((NodeBase)searchRootTable);
            searchRootTableBody = new TBody();
            ((NodeContainer)searchRootTable).add(searchRootTableBody);
            searchRootRow = new TR();
            searchRootTableBody.add(searchRootRow);
            searchRootCell = new TD();
            searchRootCell.setValign(TableVAlign.TOP);
            searchRootRow.add(searchRootCell);
            searchContainer = searchRootCell;
        }
        this.m_table = new Table();
        this.m_table.setCssClass("ui-lf-st");
        searchContainer.add(this.m_table);
        this.m_tbody = new TBody();
        this.m_tbody.setTestID("tableBodyLookupForm");
        this.m_table.add(this.m_tbody);
        for (Item it : this.m_itemList) {
            if (it instanceof ItemBreak) {
                TD anotherSearchRootCell = new TD();
                anotherSearchRootCell.setValign(TableVAlign.TOP);
                searchContainer.appendAfterMe(anotherSearchRootCell);
                searchContainer = anotherSearchRootCell;
                this.m_table = new Table();
                this.m_table.setCssClass("ui-lf-st");
                searchContainer.add(this.m_table);
                this.m_tbody = new TBody();
                this.m_tbody.setTestID("tableBodyLookupForm");
                this.m_table.add(this.m_tbody);
                continue;
            }
            this.internalAddLookupItem(it);
        }
        if (this.isSearchFilterEnabled()) {
            if (this.containsItemBreaks(this.m_itemList)) {
                throw new IllegalStateException("Not implemented yet. It is not possible to show the saved searched filter in combination with a split lookupform");
            }
            this.addFilterFragment(searchContainer);
        }
        Div d = new Div();
        d.setTestID("buttonBar");
        d.setCssClass("ui-lf-ebb");
        sroot.add(d);
        this.m_buttonRow = d;
        if (!this.m_collapsed && this.m_collapsedPanel != null) {
            this.restore();
        } else if (this.m_collapsed && this.m_content.getDisplay() != DisplayType.NONE) {
            this.collapse();
            if (this.m_cancelBtn != null) {
                this.m_cancelBtn.setFocus();
            } else if (this.m_collapseButton != null) {
                this.m_collapseButton.setFocus();
            }
        } else {
            this.createButtonRow(d, false);
        }
        this.setReturnPressed((IReturnPressed<? extends NodeBase>)new IReturnPressed<Div>(){

            @Override
            public void returnPressed(@Nonnull Div node) throws Exception {
                if (LookupForm.this.m_clicker != null) {
                    LookupForm.this.m_clicker.clicked(LookupForm.this);
                }
            }
        });
    }

    private void addFilterFragment(NodeContainer searchContainer) {
        TD anotherSearchRootCell = new TD();
        searchContainer.appendAfterMe(anotherSearchRootCell);
        LookupFormSavedFilterFragment div = this.m_lookupFormSavedFilterFragment = new LookupFormSavedFilterFragment(this.m_savedFilters);
        div.onFilterClicked(new INotify<SavedFilter>(){

            @Override
            public void onNotify(@Nonnull SavedFilter sender) throws Exception {
                LookupForm.this.clearInput();
                LookupForm.this.fillSearchFields(sender);
                if (LookupForm.this.m_clicker != null) {
                    LookupForm.this.m_clicker.clicked(LookupForm.this);
                }
            }
        });
        div.onFilterDeleted(new INotify<SavedFilter>(){

            @Override
            public void onNotify(@Nonnull SavedFilter sender) throws Exception {
                LookupForm.this.deleteSavedFilter(sender);
            }
        });
        anotherSearchRootCell.add(div);
    }

    private void loadSearchQueries() throws Exception {
        ILookupFilterHandler lookupFilterHandler = LookupForm.getLookupFilterHandler();
        List<SavedFilter> savedFilters = lookupFilterHandler.load(this.getSharedContext(), this.getPage().getBody().getClass().getName());
        this.setSavedFilters(savedFilters);
    }

    private void deleteSavedFilter(SavedFilter filter) throws Exception {
        ILookupFilterHandler lookupFilterHandler = LookupForm.getLookupFilterHandler();
        try (QDataContext unmanagedContext = QContextManager.createUnmanagedContext();){
            lookupFilterHandler.delete(unmanagedContext, filter.getRecordId());
            unmanagedContext.commit();
        }
    }

    public static synchronized void setLookupFilterHandler(@Nullable ILookupFilterHandler filterSaver) {
        m_lookupFilterHandler = filterSaver;
    }

    @Nonnull
    private static synchronized ILookupFilterHandler getLookupFilterHandler() {
        ILookupFilterHandler lookupFilterHandler = m_lookupFilterHandler;
        if (lookupFilterHandler == null) {
            throw new IllegalStateException("There is no code to handle the saved filter.");
        }
        return lookupFilterHandler;
    }

    private void fillSearchFields(SavedFilter filter) throws Exception {
        Map<String, ILookupControlInstance<?>> formLookupFilterItems = this.getFilterItems();
        Map<String, Object> savedFilterValues = LookupFilterTranslator.deserialize(this.getSharedContext(), filter.getFilterValue());
        for (Map.Entry<String, Object> entry : savedFilterValues.entrySet()) {
            String property = entry.getKey();
            ILookupControlInstance<?> controlInstance = formLookupFilterItems.get(property);
            if (controlInstance == null) continue;
            controlInstance.setValue(entry.getValue());
        }
    }

    protected void defineDefaultButtons() {
        DefaultButton b = new DefaultButton(Msgs.BUNDLE.getString("lookupform.search"));
        b.setIcon("THEME/btnFind.png");
        b.setTestID("searchButton");
        b.setTitle(Msgs.BUNDLE.getString("lookupform.btn.search.title"));
        b.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase bx) throws Exception {
                if (LookupForm.this.m_clicker != null) {
                    LookupForm.this.m_clicker.clicked(LookupForm.this);
                }
            }
        });
        this.addButtonItem(b, 100, ButtonMode.NORMAL);
        this.m_clearButton = b = new DefaultButton(Msgs.BUNDLE.getString("lookupform.clear"));
        b.setIcon("THEME/btnClear.png");
        b.setTestID("clearButton");
        b.setTitle(Msgs.BUNDLE.getString("lookupform.btn.clear.title"));
        b.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase xb) throws Exception {
                LookupForm.this.clearInput();
                if (LookupForm.this.getOnClear() != null) {
                    LookupForm.this.getOnClear().clicked(LookupForm.this);
                }
            }
        });
        this.addButtonItem(b, 200, ButtonMode.NORMAL);
        this.m_collapseButton = new DefaultButton(Msgs.BUNDLE.getString("lookupform.collapse"), "THEME/btnHideLookup.png", new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton bx) throws Exception {
                LookupForm.this.collapse();
            }
        });
        this.m_collapseButton.setTestID("hideButton");
        this.m_collapseButton.setTitle(Msgs.BUNDLE.getString("lookupform.btn.collapse.title"));
        this.addButtonItem(this.m_collapseButton, 300, ButtonMode.BOTH);
    }

    public void addFilterButton() {
        if (this.m_filterButton == null) {
            this.m_filterButton = new DefaultButton(Msgs.BUNDLE.getString("lookupform.savesearch"), "THEME/btnSave.png", new IClicked<DefaultButton>(){

                @Override
                public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                    LookupForm.this.saveSearchQuery();
                }
            });
            this.addButtonItem(this.m_filterButton, 400, ButtonMode.NORMAL);
        }
    }

    private void saveSearchQuery() throws Exception {
        SaveSearchFilterDialog dialog = new SaveSearchFilterDialog(DomUtil.nullChecked(m_lookupFilterHandler), this.getPage().getBody().getClass().getName(), this.getFilterValues());
        dialog.onFilterSaved(new INotify<SavedFilter>(){

            @Override
            public void onNotify(@Nonnull SavedFilter sender) throws Exception {
                LookupForm.this.m_savedFilters.add(sender);
                if (LookupForm.this.m_lookupFormSavedFilterFragment != null) {
                    LookupForm.this.m_lookupFormSavedFilterFragment.forceRebuild();
                }
            }
        });
        dialog.modal();
        this.add(dialog);
    }

    private boolean containsItemBreaks(List<Item> itemList) {
        for (Item item : itemList) {
            if (!(item instanceof ItemBreak)) continue;
            return true;
        }
        return false;
    }

    void collapse() throws Exception {
        if (this.m_content.getDisplay() == DisplayType.NONE) {
            return;
        }
        this.m_content.slideUp();
        this.m_collapsedPanel = new Div();
        this.m_collapsedPanel.setCssClass("ui-lf-coll");
        this.add(this.m_collapsedPanel);
        this.m_collapsed = true;
        this.m_collapseButton.setText(Msgs.BUNDLE.getString("lookupform.restore"));
        this.m_collapseButton.setIcon("THEME/btnShowLookup.png");
        this.m_collapseButton.setClicked(new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton bx) throws Exception {
                LookupForm.this.restore();
            }
        });
        this.createButtonRow(this.m_collapsedPanel, true);
        if (this.getOnAfterCollapse() != null) {
            this.getOnAfterCollapse().clicked(this);
        }
    }

    void restore() throws Exception {
        if (this.m_collapsedPanel == null) {
            return;
        }
        this.m_collapsedPanel.remove();
        this.m_collapsedPanel = null;
        this.createButtonRow(this.m_buttonRow, false);
        this.m_collapseButton.setText(Msgs.BUNDLE.getString("lookupform.collapse"));
        this.m_collapseButton.setIcon("THEME/btnHideLookup.png");
        this.m_collapseButton.setClicked(new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton bx) throws Exception {
                LookupForm.this.collapse();
            }
        });
        this.m_content.setDisplay(DisplayType.BLOCK);
        this.m_collapsed = false;
        if (this.getOnAfterRestore() != null) {
            this.getOnAfterRestore().clicked(this);
        }
    }

    public void setDefaultItems() {
        this.m_itemList.clear();
        List<SearchPropertyMetaModel> list = this.getMetaModel().getSearchProperties();
        if (!(list != null && list.size() != 0 || (list = MetaManager.calculateSearchProperties(this.getMetaModel())) != null && list.size() != 0)) {
            throw new IllegalStateException(this.getMetaModel() + " has no search properties defined in its meta data.");
        }
        this.setSearchProperties(list);
    }

    public void setSearchProperties(List<SearchPropertyMetaModel> list) {
        int totalCount = list.size();
        for (SearchPropertyMetaModel sp : list) {
            Item it = new Item();
            it.setIgnoreCase(sp.isIgnoreCase());
            it.setMinLength(sp.getMinLength());
            it.setPropertyName(sp.getPropertyName());
            it.setPropertyPath(sp.getPropertyPath());
            it.setLabelText(sp.getLookupLabel());
            it.setLookupHint(sp.getLookupHint());
            this.addAndFinish(it);
            if (this.m_twoColumnsMode && totalCount >= this.m_minSizeForTwoColumnsMode && this.m_itemList.size() == (totalCount + 1) / 2) {
                this.m_itemList.add(new ItemBreak());
            }
            this.updateUI(it);
        }
    }

    public Item addProperty(String path, int minlen, boolean ignorecase) {
        return this.addProperty(path, null, minlen, ignorecase);
    }

    public Item addProperty(String path, int minlen) {
        return this.addProperty(path, null, minlen, null);
    }

    public Item addProperty(String path, String label) {
        return this.addProperty(path, label, 0, null);
    }

    public Item addProperty(String path) {
        return this.addProperty(path, null, 0, null);
    }

    private Item addProperty(String path, String label, int minlen, Boolean ignorecase) {
        for (Item it : this.m_itemList) {
            if (it.getPropertyName() == null || !path.equals(it.getPropertyName())) continue;
            throw new ProgrammerErrorException("The property " + path + " is already part of the search field list.");
        }
        Item it = new Item();
        it.setPropertyName(path);
        it.setLabelText(label);
        it.setIgnoreCase(ignorecase == null ? true : ignorecase);
        it.setMinLength(minlen);
        this.addAndFinish(it);
        this.updateUI(it);
        return it;
    }

    public void addItemBreak() {
        ItemBreak itemBreak = new ItemBreak();
        this.m_itemList.add(itemBreak);
    }

    public Item addManual(ILookupControlInstance<?> lci) {
        Item it = new Item();
        it.setInstance(lci);
        this.addAndFinish(it);
        this.updateUI(it);
        return it;
    }

    public <VT, X extends NodeBase> Item addManual(String property, X control) {
        Item it = new Item();
        it.setPropertyName(property);
        this.addAndFinish(it);
        ILookupControlFactory lcf = this.m_builder.getLookupQueryFactory(it, control);
        ILookupControlInstance<?> qt = lcf.createControl(it, (IControl)((Object)control));
        if (qt == null || qt.getInputControls() == null || qt.getInputControls().length == 0) {
            throw new IllegalStateException("Lookup factory " + lcf + " did not link thenlookup thingy for property " + it.getPropertyName());
        }
        it.setInstance(qt);
        this.updateUI(it);
        return it;
    }

    public Item addManualTextLabel(String labelText, ILookupControlInstance<?> lci) {
        Item it = new Item();
        it.setInstance(lci);
        it.setLabelText(labelText);
        this.addAndFinish(it);
        this.updateUI(it);
        return it;
    }

    public Item addManualPropertyLabel(String property, ILookupControlInstance<?> lci) {
        PropertyMetaModel<?> pmm = this.getMetaModel().findProperty(property);
        if (null == pmm) {
            throw new ProgrammerErrorException(property + ": undefined property for class=" + this.getLookupClass());
        }
        return this.addManualTextLabel(pmm.getDefaultLabel(), lci);
    }

    public Item addChildProperty(String propPath) {
        return this.addChildPropertyLabel(null, propPath);
    }

    public Item addChildPropertyLabel(String label, String propPath) {
        List<PropertyMetaModel<?>> pl = MetaManager.parsePropertyPath(this.m_metaModel, propPath);
        if (pl.size() != 2) {
            throw new ProgrammerErrorException("Property path does not contain parent.child path: " + propPath);
        }
        final PropertyMetaModel<?> parentPmm = pl.get(0);
        final PropertyMetaModel<?> childPmm = pl.get(1);
        SearchPropertyMetaModelImpl spmm = new SearchPropertyMetaModelImpl(this.m_metaModel);
        spmm.setPropertyName(childPmm.getName());
        spmm.setPropertyPath(pl);
        ILookupControlFactory lcf = this.m_builder.getLookupControlFactory(spmm);
        final ILookupControlInstance<?> lookupInstance = lcf.createControl(spmm, null);
        AbstractLookupControlImpl thingy = new AbstractLookupControlImpl(lookupInstance.getInputControls()){

            @Override
            @Nonnull
            public ILookupControlInstance.AppendCriteriaResult appendCriteria(@Nonnull QCriteria<?> crit) throws Exception {
                QCriteria r = QCriteria.create(childPmm.getClassModel().getActualClass());
                ILookupControlInstance.AppendCriteriaResult subRes = lookupInstance.appendCriteria(r);
                if (subRes == ILookupControlInstance.AppendCriteriaResult.INVALID) {
                    return subRes;
                }
                if (r.hasRestrictions()) {
                    QRestrictor exists = crit.exists(childPmm.getClassModel().getActualClass(), parentPmm.getName());
                    exists.setRestrictions(r.getRestrictions());
                    return ILookupControlInstance.AppendCriteriaResult.VALID;
                }
                return ILookupControlInstance.AppendCriteriaResult.EMPTY;
            }

            @Override
            public void clearInput() {
                lookupInstance.clearInput();
            }
        };
        return this.addManualTextLabel(label == null ? parentPmm.getDefaultLabel() : label, thingy);
    }

    public void reset() {
        this.forceRebuild();
        this.m_itemList.clear();
    }

    private void addAndFinish(Item it) {
        this.m_itemList.add(it);
        if (it.getPropertyPath() == null && it.getPropertyName() != null && it.getPropertyName().length() > 0) {
            List<PropertyMetaModel<?>> pl = MetaManager.parsePropertyPath(this.getMetaModel(), it.getPropertyName());
            if (pl.size() == 0) {
                throw new ProgrammerErrorException("Unknown/unresolvable lookup property " + it.getPropertyName() + " on class=" + this.getLookupClass());
            }
            it.setPropertyPath(pl);
        }
        PropertyMetaModel<?> pmm = MetaUtils.findLastProperty(it);
        if (it.getLabelText() == null) {
            if (pmm == null) {
                it.setLabelText(it.getPropertyName());
            } else {
                it.setLabelText(pmm.getDefaultLabel());
            }
        }
        if (it.getLookupHint() == null && pmm != null) {
            it.setLookupHint(pmm.getDefaultHint());
        }
        if (it.getErrorLocation() == null) {
            it.setErrorLocation(it.getLabelText());
        }
    }

    private void addNonControlItem(@Nonnull Item it) {
        NodeBase itRight;
        TR tr = new TR();
        this.m_tbody.add(tr);
        TD td = tr.addCell();
        NodeBase itLeft = it.getLeft();
        if (itLeft != null) {
            td.add(itLeft);
            if (it.isEntireRow()) {
                td.setColspan(2);
            }
        }
        if ((itRight = it.getRight()) != null) {
            TD tdRight = tr.addCell();
            tdRight.add(itRight);
        }
    }

    private void updateUI(@Nonnull Item it) {
        if (this.m_tbody != null) {
            this.internalAddLookupItem(it);
        }
    }

    private void internalAddLookupItem(Item it) {
        if (!it.isControl()) {
            this.addNonControlItem(it);
            return;
        }
        if (it.getInstance() == null) {
            NodeBase[] lci = this.createControlFor(it);
            if (lci == null) {
                return;
            }
            it.setInstance((ILookupControlInstance<?>)lci);
        }
        if (it.getInstance() == null) {
            throw new IllegalStateException("No idea how to create a lookup control for " + it);
        }
        if (!DomUtil.isBlank(it.getErrorLocation())) {
            for (NodeBase ic : it.getInstance().getInputControls()) {
                ic.setErrorLocation(it.getErrorLocation());
            }
        }
        if (it.isForcedDisabled()) {
            it.getInstance().setDisabled(true);
        } else if (it.isForcedEnabled()) {
            it.getInstance().setDisabled(false);
        }
        if (!DomUtil.isBlank(it.getTestId())) {
            if (it.getInstance().getInputControls().length == 1) {
                it.getInstance().getInputControls()[0].setTestID(it.getTestId());
            } else if (it.getInstance().getInputControls().length > 1) {
                int controlCounter = 1;
                for (NodeBase ic : it.getInstance().getInputControls()) {
                    ic.setTestID(it.getTestId() + "_" + controlCounter);
                    ++controlCounter;
                }
            }
        }
        this.addItemToTable(it);
    }

    private void addItemToTable(Item it) {
        ILookupControlInstance<?> qt = it.getInstance();
        TR tr = new TR();
        this.m_tbody.add(tr);
        TD lcell = new TD();
        tr.add(lcell);
        lcell.setCssClass("ui-f4-lbl ui-f4-lbl-v");
        TD ccell = new TD();
        tr.add(ccell);
        ccell.setCssClass("ui-f-in");
        NodeBase labelcontrol = qt.getLabelControl();
        for (NodeBase b : qt.getInputControls()) {
            ccell.add(b);
            this.assignCalcTestID(it, b);
            if (labelcontrol != null || !(b instanceof IControl)) continue;
            labelcontrol = b;
        }
        if (labelcontrol == null) {
            labelcontrol = qt.getInputControls()[0];
        }
        if (it.getLabelText() != null && it.getLabelText().length() > 0) {
            Label l = new Label(labelcontrol, it.getLabelText());
            lcell.add(l);
        }
    }

    public void addItem(@Nullable NodeBase left, @Nullable NodeBase right) {
        Item item = new Item(left, right);
        this.m_itemList.add(item);
    }

    public void addItem(@Nullable NodeBase cell) {
        Item item = new Item(cell);
        this.m_itemList.add(item);
    }

    private void assignCalcTestID(@Nonnull Item item, @Nonnull NodeBase b) {
        if (b.getTestID() != null) {
            return;
        }
        String lbl = item.getPropertyName();
        if (null == lbl) {
            lbl = item.getLabelText();
        }
        if (null == lbl) {
            lbl = DomUtil.getClassNameOnly(b.getClass());
        }
        b.setCalculcatedId(lbl);
    }

    private ILookupControlInstance<?> createControlFor(Item it) {
        PropertyMetaModel<?> pmm = it.getLastProperty();
        if (pmm == null) {
            throw new IllegalStateException("property cannot be null when creating using factory.");
        }
        ILookupControlFactory lcf = this.m_builder.getLookupControlFactory(it);
        ILookupControlInstance<?> qt = lcf.createControl(it, null);
        if (qt == null || qt.getInputControls() == null || qt.getInputControls().length == 0) {
            throw new IllegalStateException("Lookup factory " + lcf + " did not create a lookup thingy for property " + it.getPropertyName());
        }
        return qt;
    }

    @Nullable
    public QCriteria<T> getEnteredCriteria() throws Exception {
        Object root;
        this.m_hasUserDefinedCriteria = false;
        if (this.getQueryFactory() != null) {
            root = this.getQueryFactory().createQuery();
        } else {
            root = this.getMetaModel().createCriteria();
            QCriteria<T> rootCriteria = this.m_rootCriteria;
            if (null != rootCriteria) {
                root.mergeCriteria(rootCriteria);
            }
        }
        boolean success = true;
        for (Item it : this.m_itemList) {
            ILookupControlInstance<T> li = it.getInstance();
            if (li == null) continue;
            ILookupControlInstance.AppendCriteriaResult res = li.appendCriteria((QCriteria<?>)root);
            if (res == ILookupControlInstance.AppendCriteriaResult.INVALID) {
                success = false;
                continue;
            }
            if (res != ILookupControlInstance.AppendCriteriaResult.VALID) continue;
            this.m_hasUserDefinedCriteria = true;
        }
        if (!success) {
            this.m_hasUserDefinedCriteria = false;
            return null;
        }
        return root;
    }

    public void clearInput() {
        for (Item it : this.m_itemList) {
            if (it.getInstance() == null) continue;
            it.getInstance().clearInput();
        }
    }

    public IClicked<LookupForm<T>> getOnNew() {
        return this.m_onNew;
    }

    public void setOnNew(IClicked<LookupForm<T>> onNew) {
        if (this.m_onNew != onNew) {
            this.m_onNew = onNew;
            if (this.m_onNew != null && this.m_newBtn == null) {
                this.m_newBtn = new DefaultButton(Msgs.BUNDLE.getString("lookupform.new"));
                this.m_newBtn.setIcon("THEME/btnNew.png");
                this.m_newBtn.setTestID("newButton");
                this.m_newBtn.setTitle(Msgs.BUNDLE.getString("lookupform.btn.new.title"));
                this.m_newBtn.setClicked(new IClicked<NodeBase>(){

                    @Override
                    public void clicked(@Nonnull NodeBase xb) throws Exception {
                        if (LookupForm.this.getOnNew() != null) {
                            LookupForm.this.getOnNew().clicked(LookupForm.this);
                        }
                    }
                });
                this.addButtonItem(this.m_newBtn, 500, ButtonMode.BOTH);
            } else if (this.m_onNew == null && this.m_newBtn != null) {
                for (ButtonRowItem bri : this.m_buttonItemList) {
                    if (bri.getThingy() != this.m_newBtn) continue;
                    this.m_buttonItemList.remove(bri);
                    break;
                }
                this.m_newBtn = null;
            }
            this.forceRebuild();
        }
    }

    public String getPageTitle() {
        return this.m_title;
    }

    public void setPageTitle(String title) {
        this.m_title = title;
    }

    @Override
    public void setClicked(@Nullable IClickBase<?> clicked) {
        this.m_clicker = (IClicked)clicked;
    }

    public IClicked<LookupForm<T>> getSearchClicked() {
        return this.m_clicker;
    }

    public IClicked<? extends LookupForm<T>> getOnClear() {
        return this.m_onClear;
    }

    public void setOnClear(IClicked<? extends LookupForm<T>> onClear) {
        this.m_onClear = onClear;
    }

    public void setOnCancel(IClicked<LookupForm<T>> onCancel) {
        if (this.m_onCancel != onCancel) {
            this.m_onCancel = onCancel;
            if (this.m_onCancel != null && this.m_cancelBtn == null) {
                this.m_cancelBtn = new DefaultButton(Msgs.BUNDLE.getString("lookupform.cancel"));
                this.m_cancelBtn.setIcon("THEME/btnCancel.png");
                this.m_cancelBtn.setTestID("cancelButton");
                this.m_cancelBtn.setTitle(Msgs.BUNDLE.getString("lookupform.btn.cancel.title"));
                this.m_cancelBtn.setClicked(new IClicked<NodeBase>(){

                    @Override
                    public void clicked(@Nonnull NodeBase xb) throws Exception {
                        if (LookupForm.this.getOnCancel() != null) {
                            LookupForm.this.getOnCancel().clicked(LookupForm.this);
                        }
                    }
                });
                this.addButtonItem(this.m_cancelBtn, 400, ButtonMode.BOTH);
            } else if (this.m_onCancel == null && this.m_cancelBtn != null) {
                for (ButtonRowItem bri : this.m_buttonItemList) {
                    if (bri.getThingy() != this.m_cancelBtn) continue;
                    this.m_buttonItemList.remove(bri);
                    break;
                }
                this.m_cancelBtn = null;
            }
            this.forceRebuild();
        }
    }

    public IClicked<LookupForm<T>> getOnCancel() {
        return this.m_onCancel;
    }

    public void addButtonItem(NodeBase b) {
        this.addButtonItem(b, this.m_buttonItemList.size(), ButtonMode.BOTH);
    }

    public void addButtonItem(NodeBase b, int order) {
        this.addButtonItem(b, order, ButtonMode.BOTH);
    }

    public void addButtonItem(NodeBase b, int order, ButtonMode both) {
        if (this.m_buttonItemList == Collections.EMPTY_LIST) {
            this.m_buttonItemList = new ArrayList<ButtonRowItem>(10);
        }
        this.m_buttonItemList.add(new ButtonRowItem(order, both, b));
    }

    private void createButtonRow(NodeContainer c, boolean iscollapsed) {
        Collections.sort(this.m_buttonItemList, new Comparator<ButtonRowItem>(){

            @Override
            public int compare(ButtonRowItem o1, ButtonRowItem o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        for (ButtonRowItem bi : this.m_buttonItemList) {
            if ((!iscollapsed || bi.getMode() != ButtonMode.BOTH && bi.getMode() != ButtonMode.COLLAPSED) && (iscollapsed || bi.getMode() != ButtonMode.BOTH && bi.getMode() != ButtonMode.NORMAL)) continue;
            c.add(bi.getThingy());
        }
    }

    public void setTwoColumnsMode(int minSizeForTwoColumnsMode) {
        this.m_twoColumnsMode = true;
        this.m_minSizeForTwoColumnsMode = minSizeForTwoColumnsMode;
    }

    public boolean hasUserDefinedCriteria() {
        return this.m_hasUserDefinedCriteria;
    }

    public boolean isCollapsed() {
        return this.m_collapsed;
    }

    public void setCollapsed(boolean collapsed) throws Exception {
        if (this.m_collapsed == collapsed) {
            return;
        }
        if (!this.isBuilt()) {
            this.m_collapsed = collapsed;
            return;
        }
        if (this.isBuilt()) {
            if (collapsed) {
                this.collapse();
            } else {
                this.restore();
            }
        }
    }

    public IClicked<NodeBase> getOnAfterRestore() {
        return this.m_onAfterRestore;
    }

    public void setOnAfterRestore(IClicked<NodeBase> onAfterRestore) {
        this.m_onAfterRestore = onAfterRestore;
    }

    public IClicked<NodeBase> getOnAfterCollapse() {
        return this.m_onAfterCollapse;
    }

    public void setOnAfterCollapse(IClicked<NodeBase> onAfterCollapse) {
        this.m_onAfterCollapse = onAfterCollapse;
    }

    public IQueryFactory<T> getQueryFactory() {
        return this.m_queryFactory;
    }

    public void setQueryFactory(IQueryFactory<T> queryFactory) {
        this.m_queryFactory = queryFactory;
    }

    @Override
    public void addButton(@Nonnull NodeBase thing, int order) {
        if (order < 0) {
            this.addButtonItem(thing);
        } else {
            this.addButtonItem(thing, order);
        }
    }

    @Nonnull
    public ButtonFactory getButtonFactory() {
        return this.m_buttonFactory;
    }

    private static class ButtonRowItem {
        private final int m_order;
        private final ButtonMode m_mode;
        private final NodeBase m_thingy;

        public ButtonRowItem(int order, ButtonMode mode, NodeBase thingy) {
            this.m_order = order;
            this.m_mode = mode;
            this.m_thingy = thingy;
        }

        public ButtonMode getMode() {
            return this.m_mode;
        }

        public int getOrder() {
            return this.m_order;
        }

        public NodeBase getThingy() {
            return this.m_thingy;
        }
    }

    public static enum ButtonMode {
        NORMAL,
        COLLAPSED,
        BOTH;

    }

    private static class ItemBreak
    extends Item {
    }

    public static class Item
    implements SearchPropertyMetaModel {
        @Nullable
        private final NodeBase m_left;
        @Nullable
        private final NodeBase m_right;
        private final boolean m_isEntireRow;
        private final boolean m_isControl;
        private String m_propertyName;
        private List<PropertyMetaModel<?>> m_propertyPath;
        private ILookupControlInstance<?> m_instance;
        private boolean m_ignoreCase = true;
        private int m_minLength;
        private String m_labelText;
        private String m_lookupHint;
        private String m_errorLocation;
        private int m_order;
        private String testId;
        private InputBehaviorType m_inputsBehavior = InputBehaviorType.DEFAULT;

        public Item() {
            this.m_left = null;
            this.m_right = null;
            this.m_isEntireRow = false;
            this.m_isControl = true;
        }

        public Item(@Nullable NodeBase left, @Nullable NodeBase right) {
            this.m_left = left;
            this.m_right = right;
            this.m_isEntireRow = false;
            this.m_isControl = false;
        }

        public Item(@Nullable NodeBase cell) {
            this.m_left = cell;
            this.m_right = null;
            this.m_isEntireRow = true;
            this.m_isControl = false;
        }

        @Nullable
        public NodeBase getLeft() {
            return this.m_left;
        }

        @Nullable
        public NodeBase getRight() {
            return this.m_right;
        }

        public boolean isEntireRow() {
            return this.m_isEntireRow;
        }

        public boolean isControl() {
            return this.m_isControl;
        }

        @Override
        public String getPropertyName() {
            return this.m_propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.m_propertyName = propertyName;
        }

        @Override
        public List<PropertyMetaModel<?>> getPropertyPath() {
            return this.m_propertyPath;
        }

        public void setPropertyPath(List<PropertyMetaModel<?>> propertyPath) {
            this.m_propertyPath = propertyPath;
        }

        public PropertyMetaModel<?> getLastProperty() {
            if (this.m_propertyPath == null || this.m_propertyPath.size() == 0) {
                return null;
            }
            return this.m_propertyPath.get(this.m_propertyPath.size() - 1);
        }

        @Override
        public boolean isIgnoreCase() {
            return this.m_ignoreCase;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.m_ignoreCase = ignoreCase;
        }

        @Override
        public int getMinLength() {
            return this.m_minLength;
        }

        public void setMinLength(int minLength) {
            this.m_minLength = minLength;
        }

        public String getLabelText() {
            return this.m_labelText;
        }

        public void setLabelText(String labelText) {
            this.m_labelText = labelText;
        }

        @Override
        public String getLookupLabel() {
            return this.m_labelText;
        }

        public String getErrorLocation() {
            return this.m_errorLocation;
        }

        public void setErrorLocation(String errorLocation) {
            this.m_errorLocation = errorLocation;
        }

        ILookupControlInstance<?> getInstance() {
            return this.m_instance;
        }

        void setInstance(ILookupControlInstance<?> instance) {
            this.m_instance = instance;
        }

        @Override
        public int getOrder() {
            return this.m_order;
        }

        void setOrder(int order) {
            this.m_order = order;
        }

        @Override
        public String getLookupHint() {
            return this.m_lookupHint;
        }

        public void setLookupHint(String lookupHint) {
            this.m_lookupHint = lookupHint;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Item:");
            if (this.m_propertyName != null) {
                sb.append(" property: ");
                sb.append(this.m_propertyName);
            }
            if (this.m_labelText != null) {
                sb.append(" label: ");
                sb.append(this.m_labelText);
            }
            return sb.toString();
        }

        public String getTestId() {
            return this.testId;
        }

        public void setTestId(String testId) {
            this.testId = testId;
        }

        public void setDisabled(boolean disabled) {
            this.m_inputsBehavior = disabled ? InputBehaviorType.FORCE_DISABLED : InputBehaviorType.FORCE_ENABLED;
            this.m_instance.setDisabled(disabled);
        }

        public boolean isForcedDisabled() {
            return this.m_inputsBehavior == InputBehaviorType.FORCE_DISABLED;
        }

        public boolean isForcedEnabled() {
            return this.m_inputsBehavior == InputBehaviorType.FORCE_ENABLED;
        }

        public void clear() {
            this.m_instance.clearInput();
        }

        static enum InputBehaviorType {
            DEFAULT,
            FORCE_ENABLED,
            FORCE_DISABLED;

        }
    }
}

