/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.lookup.SavedFilter;
import to.etc.domui.dom.html.ATag;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.Msgs;

@DefaultNonNull
public final class LookupFormSavedFilterFragment
extends Div {
    private final List<SavedFilter> m_savedFilters;
    @Nullable
    private INotify<SavedFilter> m_onFilterClicked;
    @Nullable
    private INotify<SavedFilter> m_onFilterDeleted;

    public LookupFormSavedFilterFragment(List<SavedFilter> savedFilters) {
        this.m_savedFilters = savedFilters;
    }

    public void onFilterClicked(@Nullable INotify<SavedFilter> onFilterClicked) {
        this.m_onFilterClicked = onFilterClicked;
    }

    public void onFilterDeleted(@Nullable INotify<SavedFilter> onFilterDeleted) {
        this.m_onFilterDeleted = onFilterDeleted;
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        List<SavedFilter> savedFilters = this.m_savedFilters;
        if (savedFilters.isEmpty()) {
            return;
        }
        Collections.sort(savedFilters, new Comparator<SavedFilter>(){

            @Override
            public int compare(@Nullable SavedFilter o1, @Nullable SavedFilter o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getFilterName().compareToIgnoreCase(o2.getFilterName());
            }
        });
        final Table table = new Table();
        this.add(table);
        table.setCssClass("ui-lfsf-st");
        table.setTableHead(Msgs.BUNDLE.getString("lookupform.saved.filters.label"));
        TBody body = new TBody();
        body.setTestID("tableBodyLookupSavedFilter");
        table.add(body);
        body.addCssClass("");
        for (final SavedFilter filter : this.m_savedFilters) {
            ATag filterName = new ATag();
            filterName.setText(filter.getFilterName());
            final TR row = body.addRow();
            row.addCell().add(filterName);
            filterName.setClicked(new IClicked<NodeBase>(){

                @Override
                public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                    if (LookupFormSavedFilterFragment.this.m_onFilterClicked != null) {
                        LookupFormSavedFilterFragment.this.m_onFilterClicked.onNotify(filter);
                    }
                }
            });
            SmallImgButton delImage = new SmallImgButton("THEME/btnDelete.png");
            delImage.setTitle(Msgs.BUNDLE.getString("lookupform.delete.filter"));
            body.addCell().add(delImage);
            delImage.setClicked(new IClicked<NodeBase>(){

                @Override
                public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                    LookupFormSavedFilterFragment.this.m_savedFilters.remove(filter);
                    if (LookupFormSavedFilterFragment.this.m_savedFilters.isEmpty()) {
                        table.remove();
                    } else {
                        row.remove();
                    }
                    if (LookupFormSavedFilterFragment.this.m_onFilterDeleted != null) {
                        LookupFormSavedFilterFragment.this.m_onFilterDeleted.onNotify(filter);
                    }
                }
            });
        }
    }
}

