/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.lookup.BaseAbstractLookupControlImpl;
import to.etc.domui.component.lookup.ILookupControlInstance;
import to.etc.domui.converter.MiniScanner;
import to.etc.domui.converter.MoneyUtil;
import to.etc.domui.converter.NumericUtil;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.Msgs;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QUnaryProperty;

public class LookupNumberControl<T extends Number>
extends BaseAbstractLookupControlImpl<String> {
    public static final Set<QOperation> UNARY_OPS;
    public static final Set<QOperation> BINARY_OPS;
    private final String m_propertyName;
    private final Text<String> m_input;
    private final int m_scale;
    private MiniScanner m_s;
    private Class<T> m_valueType;
    private Number m_minValue;
    private Number m_maxValue;
    private boolean m_monetary;
    private boolean m_allowLike;
    private static final Double m_max_jdbc_column_value;
    private static final Double m_min_jdbc_column_value;

    public LookupNumberControl(Class<T> valueType, Text<String> node, String propertyName, Number minValue, Number maxValue, boolean monetary, int scale) {
        this(valueType, node, propertyName, minValue, maxValue, monetary, true, scale);
    }

    public LookupNumberControl(Class<T> valueType, Text<String> node, String propertyName, Number minValue, Number maxValue, boolean monetary, boolean allowLike, int scale) {
        super(node);
        this.m_input = node;
        this.m_valueType = valueType;
        this.m_propertyName = propertyName;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
        this.m_monetary = monetary;
        this.m_allowLike = allowLike;
        this.m_scale = scale;
    }

    public final boolean isMonetary() {
        return this.m_monetary;
    }

    protected ILookupControlInstance.AppendCriteriaResult appendCriteria(QCriteria<?> crit, QOperation op, T val) throws Exception {
        if (UNARY_OPS.contains(op)) {
            if (val != null) {
                throw new IllegalStateException("Unused value" + val + " for unary operation " + op);
            }
            crit.add((QOperatorNode)new QUnaryProperty(op, this.m_propertyName));
        } else if (BINARY_OPS.contains(op)) {
            if (val == null) {
                throw new IllegalStateException("Missing value for binary operation " + op);
            }
            crit.add((QOperatorNode)new QPropertyComparison(op, this.m_propertyName, (QOperatorNode)new QLiteral(val)));
        } else {
            return ILookupControlInstance.AppendCriteriaResult.INVALID;
        }
        return ILookupControlInstance.AppendCriteriaResult.VALID;
    }

    protected void checkNumber(T value) {
        if (value instanceof Double || value instanceof BigDecimal) {
            if (this.m_maxValue != null && ((Number)value).doubleValue() > this.m_maxValue.doubleValue()) {
                throw new ValidationException(Msgs.BUNDLE, "v.toolarge", this.m_maxValue);
            }
            if (this.m_minValue != null && ((Number)value).doubleValue() < this.m_minValue.doubleValue()) {
                throw new ValidationException(Msgs.BUNDLE, "v.toosmall", this.m_minValue);
            }
            if (((Number)value).doubleValue() >= m_max_jdbc_column_value) {
                throw new ValidationException(Msgs.BUNDLE, "v.toolarge", m_max_jdbc_column_value);
            }
            if (((Number)value).doubleValue() <= m_min_jdbc_column_value) {
                throw new ValidationException(Msgs.BUNDLE, "v.toosmall", m_min_jdbc_column_value);
            }
        } else if (value instanceof Long || value instanceof Integer) {
            if (this.m_maxValue != null && ((Number)value).longValue() > this.m_maxValue.longValue()) {
                throw new ValidationException(Msgs.BUNDLE, "v.toolarge", this.m_maxValue);
            }
            if (this.m_minValue != null && ((Number)value).longValue() < this.m_minValue.longValue()) {
                throw new ValidationException(Msgs.BUNDLE, "v.toosmall", this.m_minValue);
            }
        } else {
            throw new IllegalStateException("Unsupported value type: " + value.getClass());
        }
    }

    @Override
    @Nonnull
    public ILookupControlInstance.AppendCriteriaResult appendCriteria(@Nonnull QCriteria<?> crit) throws Exception {
        try {
            this.m_input.clearMessage();
            String in = this.m_input.getValue();
            if (in == null) {
                return ILookupControlInstance.AppendCriteriaResult.EMPTY;
            }
            if ((in = in.trim()).length() == 0) {
                return ILookupControlInstance.AppendCriteriaResult.EMPTY;
            }
            if ("!".equals(in)) {
                return this.appendCriteria(crit, QOperation.ISNULL, null);
            }
            if ("*".equals(in)) {
                return this.appendCriteria(crit, QOperation.ISNOTNULL, null);
            }
            if (this.m_allowLike) {
                in = in.replace("*", "%");
            }
            this.m_s = new MiniScanner();
            this.m_s.init(in);
            this.m_s.skipWs();
            if (Character.isDigit(this.m_s.LA()) || this.m_s.LA() == 45 || this.m_s.LA() == 37) {
                String v = this.scanNumeric(true);
                if (v == null || "".equals(v)) {
                    throw new ValidationException(Msgs.BUNDLE, "ui.lookup.invalid", new Object[0]);
                }
                if (v.contains("%") && this.m_allowLike) {
                    this.m_s.skipWs();
                    if (!this.m_s.eof()) {
                        throw new ValidationException(Msgs.BUNDLE, "ui.lookup.invalid", new Object[0]);
                    }
                    crit.add((QOperatorNode)new QPropertyComparison(QOperation.LIKE, this.m_propertyName, (QOperatorNode)new QLiteral((Object)v)));
                    return ILookupControlInstance.AppendCriteriaResult.VALID;
                }
                T value = this.parseNumber(v);
                if (value == null) {
                    return ILookupControlInstance.AppendCriteriaResult.INVALID;
                }
                this.checkNumber(value);
                return this.appendCriteria(crit, QOperation.EQ, value);
            }
            QOperation op = this.scanOperation();
            String v = this.scanNumeric(false);
            if (v == null || "".equals(v)) {
                throw new ValidationException(Msgs.BUNDLE, "ui.lookup.invalid", new Object[0]);
            }
            T value = this.parseNumber(v);
            this.checkNumber(value);
            this.m_s.skipWs();
            if (this.m_s.eof()) {
                return this.appendCriteria(crit, op, value);
            }
            QOperation op2 = this.scanOperation();
            this.m_s.skipWs();
            if (this.m_s.eof()) {
                throw new ValidationException(Msgs.BUNDLE, "ui.lookup.invalid", new Object[0]);
            }
            v = this.scanNumeric(false);
            T value2 = this.parseNumber(v);
            this.checkNumber(value2);
            if (!((op != QOperation.GE && op != QOperation.GT || op2 != QOperation.LT && op2 != QOperation.LE) && (op2 != QOperation.GE && op2 != QOperation.GT || op != QOperation.LT && op != QOperation.LE))) {
                ILookupControlInstance.AppendCriteriaResult r1 = this.appendCriteria(crit, op, value);
                ILookupControlInstance.AppendCriteriaResult r2 = this.appendCriteria(crit, op2, value2);
                if (r1 == ILookupControlInstance.AppendCriteriaResult.VALID || r2 == ILookupControlInstance.AppendCriteriaResult.VALID) {
                    return ILookupControlInstance.AppendCriteriaResult.VALID;
                }
                if (r1 == ILookupControlInstance.AppendCriteriaResult.EMPTY || r2 == ILookupControlInstance.AppendCriteriaResult.EMPTY) {
                    return ILookupControlInstance.AppendCriteriaResult.EMPTY;
                }
                return ILookupControlInstance.AppendCriteriaResult.INVALID;
            }
            throw new ValidationException(Msgs.BUNDLE, "ui.lookup.op.combi", new Object[0]);
        }
        catch (UIException x) {
            this.m_input.setMessage(UIMessage.error(x));
            return ILookupControlInstance.AppendCriteriaResult.INVALID;
        }
    }

    @Nonnull
    private String scanNumeric(boolean allowpct) {
        int c;
        this.m_s.skipWs();
        this.m_s.getStringResult();
        while ((c = this.m_s.LA()) == 45 || c == 43 || c == 69 || c == 101 || c == 44 || c == 46 || c == 8364 || c == 36 || Character.isDigit(c) || allowpct && c == 37) {
            this.m_s.copy();
        }
        return this.m_s.getStringResult();
    }

    protected QOperation scanOperation() {
        int c;
        this.m_s.skipWs();
        if (this.m_s.eof()) {
            throw new IllegalStateException("eof at scanning operations");
        }
        if (this.m_s.match(">=")) {
            return QOperation.GE;
        }
        if (this.m_s.match("<=")) {
            return QOperation.LE;
        }
        if (this.m_s.match("<>") || this.m_s.match("!=") || this.m_s.match("!")) {
            return QOperation.NE;
        }
        if (this.m_s.match("<")) {
            return QOperation.LT;
        }
        if (this.m_s.match(">")) {
            return QOperation.GT;
        }
        this.m_s.getStringResult();
        while (!Character.isWhitespace(c = this.m_s.LA()) && !Character.isDigit(c) && c != 45 && c != 46 && c != 44 && c != -1) {
            this.m_s.copy();
        }
        throw new ValidationException("v.invalid.operator", this.m_s.getStringResult());
    }

    protected T parseNumber(String in) {
        try {
            if (this.isMonetary()) {
                return (T)((Number)MoneyUtil.parseMoney(this.m_valueType, in));
            }
            return (T)((Number)NumericUtil.parseNumber(this.m_valueType, in, this.m_scale));
        }
        catch (ValidationException vx) {
            if (vx.getCode().equals("v.toolarge")) {
                if (this.m_maxValue != null) {
                    throw new ValidationException("v.toolarge", this.m_maxValue);
                }
            } else if (vx.getCode().equals("v.toosmall") && this.m_minValue != null) {
                throw new ValidationException("v.toosmall", this.m_minValue);
            }
            throw vx;
        }
    }

    @Override
    public String getValue() {
        return this.m_input.getValue();
    }

    @Override
    public void setValue(String value) {
        this.m_input.setValue(value);
    }

    static {
        m_max_jdbc_column_value = 1.0E126;
        m_min_jdbc_column_value = -1.0E126;
        UNARY_OPS = new HashSet<QOperation>();
        UNARY_OPS.add(QOperation.ISNOTNULL);
        UNARY_OPS.add(QOperation.ISNULL);
        BINARY_OPS = new HashSet<QOperation>();
        BINARY_OPS.add(QOperation.EQ);
        BINARY_OPS.add(QOperation.NE);
        BINARY_OPS.add(QOperation.LT);
        BINARY_OPS.add(QOperation.LE);
        BINARY_OPS.add(QOperation.GT);
        BINARY_OPS.add(QOperation.GE);
        BINARY_OPS.add(QOperation.LIKE);
        BINARY_OPS.add(QOperation.ILIKE);
    }
}

