/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.util.Collections;
import javax.annotation.Nonnull;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.input.AbstractFloatingLookup;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.lookup.IMultiSelectionResult;
import to.etc.domui.component.lookup.LookupForm;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.tbl.DataPager;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IQueryHandler;
import to.etc.domui.component.tbl.MultipleSelectionDataTable;
import to.etc.domui.component.tbl.MultipleSelectionRowRenderer;
import to.etc.domui.component.tbl.SimpleSearchModel;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.QContextManager;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContextFactory;

public class MultipleSelectionLookup<T>
extends AbstractFloatingLookup<T> {
    private static final int WIDTH = 740;
    private LookupForm<T> m_externalLookupForm;
    MultipleSelectionDataTable<T> m_queryResultTable;
    String m_title;
    IMultiSelectionResult<T> m_onReceiveResult;
    private IQueryHandler<T> m_queryHandler;
    private IQueryManipulator<T> m_queryManipulator;
    private IErrorMessageListener m_customErrorMessageListener;
    private String[] m_resultColumns = new String[0];
    private boolean m_allowEmptyQuery;

    public MultipleSelectionLookup(Class<T> lookupClass, ClassMetaModel metaModel, boolean isModal, String title, IMultiSelectionResult<T> onReceiveResult) {
        super(isModal, title, lookupClass, metaModel);
        this.setCssClass("ui-flw");
        if (this.getWidth() == null) {
            this.setWidth("740px");
        }
        this.m_onReceiveResult = onReceiveResult;
    }

    public MultipleSelectionLookup(Class<T> lookupClass, boolean isModal, String title, IMultiSelectionResult<T> onReceiveResult) {
        this(lookupClass, (ClassMetaModel)null, isModal, title, onReceiveResult);
    }

    public void show(NodeBase parent) {
        UrlPage body = parent.getPage().getBody();
        body.add(this);
    }

    @Override
    public void createContent() throws Exception {
        LookupForm lf;
        super.createContent();
        this.setHeight("90%");
        this.setIcon("THEME/btnFind.png");
        if (this.m_customErrorMessageListener != null && this.m_customErrorMessageListener instanceof NodeBase) {
            this.setErrorFence();
            this.add((NodeBase)((Object)this.m_customErrorMessageListener));
            DomUtil.getMessageFence(this).addErrorListener(this.m_customErrorMessageListener);
        }
        LookupForm lookupForm = lf = this.getExternalLookupForm() != null ? this.getExternalLookupForm() : new LookupForm(this.getLookupClass(), this.getMetaModel(), new String[0]);
        if (this.m_onReceiveResult != null) {
            DefaultButton b = new DefaultButton(Msgs.BUNDLE.getString("lookupform.confirm"));
            b.setIcon("THEME/btnConfirm.png");
            b.setTestID("confirmButton");
            b.setClicked(new IClicked<NodeBase>(){

                @Override
                public void clicked(@Nonnull NodeBase xb) throws Exception {
                    MultipleSelectionLookup.this.close();
                    MultipleSelectionLookup.this.m_onReceiveResult.onReturnResult(MultipleSelectionLookup.this.m_queryResultTable != null ? MultipleSelectionLookup.this.m_queryResultTable.getAccumulatedResults() : Collections.EMPTY_LIST);
                }
            });
            lf.addButtonItem(b, 600, LookupForm.ButtonMode.BOTH);
        }
        lf.forceRebuild();
        this.add(lf);
        this.setOnClose(new IWindowClosed(){

            @Override
            public void closed(@Nonnull String closeReason) throws Exception {
                MultipleSelectionLookup.this.clearGlobalMessage("v.missing.search");
                if (MultipleSelectionLookup.this.m_onReceiveResult != null) {
                    MultipleSelectionLookup.this.m_onReceiveResult.onReturnResult(Collections.EMPTY_LIST);
                }
            }
        });
        lf.setClicked(new IClicked<LookupForm<T>>(){

            @Override
            public void clicked(@Nonnull LookupForm<T> b) throws Exception {
                MultipleSelectionLookup.this.search(b);
            }
        });
        lf.setOnCancel(new IClicked<LookupForm<T>>(){

            @Override
            public void clicked(@Nonnull LookupForm<T> b) throws Exception {
                MultipleSelectionLookup.this.closePressed();
            }
        });
    }

    protected void search(LookupForm<T> lf) throws Exception {
        QCriteria<T> c = lf.getEnteredCriteria();
        if (c == null) {
            return;
        }
        if (this.getQueryManipulator() != null) {
            c = this.getQueryManipulator().adjustQuery(c);
        }
        this.clearGlobalMessage("v.missing.search");
        if (!lf.hasUserDefinedCriteria() && !this.isAllowEmptyQuery()) {
            this.addGlobalMessage(UIMessage.error(Msgs.BUNDLE, "v.missing.search", new Object[0]));
            return;
        }
        this.clearGlobalMessage();
        this.setTableQuery(c);
    }

    private void setTableQuery(QCriteria<T> qc) throws Exception {
        SimpleSearchModel<T> model;
        if (this.m_queryHandler == null) {
            QDataContextFactory src = QContextManager.getDataContextFactory((String)"default-context", (IQContextContainer)this.getPage().getConversation());
            model = new SimpleSearchModel<T>(src, qc);
        } else {
            model = new SimpleSearchModel<T>(this.m_queryHandler, qc);
        }
        if (this.m_queryResultTable == null) {
            MultipleSelectionRowRenderer rr = new MultipleSelectionRowRenderer<T>(this.getLookupClass(), this.getMetaModel(), this.m_resultColumns){

                @Override
                public int getRowWidth() {
                    int pxw = DomUtil.pixelSize(MultipleSelectionLookup.this.getWidth());
                    return (pxw == -1 ? 740 : pxw) - 4;
                }

                @Override
                public int getSelectionColWidth() {
                    return 20;
                }
            };
            this.m_queryResultTable = new MultipleSelectionDataTable(this.getLookupClass(), model, rr);
            this.add(this.m_queryResultTable);
            this.m_queryResultTable.setPageSize(10);
            this.m_queryResultTable.setTableWidth("100%");
            rr.setRowClicked(new ICellClicked<T>(){

                @Override
                public void cellClicked(@Nonnull NodeBase tr, @Nonnull T val) throws Exception {
                    MultipleSelectionLookup.this.m_queryResultTable.handleRowClicked(tr, val);
                }
            });
            if (this.isUseStretchedLayout()) {
                this.m_queryResultTable.setStretchHeight(true);
            }
            DataPager pg = new DataPager(this.m_queryResultTable);
            this.add(pg);
        } else {
            this.m_queryResultTable.setModel(model);
        }
        this.m_queryResultTable.setTestID("queryResultTable");
    }

    public LookupForm<T> getExternalLookupForm() {
        return this.m_externalLookupForm;
    }

    public void setExternalLookupForm(LookupForm<T> externalLookupForm) {
        this.m_externalLookupForm = externalLookupForm;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public void setTitle(String title) {
        this.m_title = title;
    }

    public IErrorMessageListener getCustomErrorMessageListener() {
        return this.m_customErrorMessageListener;
    }

    public void setCustomErrorMessageListener(IErrorMessageListener customErrorMessageListener) {
        this.m_customErrorMessageListener = customErrorMessageListener;
    }

    public boolean isAllowEmptyQuery() {
        return this.m_allowEmptyQuery;
    }

    public void setAllowEmptyQuery(boolean allowEmptyQuery) {
        this.m_allowEmptyQuery = allowEmptyQuery;
    }

    public IQueryManipulator<T> getQueryManipulator() {
        return this.m_queryManipulator;
    }

    public void setQueryManipulator(IQueryManipulator<T> queryManipulator) {
        this.m_queryManipulator = queryManipulator;
    }

    public IQueryHandler<T> getQueryHandler() {
        return this.m_queryHandler;
    }

    public void setQueryHandler(IQueryHandler<T> queryHandler) {
        this.m_queryHandler = queryHandler;
    }
}

