/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup;

import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.OldBindingHandler;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.input.TextStr;
import to.etc.domui.component.layout.Dialog;
import to.etc.domui.component.lookup.ILookupFilterHandler;
import to.etc.domui.component.lookup.SavedFilter;
import to.etc.domui.component.lookup.filter.LookupFilterTranslator;
import to.etc.domui.component.misc.MessageFlare;
import to.etc.domui.component2.form4.FormBuilder;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IExecute;
import to.etc.domui.util.Msgs;
import to.etc.webapp.nls.CodeException;
import to.etc.webapp.query.QContextManager;
import to.etc.webapp.query.QDataContext;

@DefaultNonNull
public final class SaveSearchFilterDialog
extends Dialog {
    private final ILookupFilterHandler m_lookupFilterHandler;
    private final String m_pageName;
    private Map<String, ?> m_filterValues;
    @Nullable
    private INotify<SavedFilter> m_onFilterSaved;

    public SaveSearchFilterDialog(ILookupFilterHandler lookupFilterHandler, String pageName, Map<String, ?> filterValues) {
        super(true, false, 500, 200, "Filter opslaan");
        this.m_lookupFilterHandler = lookupFilterHandler;
        this.m_pageName = pageName;
        this.m_filterValues = filterValues;
    }

    public void onFilterSaved(@Nullable INotify<SavedFilter> onFilterSaved) {
        this.m_onFilterSaved = onFilterSaved;
    }

    @Override
    public void createContent() throws Exception {
        this.createButtons();
        FormBuilder fb = new FormBuilder(this);
        final TextStr searchName = new TextStr();
        fb.label("Filter").mandatory().item(searchName);
        searchName.setSize(25);
        searchName.setMaxLength(128);
        this.setOnSave(new IExecute(){

            @Override
            public void execute() throws Exception {
                Long savedFilterId;
                String filterName = (String)DomUtil.nullChecked(searchName.getValue());
                String filterQuery = LookupFilterTranslator.serialize(SaveSearchFilterDialog.this.m_filterValues);
                try (QDataContext unmanagedContext = QContextManager.createUnmanagedContext();){
                    savedFilterId = SaveSearchFilterDialog.this.m_lookupFilterHandler.save(unmanagedContext, SaveSearchFilterDialog.this.m_pageName, filterName, filterQuery);
                    unmanagedContext.commit();
                }
                catch (CodeException x) {
                    MessageFlare.display(SaveSearchFilterDialog.this.getPage().getBody(), MsgType.ERROR, x.getMessage());
                    return;
                }
                SavedFilter savedFilter = new SavedFilter(savedFilterId, filterName, filterQuery);
                if (SaveSearchFilterDialog.this.m_onFilterSaved != null) {
                    SaveSearchFilterDialog.this.m_onFilterSaved.onNotify(savedFilter);
                }
                MessageFlare.display(SaveSearchFilterDialog.this.getPage().getBody(), MsgType.INFO, Msgs.BUNDLE.getString("savesearchfilter.name.saved"));
            }
        });
    }

    @Override
    protected boolean onValidate() throws Exception {
        this.clearGlobalMessage();
        boolean hasBindingErrors = OldBindingHandler.reportBindingErrors(this);
        return !hasBindingErrors;
    }
}

