/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup.filter;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import to.etc.domui.component.lookup.filter.DateFromTo;
import to.etc.domui.component.lookup.filter.ITranslator;
import to.etc.util.DateUtil;
import to.etc.webapp.query.QDataContext;
import to.etc.xml.DomTools;
import to.etc.xml.XmlWriter;

@DefaultNonNull
final class DateFromToTranslator
implements ITranslator<DateFromTo> {
    private static final String DATE_FROM = "dateFrom";
    private static final String DATE_TO = "dateTo";
    private final SimpleDateFormat m_simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");

    DateFromToTranslator() {
    }

    @Override
    @Nullable
    public DateFromTo deserialize(QDataContext dc, Node node) throws Exception {
        Node valueNode = DomTools.nodeFind((Node)node, (String)"value");
        Node dateFromNode = DomTools.nodeFind((Node)valueNode, (String)DATE_FROM);
        String df = DomTools.textFrom((Node)dateFromNode);
        Node dateToNode = DomTools.nodeFind((Node)valueNode, (String)DATE_TO);
        String dt = DomTools.textFrom((Node)dateToNode);
        Date dateFrom = null;
        if (df != null) {
            dateFrom = DateUtil.convertToDate((String)df, (String)this.m_simpleDateFormat.toPattern());
        }
        Date dateTo = null;
        if (dt != null) {
            dateTo = DateUtil.convertToDate((String)dt, (String)this.m_simpleDateFormat.toPattern());
        }
        return new DateFromTo(dateFrom, dateTo);
    }

    @Override
    public boolean serialize(XmlWriter writer, Object o) throws Exception {
        if (o instanceof DateFromTo) {
            Date dt;
            String dateFrom = null;
            String dateTo = null;
            Date df = ((DateFromTo)o).getDateFrom();
            if (df != null) {
                dateFrom = this.m_simpleDateFormat.format(df);
            }
            if ((dt = ((DateFromTo)o).getDateTo()) != null) {
                dateTo = this.m_simpleDateFormat.format(dt);
            }
            writer.tag("value");
            writer.tagfull(DATE_FROM, dateFrom);
            writer.tagfull(DATE_TO, dateTo);
            writer.tagendnl();
            return true;
        }
        return false;
    }
}

