/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup.filter;

import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import to.etc.domui.component.lookup.filter.ITranslator;
import to.etc.domui.component.meta.MetaManager;
import to.etc.webapp.query.QDataContext;
import to.etc.xml.DomTools;
import to.etc.xml.XmlWriter;

@DefaultNonNull
class EnumTranslator<T extends Enum<T>>
implements ITranslator<T> {
    private static final String CLASS = "class";

    EnumTranslator() {
    }

    @Override
    @Nullable
    public T deserialize(QDataContext dc, Node node) throws Exception {
        Node valueNode = DomTools.nodeFind((Node)node, (String)"value");
        String value = DomTools.textFrom((Node)valueNode);
        if (null == value) {
            return null;
        }
        String className = DomTools.strAttr((Node)valueNode, (String)CLASS);
        return this.createEnumValue(className, value);
    }

    private <T extends Enum<T>> T createEnumValue(String clzName, String value) throws ClassNotFoundException {
        Class<?> clzMeta = this.getClass().getClassLoader().loadClass(clzName);
        Class<?> clz = MetaManager.findClassMeta(clzMeta).getActualClass();
        return (T)Enum.valueOf(clz, value);
    }

    @Override
    public boolean serialize(XmlWriter writer, Object o) throws Exception {
        if (o instanceof Enum) {
            writer.tag("value", new String[]{CLASS, o.getClass().getCanonicalName()});
            writer.write(((Enum)o).name());
            writer.tagendnl();
            return true;
        }
        return false;
    }
}

