/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup.filter;

import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import to.etc.domui.component.lookup.filter.ITranslator;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QDataContext;
import to.etc.xml.DomTools;
import to.etc.xml.XmlWriter;

@DefaultNonNull
final class IIdentifyableTranslator
implements ITranslator<IIdentifyable<?>> {
    IIdentifyableTranslator() {
    }

    @Override
    @Nullable
    public IIdentifyable<?> deserialize(QDataContext dc, Node node) throws Exception {
        Node valueNode = DomTools.nodeFind((Node)node, (String)"value");
        String value = DomTools.textFrom((Node)valueNode);
        String className = DomTools.strAttr((Node)valueNode, (String)"class");
        Class<?> clz = this.getClass().getClassLoader().loadClass(className);
        ClassMetaModel classMeta = MetaManager.findClassMeta(clz);
        Class<?> actualClass = classMeta.getActualClass();
        return (IIdentifyable)dc.get(actualClass, (Object)Long.valueOf(value));
    }

    @Override
    public boolean serialize(XmlWriter writer, Object o) throws Exception {
        if (o instanceof IIdentifyable) {
            String className = o.getClass().getCanonicalName();
            writer.tag("value", new String[]{"class", className});
            writer.write(String.valueOf(((IIdentifyable)o).getId()));
            writer.tagendnl();
            return true;
        }
        return false;
    }
}

