/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup.filter;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import org.w3c.dom.Node;
import to.etc.domui.component.lookup.filter.LookupFilterTranslatorRegistry;
import to.etc.webapp.query.QDataContext;
import to.etc.xml.DomTools;
import to.etc.xml.XmlWriter;

@DefaultNonNull
public final class LookupFilterTranslator {
    private static final String FILTER = "Filter";

    private LookupFilterTranslator() {
    }

    public static String serialize(Map<String, ?> filterValues) throws Exception {
        StringWriter serializedFilter = new StringWriter();
        XmlWriter w = new XmlWriter((Writer)serializedFilter);
        w.tag(FILTER);
        for (Map.Entry<String, ?> entry : filterValues.entrySet()) {
            Object filterValue = entry.getValue();
            if (filterValue == null) continue;
            w.tag("item");
            LookupFilterTranslatorRegistry.serialize(w, filterValue, entry.getKey());
            w.tagendnl();
        }
        w.tagendnl();
        w.close();
        return serializedFilter.toString();
    }

    public static Map<String, Object> deserialize(QDataContext dc, String filterQuery) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Node documentRoot = DomTools.getDocumentRoot((String)filterQuery, (String)"", (boolean)false);
        List filterValueNodes = DomTools.nodesFind((Node)documentRoot, (String)"item");
        for (int i = 0; i < filterValueNodes.size(); ++i) {
            Node filterValueNode = (Node)filterValueNodes.get(i);
            Node metaDataNode = DomTools.nodeFind((Node)filterValueNode, (String)"metaData");
            if (metaDataNode == null) continue;
            String key = DomTools.strAttr((Node)metaDataNode, (String)"key");
            String type = DomTools.strAttr((Node)metaDataNode, (String)"type");
            map.put(key, LookupFilterTranslatorRegistry.deserialize(dc, type, filterValueNode));
        }
        return map;
    }
}

