/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.lookup.filter;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import to.etc.domui.component.lookup.filter.BigIntegerTranslator;
import to.etc.domui.component.lookup.filter.BooleanTranslator;
import to.etc.domui.component.lookup.filter.DateFromToTranslator;
import to.etc.domui.component.lookup.filter.EnumTranslator;
import to.etc.domui.component.lookup.filter.IIdentifyableTranslator;
import to.etc.domui.component.lookup.filter.ITranslator;
import to.etc.domui.component.lookup.filter.IntegerTranslator;
import to.etc.domui.component.lookup.filter.SetTranslator;
import to.etc.domui.component.lookup.filter.StringTranslator;
import to.etc.webapp.query.QDataContext;
import to.etc.xml.XmlWriter;

@DefaultNonNull
public final class LookupFilterTranslatorRegistry {
    private static Map<String, ITranslator<?>> m_translators = new HashMap();

    public static synchronized void register(ITranslator<?> translator) {
        m_translators = new HashMap(m_translators);
        m_translators.put(translator.getClass().getCanonicalName(), translator);
    }

    public static void serialize(XmlWriter writer, Object o, @Nullable String key) throws Exception {
        for (Map.Entry<String, ITranslator<?>> entry : m_translators.entrySet()) {
            ITranslator<?> translator = entry.getValue();
            if (!translator.serialize(writer, o)) continue;
            writer.tagonly("metaData", new String[]{"key", key, "type", translator.getClass().getCanonicalName()});
            return;
        }
        throw new IllegalArgumentException("I could not serialize this key/object: " + key + "/" + o);
    }

    @Nullable
    public static Object deserialize(QDataContext dc, String serializerType, Node node) throws Exception {
        ITranslator<?> translator = m_translators.get(serializerType);
        if (translator == null) {
            return null;
        }
        return translator.deserialize(dc, node);
    }

    static {
        LookupFilterTranslatorRegistry.register(new StringTranslator());
        LookupFilterTranslatorRegistry.register(new BooleanTranslator());
        LookupFilterTranslatorRegistry.register(new IntegerTranslator());
        LookupFilterTranslatorRegistry.register(new BigIntegerTranslator());
        LookupFilterTranslatorRegistry.register(new IIdentifyableTranslator());
        LookupFilterTranslatorRegistry.register(new DateFromToTranslator());
        LookupFilterTranslatorRegistry.register(new SetTranslator());
        LookupFilterTranslatorRegistry.register(new EnumTranslator());
    }
}

