/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.menu;

import java.io.Writer;
import java.util.List;
import to.etc.domui.component.menu.IMenuItem;
import to.etc.util.StringTool;

public class MenuGenerator2 {
    public void generate(Writer pw, List<IMenuItem> list) throws Exception {
        pw.append("[");
        boolean first = true;
        for (IMenuItem m : list) {
            if (first) {
                first = false;
            } else {
                pw.append(",\n");
            }
            this.generateNode(pw, m);
        }
        pw.append("]");
    }

    private void generateNode(Writer pw, IMenuItem m) throws Exception {
        pw.append("{");
        pw.append("v:");
        pw.append(Boolean.toString(!m.isDisabled()));
        pw.append(",");
        this.p(pw, "id", m.getId());
        this.p(pw, "desc", m.getDescription());
        this.p(pw, "label", m.getLabel());
        this.p(pw, "icon", m.getIconPath());
        this.p(pw, "kw", m.getSearchString());
        this.p(pw, "path", m.getPageClass() == null ? "" : m.getPageClass().getName() + ".ui");
        this.p(pw, "rurl", m.getRURL());
        this.p(pw, "knd", m.getPageClass() != null ? "domui" : "jsp");
        this.p(pw, "target", m.getTarget());
        if (m.getChildren() != null && m.getChildren().size() > 0) {
            pw.append("children:");
            this.generate(pw, m.getChildren());
        } else {
            pw.append("leaf:true");
        }
        pw.append("}");
    }

    private void p(Writer w, String key, String value) throws Exception {
        if (value == null) {
            return;
        }
        w.append(key);
        w.append(":");
        StringTool.strToJavascriptString((Appendable)w, (String)value, (boolean)true);
        w.append(",");
    }
}

