/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import to.etc.domui.component.menu.IMenuItem;
import to.etc.domui.component.menu.MenuManager;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.state.PageParameters;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsContext;

public class MenuItemImpl
implements IMenuItem {
    private final MenuManager m_manager;
    private String m_id;
    private BundleRef m_msgBundle;
    private String m_labelKey;
    private String m_titleKey;
    private String m_descKey;
    private String m_searchKey;
    private String m_parentID;
    private MenuItemImpl m_parent;
    private Class<? extends UrlPage> m_pageClass;
    private PageParameters m_pageParameters;
    private String m_iconPath;
    private boolean m_disabled;
    private int m_order;
    private boolean m_subMenu;
    private String[] m_requiredRights;
    private List<IMenuItem> m_children = new ArrayList<IMenuItem>();
    private String m_target;
    private String m_rurl;

    public MenuItemImpl(MenuManager m) {
        this.m_manager = m;
    }

    public MenuItemImpl setRequiredRights(String ... rights) {
        this.m_requiredRights = rights;
        return this;
    }

    public MenuItemImpl setImage(String name) {
        this.m_iconPath = name;
        return this;
    }

    public MenuItemImpl setImage(Class<?> res, String name) {
        this.m_iconPath = DomUtil.getJavaResourceRURL(res, name);
        return this;
    }

    public MenuItemImpl setLocation(MenuItemImpl parent, int order) {
        this.m_parent = parent;
        this.m_order = order;
        return this;
    }

    private String byKey(String k) {
        Locale loc = NlsContext.getLocale();
        return this.m_msgBundle.getString(loc, k);
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public BundleRef getMsgBundle() {
        return this.m_msgBundle;
    }

    public void setMsgBundle(BundleRef msgBundle) {
        this.m_msgBundle = msgBundle;
    }

    public String getLabelKey() {
        return this.m_labelKey;
    }

    public void setLabelKey(String labelKey) {
        this.m_labelKey = labelKey;
    }

    public String getDescKey() {
        return this.m_descKey;
    }

    public void setDescKey(String descKey) {
        this.m_descKey = descKey;
    }

    public String getSearchKey() {
        return this.m_searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.m_searchKey = searchKey;
    }

    @Override
    public String getParentID() {
        return this.m_parentID;
    }

    public void setParentID(String parentID) {
        this.m_parentID = parentID;
    }

    @Override
    public Class<? extends UrlPage> getPageClass() {
        return this.m_pageClass;
    }

    public MenuItemImpl setPageClass(Class<? extends UrlPage> pageClass) {
        this.m_pageClass = pageClass;
        return this;
    }

    @Override
    public PageParameters getPageParameters() {
        return this.m_pageParameters;
    }

    public MenuItemImpl setPageParameters(PageParameters pageParameters) {
        this.m_pageParameters = pageParameters;
        return this;
    }

    @Override
    public String getIconPath() {
        return this.m_iconPath;
    }

    public void setIconPath(String iconPath) {
        this.m_iconPath = iconPath;
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    public void setDisabled(boolean disabled) {
        this.m_disabled = disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMenuItem> getChildren() {
        MenuManager menuManager = this.m_manager;
        synchronized (menuManager) {
            return this.m_children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(List<IMenuItem> children) {
        if (!this.m_subMenu) {
            throw new IllegalStateException("Cannot add children to a LEAF item.");
        }
        MenuManager menuManager = this.m_manager;
        synchronized (menuManager) {
            this.m_children = children;
        }
    }

    @Override
    public String getSearchString() {
        return this.byKey(this.m_searchKey);
    }

    @Override
    public String[] getRequiredRights() {
        return this.m_requiredRights;
    }

    @Override
    public String getLabel() {
        return this.byKey(this.m_labelKey);
    }

    @Override
    public String getDescription() {
        return this.byKey(this.m_descKey);
    }

    @Override
    public boolean isSubMenu() {
        return this.m_subMenu;
    }

    public void setSubMenu(boolean subMenu) {
        this.m_subMenu = subMenu;
    }

    @Override
    public int getOrder() {
        return this.m_order;
    }

    public void setOrder(int order) {
        this.m_order = order;
    }

    public String getTitleKey() {
        return this.m_titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.m_titleKey = titleKey;
    }

    public MenuItemImpl getParent() {
        return this.m_parent;
    }

    void setParent(MenuItemImpl parent) {
        this.m_parent = parent;
    }

    @Override
    public String getTarget() {
        return this.m_target;
    }

    public MenuItemImpl setTarget(String target) {
        this.m_target = target;
        return this;
    }

    @Override
    public String getRURL() {
        return this.m_rurl;
    }

    public MenuItemImpl setRURL(String rurl) {
        this.m_rurl = rurl;
        return this;
    }
}

