/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import to.etc.domui.annotations.UIMenu;
import to.etc.domui.component.menu.IMenuItem;
import to.etc.domui.component.menu.IMenuItemFilter;
import to.etc.domui.component.menu.MenuItemImpl;
import to.etc.domui.component.menu.MenuItemProxy;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.state.PageParameters;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.BundleRef;

public final class MenuManager {
    private static MenuManager m_instance = new MenuManager();
    private final List<MenuItemImpl> m_newItemList = new ArrayList<MenuItemImpl>();
    public static final Comparator<IMenuItem> C_BY_ORDER_AND_CHILDREN = new Comparator<IMenuItem>(){

        @Override
        public int compare(IMenuItem o1, IMenuItem o2) {
            boolean c2;
            boolean c1 = o1.getChildren().size() > 0;
            boolean bl = c2 = o2.getChildren().size() > 0;
            if (c1 != c2) {
                return c1 ? 1 : -1;
            }
            return o1.getOrder() - o2.getOrder();
        }
    };
    private final Map<String, MenuItemImpl> m_idMap = new HashMap<String, MenuItemImpl>();
    private final List<IMenuItem> m_rootMenu = new ArrayList<IMenuItem>();

    private MenuManager() {
    }

    public static MenuManager getInstance() {
        return m_instance;
    }

    private synchronized void add(MenuItemImpl m) {
        this.m_newItemList.add(m);
    }

    public MenuItemImpl registerMenuItem(BundleRef bundle, String labelkey, String titlekey, String desckey, String searchKey) {
        MenuItemImpl m = new MenuItemImpl(this);
        m.setMsgBundle(bundle);
        m.setLabelKey(labelkey);
        m.setDescKey(desckey);
        m.setSearchKey(searchKey);
        m.setTitleKey(titlekey);
        this.add(m);
        return m;
    }

    public MenuItemImpl registerMenuItem(BundleRef bundle, String keyBase) {
        MenuItemImpl m = this.registerMenuItem(bundle, keyBase + ".label", keyBase + ".title", keyBase + ".desc", keyBase + ".search");
        m.setId(keyBase);
        return m;
    }

    public MenuItemImpl registerMenuItem(BundleRef bundle, String keyBase, Class<? extends UrlPage> pageClass, Object ... parameters) {
        MenuItemImpl m = this.registerMenuItem(bundle, keyBase);
        m.setPageClass(pageClass);
        m.setPageParameters(new PageParameters(parameters));
        return m;
    }

    private void calculateIcon(MenuItemImpl m, Class<? extends UrlPage> clz) {
        String cn;
        UIMenu ma = clz.getAnnotation(UIMenu.class);
        if (ma != null && ma.iconName() != null) {
            if (ma.iconBase() != Object.class) {
                m.setIconPath(DomUtil.getJavaResourceRURL(ma.iconBase(), ma.iconName()));
            } else {
                m.setIconPath(ma.iconName());
            }
        }
        if (DomUtil.hasResource(clz, cn = DomUtil.getClassNameOnly(clz) + ".png")) {
            m.setIconPath(DomUtil.getJavaResourceRURL(clz, cn));
            return;
        }
    }

    public MenuItemImpl registerMenuItem(Class<? extends UrlPage> pageClass, Object ... parameters) {
        BundleRef br;
        BundleRef ref;
        MenuItemImpl m = new MenuItemImpl(this);
        m.setPageClass(pageClass);
        m.setPageParameters(new PageParameters(parameters));
        this.add(m);
        this.calculateIcon(m, pageClass);
        UIMenu ma = pageClass.getAnnotation(UIMenu.class);
        if (ma != null && (ref = DomUtil.findBundle(ma, pageClass)) != null) {
            boolean ok = false;
            if (ma.baseKey().length() != 0) {
                m.setLabelKey(ma.baseKey() + ".label");
                m.setTitleKey(ma.baseKey() + ".title");
                m.setSearchKey(ma.baseKey() + ".search");
                m.setDescKey(ma.baseKey() + ".desc");
                ok = true;
            }
            if (ma.labelKey().length() != 0) {
                m.setLabelKey(ma.labelKey());
                ok = true;
            }
            if (ma.titleKey().length() != 0) {
                m.setTitleKey(ma.titleKey());
                ok = true;
            }
            if (ma.descKey().length() != 0) {
                m.setDescKey(ma.descKey());
                ok = true;
            }
            if (ma.searchKey().length() != 0) {
                m.setSearchKey(ma.searchKey());
                ok = true;
            }
            m.setMsgBundle(ref);
            if (ok) {
                return m;
            }
        }
        if ((br = DomUtil.getClassBundle(pageClass)).exists()) {
            m.setMsgBundle(br);
            m.setLabelKey("label");
            m.setTitleKey("title");
            m.setSearchKey("search");
            m.setDescKey("desc");
            return m;
        }
        br = DomUtil.getPackageBundle(pageClass);
        if (br.exists()) {
            String bn = pageClass.getName();
            bn = bn.substring(bn.lastIndexOf(46) + 1);
            String kl = bn + ".label";
            String kt = bn + ".title";
            if (br.findMessage(Locale.US, kl) != null || br.findMessage(Locale.US, kt) != null) {
                m.setMsgBundle(br);
                m.setLabelKey(kl);
                m.setTitleKey(kt);
                m.setSearchKey(bn + ".search");
                m.setDescKey(bn + ".desc");
                return m;
            }
        }
        return m;
    }

    public MenuItemImpl registerSubMenu(BundleRef bundle, String keyBase) {
        MenuItemImpl m = this.registerMenuItem(bundle, keyBase);
        m.setSubMenu(true);
        return m;
    }

    public MenuItemImpl registerSubMenu(BundleRef bundle, String keyBase, MenuItemImpl parent, int order) {
        MenuItemImpl m = this.registerSubMenu(bundle, keyBase);
        m.setLocation(parent, order);
        return m;
    }

    public synchronized List<IMenuItem> getRootMenu() {
        if (this.m_newItemList.size() > 0) {
            for (MenuItemImpl m : this.m_newItemList) {
                String id = m.getId();
                if (id == null) {
                    id = m.getPageClass().getName();
                    if (m.getPageParameters() != null) {
                        id = id + "?" + m.getPageParameters().toString();
                    }
                    m.setId(id);
                }
                if (id == null || null == this.m_idMap.put(id, m)) continue;
                System.err.println("MENU: Duplicate menu ID=" + id);
            }
            for (MenuItemImpl m : this.m_newItemList) {
                MenuItemImpl p = this.locateParent(m);
                if (p == null) {
                    this.m_rootMenu.add(m);
                    continue;
                }
                if (p.getChildren().contains(m)) {
                    throw new IllegalStateException("Re-adding a node already present in the menu!?");
                }
                p.getChildren().add(m);
                m.setParent(p);
            }
            this.m_newItemList.clear();
        }
        return this.m_rootMenu;
    }

    private MenuItemImpl locateParent(MenuItemImpl m) {
        MenuItemImpl p;
        if (m.getParent() != null) {
            return m.getParent();
        }
        if (m.getParentID() != null && (p = this.m_idMap.get(m.getParentID())) != null) {
            return p;
        }
        return null;
    }

    public List<IMenuItem> createUserMenu(IMenuItemFilter filter) throws Exception {
        List<IMenuItem> root = this.getRootMenu();
        List<IMenuItem> res = this.createSubMenu(root, filter, null);
        return res;
    }

    private List<IMenuItem> createSubMenu(List<IMenuItem> root, IMenuItemFilter filter, IMenuItem parent) throws Exception {
        ArrayList<IMenuItem> res = new ArrayList<IMenuItem>();
        for (IMenuItem mi : root) {
            MenuItemImpl m = (MenuItemImpl)mi;
            if (filter != null) {
                filter.setNode(m);
                if (!filter.isAllowed()) continue;
            }
            MenuItemProxy p = new MenuItemProxy(m);
            if (m.isSubMenu()) {
                p.setChildren(this.createSubMenu(m.getChildren(), filter, p));
            }
            p.setParent(parent);
            if (m.isSubMenu() && p.getChildren().size() <= 0) continue;
            res.add(p);
        }
        return res;
    }
}

