/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.menu;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.component.menu.SimplePopupMenu;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;

public class PopupMenu {
    private List<Item> m_actionList = new ArrayList<Item>();

    public void addAction(@Nonnull IUIAction<?> action) {
        this.m_actionList.add(new Item(action));
    }

    public void addItem(@Nonnull String caption, String icon, String hint, boolean disabled, IClicked<NodeBase> clk) {
        this.m_actionList.add(new Item(icon, caption, hint, disabled, clk, null));
    }

    public void addItem(@Nonnull String caption, String icon, IClicked<NodeBase> clk) {
        this.m_actionList.add(new Item(icon, caption, null, false, clk, null));
    }

    @Nonnull
    public Submenu addMenu(@Nonnull String caption, String icon, String hint, boolean disabled, Object target) {
        Submenu submenu = new Submenu(icon, caption, hint, disabled, target, null);
        this.m_actionList.add(submenu);
        return submenu;
    }

    public <T> void show(NodeContainer ref, T target) {
        SimplePopupMenu sp;
        NodeContainer nc = ref.getPage().getPopIn();
        if (nc instanceof SimplePopupMenu && (sp = (SimplePopupMenu)nc).getSource() == this && target == sp.getTargetObject()) {
            sp.closeMenu();
            return;
        }
        sp = new SimplePopupMenu((NodeBase)ref, this, this.m_actionList, target);
        ref.getPage().setPopIn(sp);
        ref.getPage().getBody().add(0, sp);
    }

    public final class Submenu
    extends Item {
        @Nonnull
        private final List<Item> m_itemList;
        @Nullable
        private final Object m_target;

        public Submenu(@Nonnull String icon, String title, String hint, boolean disabled, Object target, Submenu parent) {
            super(icon, title, hint, disabled, null, parent);
            this.m_itemList = new ArrayList<Item>();
            this.m_target = target;
        }

        public void addAction(@Nonnull IUIAction<?> action) {
            this.m_itemList.add(new Item(action));
        }

        public void addItem(@Nonnull String caption, String icon, String hint, boolean disabled, IClicked<NodeBase> clk) {
            this.m_itemList.add(new Item(icon, caption, hint, disabled, clk, this));
        }

        public void addItem(@Nonnull String caption, String icon, IClicked<NodeBase> clk) {
            this.m_itemList.add(new Item(icon, caption, null, false, clk, this));
        }

        public void addMenu(@Nonnull String caption, String icon, String hint, boolean disabled, Object target) {
            this.m_itemList.add(new Submenu(icon, caption, hint, disabled, target, this));
        }

        @Nonnull
        public List<Item> getItemList() {
            return this.m_itemList;
        }

        @Nullable
        public Object getTarget() {
            return this.m_target;
        }
    }

    public static class Item {
        private String m_icon;
        private String m_title;
        private String m_hint;
        private boolean m_disabled;
        private IClicked<NodeBase> m_clicked;
        private IUIAction<?> m_action;
        private Submenu m_parent;

        public Item(String icon, @Nonnull String title, String hint, boolean disabled, IClicked<NodeBase> clicked, Submenu parent) {
            this.m_icon = icon;
            this.m_title = title;
            this.m_hint = hint;
            this.m_disabled = disabled;
            this.m_clicked = clicked;
            this.m_parent = parent;
        }

        public Item(IUIAction<?> action) {
            this.m_action = action;
        }

        public String getIcon() {
            return this.m_icon;
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getHint() {
            return this.m_hint;
        }

        public boolean isDisabled() {
            return this.m_disabled;
        }

        public IClicked<NodeBase> getClicked() {
            return this.m_clicked;
        }

        public IUIAction<?> getAction() {
            return this.m_action;
        }

        @Nullable
        public Submenu getParent() {
            return this.m_parent;
        }
    }
}

