/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.component.menu.PopupMenu;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.server.RequestContextImpl;

public class SimplePopupMenu
extends Div {
    private PopupMenu m_source;
    private String m_menuTitle;
    private NodeBase m_relativeTo;
    private Object m_targetObject;
    private final List<PopupMenu.Item> m_actionList;
    private List<MenuLevel> m_stack = new ArrayList<MenuLevel>();

    public SimplePopupMenu() {
        this.m_actionList = new ArrayList<PopupMenu.Item>();
    }

    SimplePopupMenu(NodeBase b, PopupMenu pm, List<PopupMenu.Item> actionList, Object target) {
        this.m_actionList = Collections.unmodifiableList(actionList);
        this.m_targetObject = target;
        this.m_relativeTo = b;
        this.m_source = pm;
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-pmnu");
        Div root = new Div();
        this.add(root);
        root.setCssClass("ui-pmnu-sm");
        Div ttl = new Div();
        root.add(ttl);
        ttl.setCssClass("ui-pmnu-ttl");
        ttl.add(this.m_menuTitle == null ? "Menu" : this.m_menuTitle);
        Div items = new Div();
        root.add(items);
        for (PopupMenu.Item a : this.getActionList()) {
            if (a instanceof PopupMenu.Submenu) {
                this.renderSubmenu(items, (PopupMenu.Submenu)a);
                continue;
            }
            if (a.getAction() != null) {
                this.renderAction(items, a.getAction(), this.m_targetObject);
                continue;
            }
            this.renderItem(items, a);
        }
        this.appendCreateJS("WebUI.popupMenuShow('#" + this.getRelativeTo().getActualID() + "', '#" + this.getActualID() + "');");
    }

    private void setSubmenuSelected(Div selectDiv, boolean on, int level) {
        Img img = selectDiv.getChildren(Img.class).get(0);
        if (on) {
            selectDiv.addCssClass("ui-pmnu-sm" + level);
            img.setSrc("THEME/pmnu-submenu-close.png");
        } else {
            selectDiv.removeCssClass("ui-pmnu-sm" + level);
            img.setSrc("THEME/pmnu-submenu-open.png");
        }
    }

    protected void submenuClicked(Div selectDiv, PopupMenu.Submenu s) throws Exception {
        MenuLevel level;
        if (this.m_stack.size() > 0 && this.m_stack.get(this.m_stack.size() - 1).getSubmenu() == s) {
            MenuLevel level2 = this.m_stack.remove(this.m_stack.size() - 1);
            level2.getDiv().remove();
            this.setSubmenuSelected(level2.getSelDiv(), false, this.m_stack.size() + 1);
            return;
        }
        while (this.m_stack.size() > 0 && (level = this.m_stack.get(this.m_stack.size() - 1)).getSubmenu() != s.getParent()) {
            this.m_stack.remove(this.m_stack.size() - 1);
            level.getDiv().remove();
            this.setSubmenuSelected(level.getSelDiv(), false, this.m_stack.size() + 1);
        }
        Div root = new Div();
        this.add(root);
        root.setCssClass("ui-pmnu-sm ui-pmnu-sm" + (this.m_stack.size() + 1));
        Div ttl = new Div();
        root.add(ttl);
        ttl.setCssClass("ui-pmnu-ttl");
        ttl.add(this.m_menuTitle == null ? "\u00a0" : this.m_menuTitle);
        Div items = new Div();
        root.add(items);
        for (PopupMenu.Item a : s.getItemList()) {
            if (a instanceof PopupMenu.Submenu) {
                this.renderSubmenu(items, (PopupMenu.Submenu)a);
                continue;
            }
            if (a.getAction() != null) {
                Object target = null;
                if (s.getTarget() != null) {
                    target = s.getTarget();
                }
                this.renderAction(items, a.getAction(), target);
                continue;
            }
            this.renderItem(items, a);
        }
        this.setSubmenuSelected(selectDiv, true, this.m_stack.size() + 1);
        this.m_stack.add(new MenuLevel(s, root, selectDiv));
    }

    protected void renderSubmenu(@Nonnull NodeContainer into, final PopupMenu.Submenu a) {
        final Div d = this.renderItem(into, a.getTitle(), a.getHint(), a.getIcon(), false);
        Img img = new Img("THEME/pmnu-submenu-open.png");
        d.add(img);
        d.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                SimplePopupMenu.this.submenuClicked(d, a);
            }
        });
    }

    protected void renderItem(@Nonnull NodeContainer into, final PopupMenu.Item a) {
        Div d = this.renderItem(into, a.getTitle(), a.getHint(), a.getIcon(), false);
        d.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                SimplePopupMenu.this.closeMenu();
                if (null != a.getClicked()) {
                    a.getClicked().clicked(SimplePopupMenu.this);
                }
            }
        });
    }

    private Div renderItem(@Nonnull NodeContainer into, String text, String hint, String icon, boolean disabled) {
        Div d = new Div();
        into.add(d);
        d.setCssClass("ui-pmnu-action " + (disabled ? "ui-pmnu-disabled" : "ui-pmnu-enabled"));
        if (null != icon) {
            d.setBackgroundImage(icon);
        }
        d.add(text);
        if (null != hint) {
            d.setTitle(hint);
        }
        return d;
    }

    protected <T> void renderAction(@Nonnull NodeContainer into, final IUIAction<T> action, final T val) throws Exception {
        String disa = action.getDisableReason(val);
        if (null != disa) {
            this.renderItem(into, action.getName(val), disa, action.getIcon(val), true);
            return;
        }
        Div d = this.renderItem(into, action.getName(val), action.getTitle(val), action.getIcon(val), false);
        d.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                SimplePopupMenu.this.closeMenu();
                action.execute(SimplePopupMenu.this.getRelativeTo(), val);
            }
        });
    }

    public void closeMenu() {
        if (!this.isAttached()) {
            return;
        }
        this.clearPopinIf();
        this.forceRebuild();
        this.appendJavascript("WebUI.popinClosed('#" + this.getActualID() + "');");
        this.remove();
    }

    protected List<PopupMenu.Item> getActionList() {
        return this.m_actionList;
    }

    private NodeBase getRelativeTo() {
        return this.m_relativeTo;
    }

    public void addAction(IUIAction<?> action) {
        this.getActionList().add(new PopupMenu.Item(action));
    }

    public void addItem(String caption, String icon, String hint, boolean disabled, IClicked<NodeBase> clk) {
        this.getActionList().add(new PopupMenu.Item(icon, caption, hint, disabled, clk, null));
    }

    public void addItem(String caption, String icon, IClicked<NodeBase> clk) {
        this.getActionList().add(new PopupMenu.Item(icon, caption, null, false, clk, null));
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        System.out.println("SimplePopupMenu: received " + action);
        if ("POPINCLOSE?".equals(action)) {
            this.closeMenu();
        } else {
            super.componentHandleWebAction(ctx, action);
        }
    }

    PopupMenu getSource() {
        return this.m_source;
    }

    public Object getTargetObject() {
        return this.m_targetObject;
    }

    protected void clearPopinIf() {
        this.getPage().clearPopIn();
    }

    private static class MenuLevel {
        private PopupMenu.Submenu m_submenu;
        private Div m_div;
        private Div m_selDiv;

        public MenuLevel(PopupMenu.Submenu submenu, Div div, Div selDiv) {
            this.m_submenu = submenu;
            this.m_div = div;
            this.m_selDiv = selDiv;
        }

        public PopupMenu.Submenu getSubmenu() {
            return this.m_submenu;
        }

        public Div getDiv() {
            return this.m_div;
        }

        public Div getSelDiv() {
            return this.m_selDiv;
        }
    }
}

