/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.ValueLabelPair;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.IClassMetaModelFactory;
import to.etc.domui.component.meta.IMetaClass;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.component.meta.impl.DefaultJavaClassMetaModelFactory;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.component.meta.impl.MetaModelException;
import to.etc.domui.component.meta.impl.PathPropertyMetaModel;
import to.etc.domui.component.meta.impl.SearchPropertyMetaModelImpl;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.login.IUser;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.state.UIContext;
import to.etc.domui.util.DisplayPropertyNodeContentRenderer;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.ILabelStringRenderer;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;
import to.etc.domui.util.db.CriteriaMatchingVisitor;
import to.etc.util.DeveloperOptions;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.nls.NlsContext;
import to.etc.webapp.qsql.JdbcUtil;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QNodeVisitor;

public final class MetaManager {
    @Nonnull
    private static final String pFIELDHANDLER = "fieldHandler";
    private static List<IClassMetaModelFactory> m_modelList = new ArrayList<IClassMetaModelFactory>();
    private static Map<Object, ClassMetaModel> m_classMap = new HashMap<Object, ClassMetaModel>();
    private static final Stack<Object> m_initStack = new Stack();
    private static final List<Runnable> m_initList = new ArrayList<Runnable>();
    private static INodeContentRenderer<?> TOSTRING_RENDERER = new INodeContentRenderer<Object>(){

        @Override
        public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable Object object, @Nullable Object parameters) {
            if (object != null) {
                node.add(object.toString());
            }
        }
    };
    public static final Comparator<DisplayPropertyMetaModel> C_BY_SORT_INDEX = new Comparator<DisplayPropertyMetaModel>(){

        @Override
        public int compare(DisplayPropertyMetaModel a, DisplayPropertyMetaModel b) {
            return a.getSortIndex() - b.getSortIndex();
        }
    };

    private MetaManager() {
    }

    public static synchronized void registerModel(@Nonnull IClassMetaModelFactory model) {
        ArrayList<IClassMetaModelFactory> mm = new ArrayList<IClassMetaModelFactory>(m_modelList);
        mm.add(model);
        m_modelList = mm;
    }

    @Nonnull
    private static synchronized List<IClassMetaModelFactory> getList() {
        if (m_modelList.size() == 0) {
            MetaManager.registerModel(new DefaultJavaClassMetaModelFactory());
        }
        return m_modelList;
    }

    @Nonnull
    public static ClassMetaModel findClassMeta(@Nonnull Class<?> clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Class<?> parameter cannot be null");
        }
        if (clz.getName().contains("$$")) {
            clz = clz.getSuperclass();
        }
        return MetaManager.findAndInitialize(clz);
    }

    @Nonnull
    public static ClassMetaModel findClassMeta(@Nonnull IMetaClass mc) {
        if (mc instanceof ClassMetaModel) {
            return (ClassMetaModel)((Object)mc);
        }
        if (mc == null) {
            throw new IllegalArgumentException("IMetaClass parameter cannot be null");
        }
        return MetaManager.findAndInitialize(mc);
    }

    public static synchronized void internalClear() {
        m_classMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static ClassMetaModel findAndInitialize(@Nonnull Object mc) {
        Class<MetaManager> clazz = MetaManager.class;
        synchronized (MetaManager.class) {
            ClassMetaModel cmm = m_classMap.get(mc);
            if (cmm != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return cmm;
            }
            MetaManager.checkInitStack(mc, "primary initialization");
            IClassMetaModelFactory best = MetaManager.findModelFactory(mc);
            m_initStack.add(mc);
            cmm = best.createModel(m_initList, mc);
            m_classMap.put(mc, cmm);
            m_initStack.remove(mc);
            if (m_initStack.size() == 0 && m_initList.size() > 0) {
                ArrayList<Runnable> dl = new ArrayList<Runnable>(m_initList);
                m_initList.clear();
                for (Runnable r : dl) {
                    r.run();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cmm;
        }
    }

    private static void checkInitStack(Object mc, String msg) {
        if (m_initStack.contains(mc)) {
            m_initStack.add(mc);
            StringBuilder sb = new StringBuilder();
            for (Object e : m_initStack) {
                if (sb.length() > 0) {
                    sb.append(" -> ");
                }
                sb.append(e.toString());
            }
            m_initStack.clear();
            throw new IllegalStateException("Circular reference in " + msg + ": " + sb.toString());
        }
    }

    @Nonnull
    private static synchronized IClassMetaModelFactory findModelFactory(Object theThingy) {
        int bestscore = 0;
        int hitct = 0;
        IClassMetaModelFactory best = null;
        for (IClassMetaModelFactory mmf : MetaManager.getList()) {
            int score = mmf.accepts(theThingy);
            if (score <= 0) continue;
            if (score == bestscore) {
                ++hitct;
                continue;
            }
            if (score <= bestscore) continue;
            bestscore = score;
            best = mmf;
            hitct = 1;
        }
        if (best == null) {
            throw new IllegalStateException("No IClassModelFactory accepts the type '" + theThingy + "', which is a " + theThingy.getClass());
        }
        if (hitct > 1) {
            throw new IllegalStateException("Two IClassModelFactory's accept the type '" + theThingy + "' (which is a " + theThingy.getClass() + ") at score=" + bestscore);
        }
        return best;
    }

    @Nullable
    public static PropertyMetaModel<?> findPropertyMeta(@Nonnull Class<?> clz, @Nonnull String name) {
        ClassMetaModel cm = MetaManager.findClassMeta(clz);
        return cm.findProperty(name);
    }

    @Nullable
    public static PropertyMetaModel<?> findPropertyMeta(IMetaClass mc, String name) {
        ClassMetaModel cm = MetaManager.findClassMeta(mc);
        return cm.findProperty(name);
    }

    @Nonnull
    public static PropertyMetaModel<?> getPropertyMeta(Class<?> clz, String name) {
        PropertyMetaModel<?> pmm = MetaManager.findPropertyMeta(clz, name);
        if (pmm == null) {
            throw new ProgrammerErrorException("The property '" + clz.getName() + "." + name + "' is not known.");
        }
        return pmm;
    }

    @Nonnull
    public static PropertyMetaModel<?> getPropertyMeta(IMetaClass clz, String name) {
        PropertyMetaModel<?> pmm = MetaManager.findPropertyMeta(clz, name);
        if (pmm == null) {
            throw new ProgrammerErrorException("The property '" + clz + "." + name + "' is not known.");
        }
        return pmm;
    }

    public static boolean isAccessAllowed(String[][] roleset, IRequestContext ctx) {
        if (roleset == null) {
            return true;
        }
        IUser user = UIContext.getCurrentUser();
        if (null == user) {
            return false;
        }
        for (String[] orset : roleset) {
            boolean ok = true;
            for (String perm : orset) {
                if (user.hasRight(perm)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return true;
        }
        return false;
    }

    private static INodeContentRenderer<?> createComboLabelRenderer(Class<? extends ILabelStringRenderer<?>> lsr) {
        final ILabelStringRenderer<?> lr = DomApplication.get().createInstance(lsr, new Object[0]);
        return new INodeContentRenderer<Object>(){

            @Override
            public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable Object object, @Nullable Object parameters) {
                String text = lr.getLabelFor(object);
                if (text != null) {
                    node.add(text);
                }
            }
        };
    }

    private static boolean hasDisplayProperties(List<DisplayPropertyMetaModel> list) {
        return list != null && list.size() > 0;
    }

    @Nonnull
    public static INodeContentRenderer<?> createDefaultComboRenderer(@Nullable PropertyMetaModel<?> pmm, @Nullable ClassMetaModel cmm) {
        if (pmm != null) {
            cmm = MetaManager.findClassMeta(pmm.getActualType());
            if (pmm.getComboNodeRenderer() != null) {
                return DomApplication.get().createInstance(pmm.getComboNodeRenderer(), new Object[0]);
            }
            if (pmm.getComboLabelRenderer() != null) {
                return MetaManager.createComboLabelRenderer(pmm.getComboLabelRenderer());
            }
            List<DisplayPropertyMetaModel> dpl = pmm.getComboDisplayProperties();
            if (!MetaManager.hasDisplayProperties(dpl)) {
                dpl = cmm.getComboDisplayProperties();
            }
            if (MetaManager.hasDisplayProperties(dpl)) {
                List<ExpandedDisplayProperty<?>> xpl = ExpandedDisplayProperty.expandDisplayProperties(dpl, cmm, null);
                return new DisplayPropertyNodeContentRenderer(cmm, xpl);
            }
            return TOSTRING_RENDERER;
        }
        if (cmm != null) {
            if (cmm.getComboNodeRenderer() != null) {
                return DomApplication.get().createInstance(cmm.getComboNodeRenderer(), new Object[0]);
            }
            if (cmm.getComboLabelRenderer() != null) {
                return MetaManager.createComboLabelRenderer(cmm.getComboLabelRenderer());
            }
            if (MetaManager.hasDisplayProperties(cmm.getComboDisplayProperties())) {
                List<ExpandedDisplayProperty<?>> xpl = ExpandedDisplayProperty.expandDisplayProperties(cmm.getComboDisplayProperties(), cmm, null);
                return new DisplayPropertyNodeContentRenderer(cmm, xpl);
            }
        }
        return TOSTRING_RENDERER;
    }

    public static boolean areObjectsEqual(Object a, Object b, ClassMetaModel cmm) {
        Class<?> bcl;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        Class<?> acl = a.getClass();
        if (!acl.isAssignableFrom(bcl = b.getClass()) && !bcl.isAssignableFrom(acl)) {
            return false;
        }
        if (cmm == null) {
            cmm = MetaManager.findClassMeta(a.getClass());
        }
        if (cmm.getPrimaryKey() != null) {
            try {
                ClassMetaModel bcmm;
                ClassMetaModel acmm;
                if (acl != bcl) {
                    acmm = MetaManager.findClassMeta(acl);
                    bcmm = MetaManager.findClassMeta(bcl);
                } else {
                    acmm = cmm;
                    bcmm = cmm;
                }
                PropertyMetaModel<?> apkmm = acmm.getPrimaryKey();
                PropertyMetaModel<?> bpkmm = bcmm.getPrimaryKey();
                if (apkmm == null || bpkmm == null) {
                    return false;
                }
                Object pka = apkmm.getValue(a);
                Object pkb = bpkmm.getValue(b);
                if (pka == null || pkb == null) {
                    return false;
                }
                return DomUtil.isEqual(pka, pkb);
            }
            catch (Exception x) {
                x.printStackTrace();
                return false;
            }
        }
        if (a.getClass().isArray()) {
            if (Array.getLength(a) != Array.getLength(b)) {
                return false;
            }
            int i = Array.getLength(a);
            while (--i >= 0) {
                if (MetaManager.areObjectsEqual(Array.get(a, i), Array.get(b, i), MetaManager.findClassMeta(acl.getComponentType()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean areObjectsEqual(Object a, Object b) {
        return MetaManager.areObjectsEqual(a, b, null);
    }

    public static <T extends Enum<?>> String findEnumLabel(T val) {
        if (val == null) {
            return null;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return cmm.getDomainLabel(NlsContext.getLocale(), val);
    }

    public static <T extends Enum<?>> List<ValueLabelPair<T>> createEnumList(Class<T> clz) {
        ArrayList<ValueLabelPair<T>> res = new ArrayList<ValueLabelPair<T>>();
        ClassMetaModel cmm = MetaManager.findClassMeta(clz);
        Object[] values = cmm.getDomainValues();
        if (values == null) {
            throw new IllegalStateException("The class " + clz + " does not have a discrete list of Domain Values");
        }
        for (Object value : values) {
            String label = cmm.getDomainLabel(NlsContext.getLocale(), value);
            if (label == null) {
                label = value == null ? "" : value.toString();
            }
            res.add(new ValueLabelPair<Enum>((Enum)value, label));
        }
        return res;
    }

    public static PropertyMetaModel<?> internalCalculateDottedPath(ClassMetaModel cmm, String name) {
        int pos = name.indexOf(46);
        if (pos == -1) {
            return cmm.findSimpleProperty(name);
        }
        int ix = 0;
        int len = name.length();
        ClassMetaModel ccmm = cmm;
        ArrayList acl = new ArrayList(10);
        while (true) {
            String sub = name.substring(ix, pos);
            ix = pos + 1;
            PropertyMetaModel<?> pmm = ccmm.findSimpleProperty(sub);
            if (pmm == null) {
                throw new IllegalStateException("Invalid property path '" + name + "' on " + cmm + ": property '" + sub + "' on classMetaModel=" + ccmm + " does not exist");
            }
            acl.add(pmm);
            ccmm = MetaManager.findClassMeta(pmm.getActualType());
            if (ix >= len) break;
            pos = name.indexOf(46, ix);
            if (pos != -1) continue;
            pos = len;
        }
        return new PathPropertyMetaModel(name, acl.toArray(new PropertyMetaModel[acl.size()]));
    }

    public static List<PropertyMetaModel<?>> parsePropertyPath(@Nonnull ClassMetaModel m, String compoundName) {
        int ix = 0;
        int len = compoundName.length();
        ArrayList res = new ArrayList();
        ClassMetaModel cmm = m;
        while (ix < len) {
            String name;
            int pos = compoundName.indexOf(46, ix);
            if (pos == -1) {
                name = compoundName.substring(ix);
                ix = len;
            } else {
                name = compoundName.substring(ix, pos);
                ix = pos + 1;
            }
            if (null == cmm) {
                throw new IllegalStateException("Metamodel got null while parsing " + compoundName);
            }
            PropertyMetaModel<?> pmm = cmm.findSimpleProperty(name);
            if (pmm == null) {
                throw new MetaModelException(Msgs.BUNDLE, "mm.compound.prop", compoundName, name, cmm.toString());
            }
            if (pmm.getRelationType() == PropertyRelationType.DOWN || Collection.class.isAssignableFrom(pmm.getActualType()) || pmm.getActualType().isArray()) {
                Class<?> vclass;
                ClassMetaModel nextmm = null;
                Type vtype = pmm.getGenericActualType();
                if (vtype != null && (vclass = MetaManager.findCollectionType(vtype)) != null) {
                    nextmm = MetaManager.findClassMeta(vclass);
                }
                if (nextmm == null && ix >= len) {
                    throw new MetaModelException(Msgs.BUNDLE, "mm.unknown.collection.type", compoundName, name, vtype);
                }
                cmm = nextmm;
            } else {
                cmm = pmm.getValueModel();
                if (null == cmm) {
                    cmm = MetaManager.findClassMeta(pmm.getActualType());
                }
            }
            res.add(pmm);
        }
        return res;
    }

    @Nullable
    public static Class<?> findCollectionType(Type genericType) {
        Type[] tar;
        Class cl;
        ParameterizedType pt;
        Type raw;
        Class cl2;
        if (genericType instanceof Class && (cl2 = (Class)genericType).isArray()) {
            return cl2.getComponentType();
        }
        if (genericType instanceof ParameterizedType && (raw = (pt = (ParameterizedType)genericType).getRawType()) instanceof Class && Collection.class.isAssignableFrom(cl = (Class)raw) && (tar = pt.getActualTypeArguments()) != null && tar.length == 1) {
            return (Class)tar[0];
        }
        return null;
    }

    public static <T> boolean hasDuplicates(List<T> items, T instance, String propertyname) throws Exception {
        ClassMetaModel cmm = MetaManager.findClassMeta(instance.getClass());
        PropertyMetaModel<?> pmm = MetaManager.getPropertyMeta(instance.getClass(), propertyname);
        Object vi = pmm.getValue(instance);
        ClassMetaModel vcmm = vi == null ? null : MetaManager.findClassMeta(vi.getClass());
        for (T v : items) {
            Object vl;
            if (MetaManager.areObjectsEqual(instance, v, cmm) || !MetaManager.areObjectsEqual(vi, vl = pmm.getValue(v), vcmm)) continue;
            return true;
        }
        return false;
    }

    public static String identify(Object t) {
        if (t == null) {
            return "null";
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(t.getClass());
        PropertyMetaModel<?> pkmm = cmm.getPrimaryKey();
        if (cmm.isPersistentClass() && pkmm != null) {
            try {
                Object k = pkmm.getValue(t);
                return t.getClass().getName() + "#" + k + " @" + System.identityHashCode(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t.toString() + " @" + System.identityHashCode(t);
    }

    public static Object getPrimaryKey(Object instance) throws Exception {
        return MetaManager.getPrimaryKey(instance, null);
    }

    public static Object getPrimaryKey(Object instance, ClassMetaModel cmm) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        if (cmm == null) {
            cmm = MetaManager.findClassMeta(instance.getClass());
        }
        if (!cmm.isPersistentClass()) {
            throw new IllegalArgumentException("The instance " + MetaManager.identify(instance) + " is not a persistent class");
        }
        PropertyMetaModel<?> pmm = cmm.getPrimaryKey();
        if (pmm == null) {
            throw new IllegalArgumentException("The instance " + MetaManager.identify(instance) + " has an undefined primary key (cannot be obtained by metadata)");
        }
        return pmm.getValue(instance);
    }

    @Nonnull
    public static List<SearchPropertyMetaModel> calculateSearchProperties(ClassMetaModel cm) {
        if (!DeveloperOptions.getBool((String)"domui.generatemeta", (boolean)false)) {
            return Collections.emptyList();
        }
        if (cm.getSearchProperties() != null && cm.getSearchProperties().size() > 0) {
            return cm.getSearchProperties();
        }
        int order = 0;
        ArrayList<SearchPropertyMetaModel> res = new ArrayList<SearchPropertyMetaModel>();
        for (PropertyMetaModel<?> pmm : cm.getProperties()) {
            if (!DomUtil.isBasicType(pmm.getActualType()) ? pmm.getRelationType() != PropertyRelationType.UP : pmm.getLength() > 50) continue;
            SearchPropertyMetaModelImpl sp = new SearchPropertyMetaModelImpl(cm);
            sp.setIgnoreCase(true);
            sp.setOrder(order++);
            sp.setPropertyName(pmm.getName());
            ArrayList pl = new ArrayList(1);
            pl.add(pmm);
            sp.setPropertyPath(pl);
            res.add(sp);
        }
        return res;
    }

    @Nonnull
    public static List<DisplayPropertyMetaModel> calculateObjectProperties(ClassMetaModel cm) {
        if (!DeveloperOptions.getBool((String)"domui.generatemeta", (boolean)false)) {
            return Collections.emptyList();
        }
        ArrayList<DisplayPropertyMetaModel> res = new ArrayList<DisplayPropertyMetaModel>();
        int totlen = 0;
        for (PropertyMetaModel<?> pmm : cm.getProperties()) {
            if (totlen > 512 || res.size() > 20) break;
            if (!DomUtil.isBasicType(pmm.getActualType()) || pmm.getLength() > 50) continue;
            totlen = pmm.getLength() > 0 ? (totlen += pmm.getLength()) : (pmm.getPrecision() > 0 ? (totlen += pmm.getPrecision()) : (totlen += 10));
            DisplayPropertyMetaModel dp = new DisplayPropertyMetaModel(pmm);
            res.add(dp);
        }
        return res;
    }

    public static String getEnumLabel(Enum<?> label) {
        if (label == null) {
            return null;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(label.getClass());
        String s = cmm.getDomainLabel(NlsContext.getLocale(), label);
        if (s == null) {
            s = String.valueOf(label);
        }
        return s;
    }

    public static String getEnumLabel(Class<?> clz, String property, Object value) {
        if (value == null) {
            return null;
        }
        return MetaManager.getEnumLabel(MetaManager.findPropertyMeta(clz, property), value);
    }

    public static String getEnumLabel(PropertyMetaModel<?> pmm, Object value) {
        if (value == null) {
            return null;
        }
        Locale loc = NlsContext.getLocale();
        String v = pmm.getDomainValueLabel(loc, value);
        if (v == null) {
            ClassMetaModel cmm = pmm.getValueModel();
            if (null == cmm) {
                cmm = MetaManager.findClassMeta(pmm.getActualType());
            }
            if ((v = cmm.getDomainLabel(loc, value)) == null) {
                if (value.getClass() != cmm.getActualClass()) {
                    cmm = MetaManager.findClassMeta(value.getClass());
                    v = cmm.getDomainLabel(loc, value);
                }
                if (v == null) {
                    v = String.valueOf(value);
                }
            }
        }
        return v;
    }

    public static void copyValuesExcept(Object to, Object from, Object ... except) throws Exception {
        HashSet<Object> exceptSet = new HashSet<Object>();
        for (Object xc : except) {
            exceptSet.add(xc);
        }
        List<PropertyMetaModel<?>> tolist = MetaManager.findClassMeta(to.getClass()).getProperties();
        HashMap tomap = new HashMap();
        for (PropertyMetaModel<?> pmm : tolist) {
            tomap.put(pmm.getName(), pmm);
        }
        List<PropertyMetaModel<?>> frlist = MetaManager.findClassMeta(from.getClass()).getProperties();
        for (PropertyMetaModel<?> frpmm : frlist) {
            PropertyMetaModel topmm;
            if (MetaManager.isExcepted(exceptSet, frpmm) || null == (topmm = (PropertyMetaModel)tomap.get(frpmm.getName())) || !topmm.getActualType().isAssignableFrom(frpmm.getActualType()) || topmm.getReadOnly() == YesNoType.YES) continue;
            topmm.setValue(to, frpmm.getValue(from));
        }
    }

    private static boolean isExcepted(@Nonnull Set<Object> exceptSet, @Nonnull PropertyMetaModel<?> frpmm) {
        if (exceptSet.contains(frpmm.getName())) {
            return true;
        }
        for (Object t : exceptSet) {
            Class rc;
            if (t != Class.class || !(rc = (Class)t).isAssignableFrom(frpmm.getActualType())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static List<DisplayPropertyMetaModel> getComboProperties(@Nonnull PropertyMetaModel<?> pmm) {
        List<DisplayPropertyMetaModel> res = pmm.getComboDisplayProperties();
        if (res.size() != 0) {
            return res;
        }
        ClassMetaModel vm = pmm.getValueModel();
        if (null == vm) {
            throw new IllegalStateException(pmm + ": property has no 'value metamodel'");
        }
        return vm.getComboDisplayProperties();
    }

    public static void applyPropertySort(@Nonnull QCriteria<?> q, @Nonnull List<DisplayPropertyMetaModel> properties) {
        ArrayList<DisplayPropertyMetaModel> sl = new ArrayList<DisplayPropertyMetaModel>();
        boolean hasindex = false;
        for (DisplayPropertyMetaModel p : properties) {
            if (p.getSortable() == SortableType.SORTABLE_ASC || p.getSortable() == SortableType.SORTABLE_DESC) {
                sl.add(p);
            }
            if (p.getSortIndex() < 0) continue;
            hasindex = true;
        }
        if (sl.size() == 0) {
            return;
        }
        if (hasindex) {
            Collections.sort(sl, C_BY_SORT_INDEX);
        }
        block5: for (DisplayPropertyMetaModel p : sl) {
            switch (p.getSortable()) {
                default: {
                    throw new IllegalStateException("Unexpected sort type: " + (Object)((Object)p.getSortable()));
                }
                case SORTABLE_ASC: {
                    q.ascending(p.getProperty().getName());
                    continue block5;
                }
                case SORTABLE_DESC: 
            }
            q.descending(p.getProperty().getName());
        }
    }

    public static <T> void fillCopy(@Nonnull T source, @Nonnull T target) {
        MetaManager.fillCopy(source, target, false, false, false, new String[0]);
    }

    public static <T> void fillCopy(@Nonnull T source, @Nonnull T target, String ... ignoredColumns) {
        MetaManager.fillCopy(source, target, false, false, false, ignoredColumns);
    }

    public static <T> void fillCopy(@Nonnull T source, @Nonnull T target, boolean copyPK, boolean copyTCN, boolean copyTransient, String ... ignoredColumns) {
        ClassMetaModel cmm = MetaManager.findClassMeta(source.getClass());
        ArrayList<String> ignoreList = new ArrayList<String>(ignoredColumns.length);
        for (String ignore : ignoredColumns) {
            ignoreList.add(ignore);
        }
        for (PropertyMetaModel propertyMetaModel : cmm.getProperties()) {
            PropertyMetaModel opmm = propertyMetaModel;
            if (opmm.isPrimaryKey() && !copyPK || opmm.isTransient() && !copyTransient || "tcn".equalsIgnoreCase(opmm.getName()) && !copyTCN || pFIELDHANDLER.equals(opmm.getName()) || opmm.getReadOnly() == YesNoType.YES || ignoreList.size() != 0 && ignoreList.contains(opmm.getName())) continue;
            try {
                opmm.setValue(target, opmm.getValue(source));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public static synchronized ClassMetaModel findClassByTable(@Nonnull String tableName) {
        for (ClassMetaModel cmm : m_classMap.values()) {
            if (!tableName.equalsIgnoreCase(cmm.getTableName())) continue;
            return cmm;
        }
        return null;
    }

    @Nullable
    public static <K, T extends IIdentifyable<K>> String hasChildRecords(QDataContext dc, @Nonnull String schemaName, @Nonnull T instance) throws Exception {
        ClassMetaModel cmm = MetaManager.findClassMeta(instance.getClass());
        if (!cmm.isPersistentClass()) {
            throw new IllegalArgumentException("The instance class " + cmm + " is not a persistent class");
        }
        Object pk = instance.getId();
        if (null == pk) {
            return null;
        }
        String tableName = cmm.getTableName();
        if (null == tableName) {
            throw new IllegalArgumentException("The instance class " + cmm + " does not know it's database table name");
        }
        String childTbl = JdbcUtil.hasChildRecords((Connection)dc.getConnection(), (String)schemaName, (String)tableName, (String)pk.toString());
        if (null == childTbl) {
            return null;
        }
        ClassMetaModel chmm = MetaManager.findClassByTable(childTbl);
        if (chmm == null) {
            return childTbl;
        }
        String s = chmm.getUserEntityName();
        if (null != s) {
            return s;
        }
        return childTbl;
    }

    @Nonnull
    public static <X, T extends Collection<X>> List<X> filter(@Nonnull T in, @Nonnull QCriteria<X> query) throws Exception {
        CriteriaMatchingVisitor<X> v = null;
        ArrayList<X> res = new ArrayList<X>();
        for (X item : in) {
            if (item == null) continue;
            if (v == null) {
                ClassMetaModel cmm = MetaManager.findClassMeta(item.getClass());
                v = new CriteriaMatchingVisitor<X>(item, cmm);
            } else {
                v.setInstance(item);
            }
            query.visit((QNodeVisitor)v);
            if (!v.isMatching()) continue;
            res.add(item);
        }
        return res;
    }
}

