/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.YesNoType;

@DefaultNonNull
class MetaObjectCopyBase<T> {
    private final T m_source;
    private Set<String> m_onlySet = new HashSet<String>();
    private int m_ignored;
    private final Mode m_defaultMode;
    @Nullable
    private T m_copy;
    private Map<String, Mode> m_modeMap = new HashMap<String, Mode>();
    @Nonnull
    private Map<Object, Object> m_old2newmap = new HashMap<Object, Object>();
    private int m_copies;
    private Class<?>[] UNCOPYABLE = new Class[]{Date.class, String.class};

    protected MetaObjectCopyBase(T source, Mode mode) {
        this.m_source = source;
        this.m_defaultMode = mode;
    }

    public MetaObjectCopyBase<T> ignore(String ... properties) {
        if (this.m_onlySet.size() > 0) {
            throw new IllegalArgumentException("Either use igore or only, not both!");
        }
        for (String p : properties) {
            Mode prev = this.m_modeMap.put(p, Mode.IGNORE);
            if (null != prev) {
                throw new IllegalArgumentException("Property " + p + " was set to " + (Object)((Object)prev) + " earlier");
            }
            ++this.m_ignored;
        }
        return this;
    }

    protected void setOnly(String ... properties) {
        if (this.m_ignored > 0) {
            throw new IllegalArgumentException("Either use igore or only, not both!");
        }
        for (String p : properties) {
            this.m_onlySet.add(p);
        }
    }

    protected void setProperties(Mode mode, String ... properties) {
        for (String p : properties) {
            Mode prev = this.m_modeMap.put(p, mode);
            if (null == prev) continue;
            throw new IllegalArgumentException("Property " + p + " was set to " + (Object)((Object)prev) + " earlier");
        }
    }

    protected <I> I cloneInstance(I source, StringBuilder sb) throws InstantiationException, IllegalAccessException, Exception {
        if (++this.m_copies > 100) {
            throw new IllegalStateException("Too many copies");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(source.getClass());
        Object copy = cmm.getActualClass().newInstance();
        this.copyProperties(copy, source, sb, cmm);
        return (I)copy;
    }

    protected <I> void copyProperties(I copy, I source, StringBuilder sb, ClassMetaModel cmm) throws Exception {
        for (PropertyMetaModel<?> pmm : cmm.getProperties()) {
            this.copyProperty(copy, this.m_source, pmm, sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <I, V> void copyProperty(I copy, I source, PropertyMetaModel<V> pmm, StringBuilder sb) throws Exception {
        if (pmm.getReadOnly() == YesNoType.YES) {
            return;
        }
        int len = sb.length();
        try {
            int len2 = len;
            if (len > 0) {
                sb.append('.');
                ++len2;
            }
            sb.append("*");
            String all = sb.toString();
            sb.setLength(len2);
            sb.append(pmm.getName());
            String prop = sb.toString();
            Mode mode = this.m_modeMap.get(prop);
            if (mode == null && (mode = this.m_modeMap.get(all)) == null) {
                mode = this.m_defaultMode;
            }
            if (mode == Mode.IGNORE) {
                return;
            }
            Object srcvalue = pmm.getValue(source);
            if (srcvalue == null) {
                pmm.setValue(copy, null);
                return;
            }
            if (List.class.isAssignableFrom(pmm.getActualType())) {
                this.copyListProperty(copy, source, pmm, sb, mode);
            } else if (this.isUncopyable(pmm) || mode == Mode.SHALLOW) {
                pmm.setValue(copy, srcvalue);
            } else {
                Object dstvalue = this.m_old2newmap.get(srcvalue);
                if (null != dstvalue) {
                    dstvalue = this.cloneInstance(srcvalue, sb);
                    this.m_old2newmap.put(srcvalue, dstvalue);
                }
                pmm.setValue(copy, dstvalue);
            }
        }
        finally {
            sb.setLength(len);
        }
    }

    private boolean isUncopyable(PropertyMetaModel<?> pmm) {
        Class<?> clz = pmm.getActualType();
        if (clz.isPrimitive()) {
            return true;
        }
        if (pmm.getRelationType() == PropertyRelationType.UP) {
            return false;
        }
        try {
            Constructor<?> cons = clz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(cons.getModifiers())) {
                return true;
            }
        }
        catch (Exception x) {
            return true;
        }
        for (Class<?> uc : this.UNCOPYABLE) {
            if (!uc.isAssignableFrom(clz)) continue;
            return true;
        }
        return false;
    }

    private <I, V> void copyListProperty(I copy, I source, PropertyMetaModel<V> pmm, StringBuilder sb, Mode mode) {
    }

    protected T getSource() {
        return this.m_source;
    }

    public static enum Mode {
        DEEP,
        SHALLOW,
        COPY,
        IGNORE,
        ONLY;

    }
}

