/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta;

import java.util.List;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.webapp.ProgrammerErrorException;

public class MetaUtils {
    public static final String NO_MINUS = "no-minus";
    public static final String NO_SEPARATOR = "no-separator";
    public static final String TEXT_AREA = "textarea";
    public static final String ROW = "row";
    public static final String COL = "col";

    public static int parseIntParam(String metadataLine, String paramName, int defaultValue) {
        String paramValue = MetaUtils.parseStringParam(metadataLine, paramName);
        if (paramValue == null || paramValue.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(paramValue);
        }
        catch (NumberFormatException e) {
            throw new ProgrammerErrorException("Invalid number in metadata string: " + metadataLine + ", parameter=" + paramName + ", value=" + paramValue);
        }
    }

    public static String parseStringParam(String metadataLine, String paramName) {
        String paramValue = null;
        String paramItem = paramName.toLowerCase() + '=';
        if (metadataLine.contains(paramItem)) {
            paramValue = metadataLine.indexOf(";", metadataLine.indexOf(paramItem)) > 0 ? metadataLine.substring(metadataLine.indexOf(paramItem) + paramItem.length(), metadataLine.indexOf(";", metadataLine.indexOf(paramItem))) : metadataLine.substring(metadataLine.indexOf(paramItem) + paramItem.length());
        }
        return paramValue;
    }

    public static PropertyMetaModel<?> findLastProperty(List<PropertyMetaModel<?>> pl) {
        if (pl == null || pl.size() == 0) {
            return null;
        }
        return pl.get(pl.size() - 1);
    }

    public static PropertyMetaModel<?> findLastProperty(SearchPropertyMetaModel spm) {
        return MetaUtils.findLastProperty(spm.getPropertyPath());
    }

    public static PropertyMetaModel<?> getLastProperty(List<PropertyMetaModel<?>> pl) {
        PropertyMetaModel<?> m = MetaUtils.findLastProperty(pl);
        if (m == null) {
            throw new IllegalStateException("No property in property list");
        }
        return m;
    }

    public static PropertyMetaModel<?> getLastProperty(SearchPropertyMetaModel spm) {
        PropertyMetaModel<?> m = MetaUtils.findLastProperty(spm);
        if (m == null) {
            throw new IllegalStateException("The search property " + spm.getPropertyName() + " is not found");
        }
        return m;
    }

    public static String findHintText(SearchPropertyMetaModel spm) {
        PropertyMetaModel<?> pmm;
        String hint = spm.getLookupHint();
        if (hint == null && (pmm = MetaUtils.findLastProperty(spm)) != null) {
            hint = pmm.getDefaultHint();
        }
        return hint;
    }
}

