/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;

public final class ObjectDelta {
    @Nonnull
    private final Map<String, Delta<?>> m_deltaMap;

    private ObjectDelta(@Nonnull Map<String, Delta<?>> deltaMap) {
        this.m_deltaMap = deltaMap;
    }

    @Nonnull
    public static <T> ObjectDelta compare(@Nonnull T a, @Nonnull T b, Object ... ignored) throws Exception {
        ClassMetaModel bcmm;
        ClassMetaModel acmm = MetaManager.findClassMeta(a.getClass());
        if (acmm != (bcmm = MetaManager.findClassMeta(b.getClass()))) {
            throw new IllegalStateException("Class " + a + " and class " + b + " are not the same class.");
        }
        Set<String> ignoreSet = ObjectDelta.getPropertyList(ignored);
        HashMap deltaMap = new HashMap();
        for (PropertyMetaModel<?> pmm : acmm.getProperties()) {
            if (ignoreSet.contains(pmm.getName()) || Collection.class.isAssignableFrom(pmm.getActualType()) || Map.class.isAssignableFrom(pmm.getActualType())) continue;
            ObjectDelta.compare(deltaMap, a, b, pmm);
        }
        return new ObjectDelta(deltaMap);
    }

    private static <T, V> void compare(@Nonnull Map<String, Delta<?>> deltaMap, @Nonnull T a, @Nonnull T b, @Nonnull PropertyMetaModel<V> pmm) throws Exception {
        Object bval;
        Object aval = pmm.getValue(a);
        if (MetaManager.areObjectsEqual(aval, bval = pmm.getValue(b))) {
            return;
        }
        deltaMap.put(pmm.getName(), new Delta<V>(pmm, aval, bval, pmm.getName()));
    }

    public int size() {
        return this.m_deltaMap.size();
    }

    @Nonnull
    public ObjectDelta remove(Object ... things) {
        HashMap deltaMap = new HashMap();
        for (String name : ObjectDelta.getPropertyList(things)) {
            Delta<?> delta = this.m_deltaMap.remove(name);
            if (delta == null) continue;
            deltaMap.put(name, delta);
        }
        return new ObjectDelta(deltaMap);
    }

    @Nonnull
    private static Set<String> getPropertyList(Object ... things) {
        HashSet<String> res = new HashSet<String>();
        for (Object v : things) {
            if (v instanceof String) {
                String s = (String)v;
                if (s.startsWith("-")) {
                    res.remove(s.substring(1));
                    continue;
                }
                res.add(s);
                continue;
            }
            if (v instanceof Class) {
                ClassMetaModel cmm = MetaManager.findClassMeta((Class)v);
                for (PropertyMetaModel<?> pmm : cmm.getProperties()) {
                    res.add(pmm.getName());
                }
                continue;
            }
            throw new IllegalArgumentException("Expecting either a String (property name) or a Class (as a set of properties)");
        }
        return res;
    }

    @Immutable
    public static class Delta<V> {
        @Nonnull
        private final PropertyMetaModel<V> m_pmm;
        @Nullable
        private final V m_oldValue;
        @Nullable
        private final V m_newValue;
        @Nonnull
        private final String m_name;

        public Delta(@Nonnull PropertyMetaModel<V> pmm, @Nullable V oldValue, @Nullable V newValue, @Nonnull String name) {
            this.m_pmm = pmm;
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
            this.m_name = name;
        }

        @Nonnull
        public PropertyMetaModel<V> getPmm() {
            return this.m_pmm;
        }

        @Nullable
        public V getOldValue() {
            return this.m_oldValue;
        }

        @Nullable
        public V getNewValue() {
            return this.m_newValue;
        }

        @Nonnull
        public String getName() {
            return this.m_name;
        }
    }
}

