/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.impl.DefaultPropertyMetaModel;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.ILabelStringRenderer;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsContext;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.QCriteria;

public class DefaultClassMetaModel
implements ClassMetaModel {
    private final Class<?> m_metaClass;
    private ICriteriaTableDef<?> m_metaTableDef;
    private String m_classNameOnly;
    @Nonnull
    private final BundleRef m_classBundle;
    private List<PropertyMetaModel<?>> m_rootProperties;
    @Nonnull
    private Map<String, PropertyMetaModel<?>> m_simplePropertyMap = Collections.EMPTY_MAP;
    @Nonnull
    private final Map<String, PropertyMetaModel<?>> m_dottedPropertyMap = new HashMap();
    private String m_componentTypeHint;
    private Class<? extends IComboDataSet<?>> m_comboDataSet;
    private boolean m_persistentClass;
    private String m_tableName;
    @Nullable
    private IQueryManipulator<?> m_queryManipulator;
    @Nullable
    private String m_comboSortProperty;
    private Class<? extends ILabelStringRenderer<?>> m_comboLabelRenderer;
    private Class<? extends INodeContentRenderer<?>> m_comboNodeRenderer;
    @Nonnull
    private List<DisplayPropertyMetaModel> m_comboDisplayProperties = Collections.EMPTY_LIST;
    @Nonnull
    private List<DisplayPropertyMetaModel> m_tableDisplayProperties = Collections.EMPTY_LIST;
    @Nonnull
    private List<SearchPropertyMetaModel> m_searchProperties = Collections.EMPTY_LIST;
    @Nonnull
    private List<SearchPropertyMetaModel> m_keyWordSearchProperties = Collections.EMPTY_LIST;
    private Class<? extends INodeContentRenderer<?>> m_lookupFieldRenderer;
    @Nonnull
    private List<DisplayPropertyMetaModel> m_lookupFieldDisplayProperties = Collections.EMPTY_LIST;
    private String m_defaultSortProperty;
    @Nullable
    private SortableType m_defaultSortDirection;
    private PropertyMetaModel<?> m_primaryKey;
    private Object[] m_domainValues;

    public DefaultClassMetaModel(Class<?> metaClass) {
        this.m_metaClass = metaClass;
        this.m_classNameOnly = metaClass.getName().substring(metaClass.getName().lastIndexOf(46) + 1);
        this.m_classBundle = BundleRef.create(metaClass, (String)this.m_classNameOnly);
    }

    @GuardedBy(value="MetaManager.class")
    void setClassProperties(List<PropertyMetaModel<?>> reslist) {
        this.m_rootProperties = Collections.unmodifiableList(reslist);
        HashMap propMap = new HashMap();
        for (PropertyMetaModel<?> pmm : reslist) {
            propMap.put(pmm.getName(), pmm);
        }
        this.m_simplePropertyMap = Collections.unmodifiableMap(propMap);
    }

    @Override
    @Nonnull
    public BundleRef getClassBundle() {
        return this.m_classBundle;
    }

    @Nonnull
    String getPropertyLabel(DefaultPropertyMetaModel<?> p, Locale loc) {
        String s = this.getClassBundle().findMessage(loc, p.getName() + ".label");
        return s == null ? p.getName() : s;
    }

    @Nullable
    String getPropertyHint(DefaultPropertyMetaModel<?> p, Locale loc) {
        String v = this.getClassBundle().findMessage(loc, p.getName() + ".hint");
        if (v == null) {
            v = this.getClassBundle().findMessage(loc, p.getName() + ".help");
        }
        return v;
    }

    @Override
    @Nullable
    public String getUserEntityName() {
        return this.getClassBundle().findMessage(NlsContext.getLocale(), "entity.name");
    }

    @Override
    @Nullable
    public String getUserEntityNamePlural() {
        return this.getClassBundle().findMessage(NlsContext.getLocale(), "entity.pluralname");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PropertyMetaModel<?> findProperty(@Nonnull String name) {
        PropertyMetaModel<?> pmm;
        if (name.indexOf(46) == -1) {
            return this.findSimpleProperty(name);
        }
        DefaultClassMetaModel defaultClassMetaModel = this;
        synchronized (defaultClassMetaModel) {
            pmm = this.m_dottedPropertyMap.get(name);
            if (pmm != null) {
                return pmm;
            }
        }
        pmm = MetaManager.internalCalculateDottedPath(this, name);
        if (pmm != null) {
            defaultClassMetaModel = this;
            synchronized (defaultClassMetaModel) {
                PropertyMetaModel<?> racePmm = this.m_dottedPropertyMap.get(name);
                if (null != racePmm) {
                    return racePmm;
                }
                this.m_dottedPropertyMap.put(name, pmm);
            }
        }
        return pmm;
    }

    @Override
    @Nonnull
    public PropertyMetaModel<?> getProperty(@Nonnull String name) {
        PropertyMetaModel<?> pmm = this.findProperty(name);
        if (null == pmm) {
            throw new IllegalStateException("The property '" + name + "' is not known in the meta model for " + this);
        }
        return pmm;
    }

    @Override
    @Nullable
    public PropertyMetaModel<?> findSimpleProperty(@Nonnull String name) {
        return this.m_simplePropertyMap.get(name);
    }

    @Override
    @Nonnull
    public List<PropertyMetaModel<?>> getProperties() {
        return this.m_rootProperties;
    }

    @Override
    @Nullable
    public Class<? extends IComboDataSet<?>> getComboDataSet() {
        return this.m_comboDataSet;
    }

    public void setComboDataSet(@Nullable Class<? extends IComboDataSet<?>> comboDataSet) {
        this.m_comboDataSet = comboDataSet;
    }

    @Override
    public Class<? extends ILabelStringRenderer<?>> getComboLabelRenderer() {
        return this.m_comboLabelRenderer;
    }

    public void setComboLabelRenderer(Class<? extends ILabelStringRenderer<?>> comboLabelRenderer) {
        this.m_comboLabelRenderer = comboLabelRenderer;
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getComboDisplayProperties() {
        return this.m_comboDisplayProperties;
    }

    public void setComboDisplayProperties(List<DisplayPropertyMetaModel> displayProperties) {
        this.m_comboDisplayProperties = displayProperties;
    }

    @Override
    public Class<? extends INodeContentRenderer<?>> getComboNodeRenderer() {
        return this.m_comboNodeRenderer;
    }

    public void setComboNodeRenderer(Class<? extends INodeContentRenderer<?>> comboNodeRenderer) {
        this.m_comboNodeRenderer = comboNodeRenderer;
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getSearchProperties() {
        return this.m_searchProperties;
    }

    public void setSearchProperties(@Nonnull List<SearchPropertyMetaModel> searchProperties) {
        this.m_searchProperties = searchProperties.size() == 0 ? Collections.EMPTY_LIST : searchProperties;
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getKeyWordSearchProperties() {
        return this.m_keyWordSearchProperties;
    }

    public void setKeyWordSearchProperties(@Nonnull List<SearchPropertyMetaModel> keyWordSearchProperties) {
        this.m_keyWordSearchProperties = keyWordSearchProperties.size() == 0 ? Collections.EMPTY_LIST : keyWordSearchProperties;
    }

    @Override
    @Nonnull
    public Class<?> getActualClass() {
        return this.m_metaClass;
    }

    @Override
    @Nonnull
    public synchronized List<DisplayPropertyMetaModel> getTableDisplayProperties() {
        if (this.m_tableDisplayProperties == null || this.m_tableDisplayProperties.size() == 0) {
            this.m_tableDisplayProperties = MetaManager.calculateObjectProperties(this);
        }
        return this.m_tableDisplayProperties;
    }

    public synchronized void setTableDisplayProperties(List<DisplayPropertyMetaModel> tableDisplayProperties) {
        this.m_tableDisplayProperties = tableDisplayProperties;
    }

    @Override
    public boolean isPersistentClass() {
        return this.m_persistentClass;
    }

    public void setPersistentClass(boolean persistentClass) {
        this.m_persistentClass = persistentClass;
    }

    @Override
    public String getDefaultSortProperty() {
        return this.m_defaultSortProperty;
    }

    public void setDefaultSortProperty(String defaultSortProperty) {
        this.m_defaultSortProperty = defaultSortProperty;
    }

    @Override
    @Nullable
    public SortableType getDefaultSortDirection() {
        return this.m_defaultSortDirection;
    }

    public void setDefaultSortDirection(@Nullable SortableType defaultSortDirection) {
        this.m_defaultSortDirection = defaultSortDirection;
    }

    @Override
    public Class<? extends INodeContentRenderer<?>> getLookupSelectedRenderer() {
        return this.m_lookupFieldRenderer;
    }

    public void setLookupSelectedRenderer(Class<? extends INodeContentRenderer<?>> lookupFieldRenderer) {
        this.m_lookupFieldRenderer = lookupFieldRenderer;
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getLookupSelectedProperties() {
        return this.m_lookupFieldDisplayProperties;
    }

    public void setLookupSelectedProperties(List<DisplayPropertyMetaModel> lookupFieldDisplayProperties) {
        this.m_lookupFieldDisplayProperties = lookupFieldDisplayProperties;
    }

    @Override
    public String getComponentTypeHint() {
        return this.m_componentTypeHint;
    }

    public void setComponentTypeHint(String componentTypeHint) {
        this.m_componentTypeHint = componentTypeHint;
    }

    @Override
    public PropertyMetaModel<?> getPrimaryKey() {
        return this.m_primaryKey;
    }

    public void setPrimaryKey(PropertyMetaModel<?> primaryKey) {
        this.m_primaryKey = primaryKey;
    }

    @Override
    public String getTableName() {
        return this.m_tableName;
    }

    public void setTableName(String tableName) {
        this.m_tableName = tableName;
    }

    public String toString() {
        return "ClassMetaModel[" + this.m_metaClass.getName() + "]";
    }

    @Override
    public Object[] getDomainValues() {
        return this.m_domainValues;
    }

    public void setDomainValues(Object[] domainValues) {
        this.m_domainValues = domainValues;
    }

    public String getClassNameOnly() {
        return this.m_classNameOnly;
    }

    @Override
    @Nullable
    public String getDomainLabel(Locale loc, Object value) {
        if (value instanceof Enum) {
            try {
                String s = this.getClassBundle().findMessage(loc, ((Enum)value).name() + ".label");
                return s;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof Boolean) {
            return Msgs.BUNDLE.getString((Boolean)value != false ? "ui.boolean.true" : "ui.boolean.false");
        }
        throw new IllegalStateException("Invalid call for non-domain object.");
    }

    @Nullable
    public ICriteriaTableDef<?> getMetaTableDef() {
        return this.m_metaTableDef;
    }

    public void setMetaTableDef(@Nullable ICriteriaTableDef<?> metaTableDef) {
        this.m_metaTableDef = metaTableDef;
    }

    @Override
    @Nonnull
    public QCriteria<?> createCriteria() throws Exception {
        ICriteriaTableDef<?> tdef = this.getMetaTableDef();
        if (tdef != null) {
            return QCriteria.create(tdef);
        }
        return QCriteria.create(this.getActualClass());
    }

    @Override
    public IQueryManipulator<?> getQueryManipulator() {
        return this.m_queryManipulator;
    }

    public void setQueryManipulator(IQueryManipulator<?> queryManipulator) {
        this.m_queryManipulator = queryManipulator;
    }

    @Override
    public String getComboSortProperty() {
        return this.m_comboSortProperty;
    }

    public void setComboSortProperty(String comboSortProperty) {
        this.m_comboSortProperty = comboSortProperty;
    }
}

