/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.IClassMetaModelFactory;
import to.etc.domui.component.meta.MetaCombo;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.MetaObject;
import to.etc.domui.component.meta.MetaProperty;
import to.etc.domui.component.meta.MetaSearch;
import to.etc.domui.component.meta.MetaSearchItem;
import to.etc.domui.component.meta.MetaValueValidator;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyMetaValidator;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyType;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.TemporalPresentationType;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.component.meta.impl.DefaultClassMetaModel;
import to.etc.domui.component.meta.impl.DefaultJavaClassInfo;
import to.etc.domui.component.meta.impl.DefaultPropertyMetaModel;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.MetaModelException;
import to.etc.domui.component.meta.impl.MetaPropertyValidatorImpl;
import to.etc.domui.component.meta.impl.SearchPropertyMetaModelImpl;
import to.etc.domui.component.meta.impl.UndefinedComboDataSet;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.DummyConverter;
import to.etc.domui.converter.IValueValidator;
import to.etc.domui.trouble.Trouble;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.domui.util.UndefinedLabelStringRenderer;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;

public class DefaultJavaClassMetaModelFactory
implements IClassMetaModelFactory {
    @Override
    public int accepts(@Nonnull Object theThingy) {
        if (!(theThingy instanceof Class)) {
            return -1;
        }
        return 1;
    }

    @Override
    @Nonnull
    public ClassMetaModel createModel(@Nonnull List<Runnable> init, @Nonnull Object theThingy) {
        Class clz = (Class)theThingy;
        final DefaultJavaClassInfo colli = new DefaultJavaClassInfo(new DefaultClassMetaModel(clz), init);
        List pilist = ClassUtil.getProperties(colli.getTypeClass());
        this.createPropertyMetas(colli, pilist);
        this.decodeProperties(colli);
        this.decodeDomainValues(colli);
        this.decodeClassAnnotations(colli);
        colli.later(new Runnable(){

            @Override
            public void run() {
                Collections.sort(colli.getSearchList(), SearchPropertyMetaModel.BY_ORDER);
                Collections.sort(colli.getKeySearchList(), SearchPropertyMetaModel.BY_ORDER);
                colli.getModel().setSearchProperties(colli.getSearchList());
                colli.getModel().setKeyWordSearchProperties(colli.getKeySearchList());
            }
        });
        return colli.getModel();
    }

    private void createPropertyMetas(@Nonnull DefaultJavaClassInfo colli, @Nonnull List<PropertyInfo> pilist) {
        ArrayList reslist = new ArrayList(pilist.size());
        for (PropertyInfo pd : pilist) {
            Method rm;
            if (pd.getName().equals("class") || (rm = pd.getGetter()).getParameterTypes().length != 0) continue;
            DefaultPropertyMetaModel pm = new DefaultPropertyMetaModel(colli.getModel(), pd);
            reslist.add(pm);
            colli.getMap().put(pd, pm);
        }
        colli.getModel().setClassProperties(reslist);
    }

    protected void decodeProperties(@Nonnull DefaultJavaClassInfo colli) {
        for (Map.Entry<PropertyInfo, DefaultPropertyMetaModel<?>> e : colli.getMap().entrySet()) {
            this.updatePropertyInfo(colli, e.getValue(), e.getKey());
        }
    }

    protected void updatePropertyInfo(@Nonnull DefaultJavaClassInfo colli, @Nonnull DefaultPropertyMetaModel<?> pm, @Nonnull PropertyInfo pd) {
        this.initPropertyModel(colli, pd, pm);
        if (pm.isPrimaryKey()) {
            colli.getModel().setPrimaryKey(pm);
        }
    }

    protected void initPropertyModel(@Nonnull DefaultJavaClassInfo colli, @Nonnull PropertyInfo pd, @Nonnull DefaultPropertyMetaModel<?> pmm) {
        Annotation[] annar;
        for (Annotation an : annar = pd.getGetter().getAnnotations()) {
            String ana = an.annotationType().getName();
            this.decodePropertyAnnotationByName(colli, pmm, an, ana);
            this.decodePropertyAnnotation(colli, pmm, an);
        }
    }

    protected <T> void decodePropertyAnnotation(@Nonnull DefaultJavaClassInfo colli, final @Nonnull DefaultPropertyMetaModel<T> pmm, Annotation an) {
        final DefaultClassMetaModel cmm = colli.getModel();
        if (an instanceof MetaProperty) {
            MetaPropertyValidatorImpl vi;
            MetaProperty mp = (MetaProperty)an;
            if (mp.defaultSortable() != SortableType.UNKNOWN) {
                pmm.setSortable(mp.defaultSortable());
            }
            if (mp.length() >= 0) {
                pmm.setLength(mp.length());
            }
            if (mp.displaySize() >= 0) {
                pmm.setDisplayLength(mp.displaySize());
            }
            if (mp.noWrap() != YesNoType.UNKNOWN) {
                pmm.setNowrap(mp.noWrap());
            }
            if (mp.required() != YesNoType.UNKNOWN) {
                pmm.setRequired(mp.required() == YesNoType.YES);
            }
            if (mp.converterClass() != DummyConverter.class) {
                pmm.setConverter(ConverterRegistry.getConverterInstance(mp.converterClass()));
            }
            if (mp.temporal() != TemporalPresentationType.UNKNOWN && pmm.getTemporal() == TemporalPresentationType.UNKNOWN) {
                pmm.setTemporal(mp.temporal());
            }
            if (mp.numericPresentation() != NumericPresentation.UNKNOWN) {
                pmm.setNumericPresentation(mp.numericPresentation());
            }
            if (pmm.getReadOnly() != YesNoType.YES) {
                pmm.setReadOnly(mp.readOnly());
            }
            if (mp.componentTypeHint().length() != 0) {
                pmm.setComponentTypeHint(mp.componentTypeHint());
            }
            ArrayList<MetaPropertyValidatorImpl> list = new ArrayList<MetaPropertyValidatorImpl>();
            for (Class<? extends IValueValidator<?>> vv : mp.validator()) {
                vi = new MetaPropertyValidatorImpl(vv);
                list.add(vi);
            }
            for (MetaValueValidator mvv : mp.parameterizedValidator()) {
                vi = new MetaPropertyValidatorImpl(mvv.validator(), mvv.parameters());
                list.add(vi);
            }
            pmm.setValidators(list.toArray(new PropertyMetaValidator[list.size()]));
            if (mp.regexpValidation().length() > 0) {
                try {
                    Pattern.compile(mp.regexpValidation());
                }
                catch (Exception x) {
                    throw new MetaModelException(Msgs.BUNDLE, "mm.bad.re", mp.regexpValidation(), this.toString());
                }
                pmm.setRegexpValidator(mp.regexpValidation());
                if (mp.regexpUserString().length() > 0) {
                    pmm.setRegexpUserString(mp.regexpUserString());
                }
            }
        } else if (an instanceof MetaCombo) {
            final MetaCombo c = (MetaCombo)an;
            if (c.dataSet() != UndefinedComboDataSet.class) {
                pmm.setRelationType(PropertyRelationType.UP);
                pmm.setComboDataSet(c.dataSet());
            }
            if (c.labelRenderer() != UndefinedLabelStringRenderer.class) {
                pmm.setRelationType(PropertyRelationType.UP);
                pmm.setComboLabelRenderer(c.labelRenderer());
            }
            if (c.nodeRenderer() != UndefinedLabelStringRenderer.class) {
                pmm.setRelationType(PropertyRelationType.UP);
                pmm.setComboNodeRenderer(c.nodeRenderer());
            }
            pmm.setComponentTypeHint("comboLookup");
            if (c.properties() != null && c.properties().length > 0) {
                pmm.setRelationType(PropertyRelationType.UP);
                colli.later(new Runnable(){

                    @Override
                    public void run() {
                        pmm.setComboDisplayProperties(DisplayPropertyMetaModel.decode(pmm.getValueModel(), c.properties()));
                    }
                });
            }
        } else if (an instanceof MetaSearch) {
            MetaSearch sp = (MetaSearch)an;
            ArrayList ppl = new ArrayList(1);
            ppl.add(pmm);
            SearchPropertyMetaModelImpl mm = new SearchPropertyMetaModelImpl(colli.getModel(), ppl);
            mm.setIgnoreCase(sp.ignoreCase());
            mm.setOrder(sp.order());
            mm.setMinLength(sp.minLength());
            mm.setPropertyName(pmm.getName());
            if (sp.searchType() == SearchPropertyType.SEARCH_FIELD || sp.searchType() == SearchPropertyType.BOTH) {
                colli.getSearchList().add(mm);
            }
            if (sp.searchType() == SearchPropertyType.KEYWORD || sp.searchType() == SearchPropertyType.BOTH) {
                colli.getKeySearchList().add(mm);
            }
        } else if (an instanceof MetaObject) {
            final MetaObject o = (MetaObject)an;
            if (o.selectedRenderer() != UndefinedLabelStringRenderer.class) {
                pmm.setLookupSelectedRenderer(o.selectedRenderer());
            }
            colli.later(new Runnable(){

                @Override
                public void run() {
                    if (o.selectedProperties().length != 0) {
                        pmm.setLookupSelectedProperties(DisplayPropertyMetaModel.decode((ClassMetaModel)cmm, o.selectedProperties()));
                    }
                    if (o.defaultColumns().length > 0) {
                        pmm.setLookupTableProperties(DisplayPropertyMetaModel.decode((ClassMetaModel)cmm, o.defaultColumns()));
                    }
                }
            });
            if (o.defaultSortColumn() != "$*$") {
                // empty if block
            }
            if (o.defaultSortOrder() != SortableType.UNKNOWN) {
                // empty if block
            }
            if (o.searchProperties().length > 0) {
                int index = 0;
                ArrayList<SearchPropertyMetaModel> propsearchlist = new ArrayList<SearchPropertyMetaModel>();
                ArrayList<SearchPropertyMetaModel> propkeysearchlist = new ArrayList<SearchPropertyMetaModel>();
                for (MetaSearchItem msi : o.searchProperties()) {
                    List<PropertyMetaModel<?>> ppl = MetaManager.parsePropertyPath(colli.getModel(), msi.name());
                    SearchPropertyMetaModelImpl mm = new SearchPropertyMetaModelImpl(cmm, ppl);
                    mm.setIgnoreCase(msi.ignoreCase());
                    mm.setOrder(msi.order() == -1 ? ++index : msi.order());
                    mm.setMinLength(msi.minLength());
                    mm.setPropertyName(msi.name().length() == 0 ? null : msi.name());
                    mm.setLookupLabelKey(msi.lookupLabelKey().length() == 0 ? null : msi.lookupLabelKey());
                    mm.setLookupHintKey(msi.lookupHintKey().length() == 0 ? null : msi.lookupHintKey());
                    if (msi.searchType() == SearchPropertyType.SEARCH_FIELD || msi.searchType() == SearchPropertyType.BOTH) {
                        propsearchlist.add(mm);
                    }
                    if (msi.searchType() != SearchPropertyType.KEYWORD && msi.searchType() != SearchPropertyType.BOTH) continue;
                    propkeysearchlist.add(mm);
                }
                pmm.setLookupFieldKeySearchProperties(propkeysearchlist);
                pmm.setLookupFieldSearchProperties(propsearchlist);
            }
        }
    }

    protected void decodePropertyAnnotationByName(@Nonnull DefaultJavaClassInfo colli, @Nonnull DefaultPropertyMetaModel<?> pmm, @Nonnull Annotation an, @Nonnull String name) {
        block25: {
            DefaultClassMetaModel cmm = colli.getModel();
            if ("javax.persistence.Column".equals(name)) {
                this.decodeJpaColumn(pmm, an);
            } else if ("javax.persistence.JoinColumn".equals(name)) {
                this.decodeJpaJoinColumn(pmm, an);
            } else if ("javax.persistence.Id".equals(name)) {
                pmm.setPrimaryKey(true);
                cmm.setPersistentClass(true);
            } else if ("javax.persistence.ManyToOne".equals(name) || "javax.persistence.OneToOne".equals(name)) {
                pmm.setRelationType(PropertyRelationType.UP);
                try {
                    Boolean op = (Boolean)DomUtil.getClassValue(an, "optional");
                    pmm.setRequired(op == false);
                }
                catch (Exception x) {
                    Trouble.wrapException(x);
                }
            } else if ("javax.persistence.Temporal".equals(name)) {
                try {
                    Object val = DomUtil.getClassValue(an, "value");
                    if (val == null) break block25;
                    String s = val.toString();
                    if ("DATE".equals(s)) {
                        pmm.setTemporal(TemporalPresentationType.DATE);
                    } else if ("TIME".equals(s)) {
                        pmm.setTemporal(TemporalPresentationType.TIME);
                    } else if ("TIMESTAMP".equals(s)) {
                        pmm.setTemporal(TemporalPresentationType.DATETIME);
                    }
                }
                catch (Exception x) {
                    Trouble.wrapException(x);
                }
            } else if ("javax.persistence.Transient".equals(name) || "org.hibernate.annotations.Formula".equals(name)) {
                pmm.setTransient(true);
            } else if ("javax.persistence.OneToMany".equals(name)) {
                if (!Collection.class.isAssignableFrom(pmm.getActualType())) {
                    throw new IllegalStateException("Invalid property type for DOWN relation of property " + this + ": only List<T> is allowed");
                }
                pmm.setRelationType(PropertyRelationType.DOWN);
            } else if ("to.etc.webapp.qsql.QJdbcId".equals(name)) {
                pmm.setPrimaryKey(true);
                cmm.setPersistentClass(true);
            }
        }
    }

    protected void decodeJpaColumn(@Nonnull DefaultPropertyMetaModel<?> pmm, @Nonnull Annotation an) {
        try {
            Boolean bv;
            Integer iv = (Integer)DomUtil.getClassValue(an, "length");
            pmm.setLength(iv);
            if (pmm.getLength() == 255 && pmm.getActualType() != String.class) {
                pmm.setLength(-1);
            }
            pmm.setRequired((bv = (Boolean)DomUtil.getClassValue(an, "nullable")) == false);
            iv = (Integer)DomUtil.getClassValue(an, "precision");
            pmm.setPrecision(iv);
            iv = (Integer)DomUtil.getClassValue(an, "scale");
            pmm.setScale(iv);
            String name = (String)DomUtil.getClassValue(an, "name");
            if (null == name) {
                name = pmm.getName();
            }
            pmm.setColumnNames(new String[]{name});
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new WrappedException((Throwable)x);
        }
    }

    protected void decodeJpaJoinColumn(@Nonnull DefaultPropertyMetaModel<?> pmm, @Nonnull Annotation an) {
        try {
            String name = (String)DomUtil.getClassValue(an, "name");
            if (null == name) {
                name = pmm.getName();
            }
            pmm.setColumnNames(new String[]{name});
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new WrappedException((Throwable)x);
        }
    }

    protected void decodeDomainValues(@Nonnull DefaultJavaClassInfo colli) {
        if (colli.getTypeClass() == Boolean.class) {
            colli.getModel().setDomainValues(new Object[]{Boolean.FALSE, Boolean.TRUE});
        } else if (Enum.class.isAssignableFrom(colli.getTypeClass())) {
            Class<?> ecl = colli.getTypeClass();
            colli.getModel().setDomainValues(ecl.getEnumConstants());
        }
    }

    protected void decodeClassAnnotations(@Nonnull DefaultJavaClassInfo colli) {
        Annotation[] annar;
        for (Annotation an : annar = colli.getTypeClass().getAnnotations()) {
            String ana = an.annotationType().getName();
            this.decodeClassAnnotationByName(colli, an, ana);
            this.decodeClassAnnotation(colli, an);
        }
        Class<?> parentClass = colli.getTypeClass();
        while ((parentClass = parentClass.getSuperclass()) != Object.class && parentClass != null) {
            for (Annotation an : annar = parentClass.getAnnotations()) {
                String ana = an.annotationType().getName();
                this.decodeParentClassAnnotationByName(colli, an, ana);
            }
        }
    }

    private void decodeParentClassAnnotationByName(@Nonnull DefaultJavaClassInfo colli, @Nonnull Annotation an, @Nonnull String name) {
        if ("javax.persistence.Table".equals(name)) {
            this.decodeTableAnnotation(colli, an);
        }
    }

    protected void decodeClassAnnotationByName(@Nonnull DefaultJavaClassInfo colli, @Nonnull Annotation an, @Nonnull String name) {
        if ("javax.persistence.Table".equals(name)) {
            this.decodeTableAnnotation(colli, an);
        } else if ("to.etc.webapp.qsql.QJdbcTable".equals(name)) {
            colli.getModel().setPersistentClass(true);
        }
    }

    private void decodeTableAnnotation(@Nonnull DefaultJavaClassInfo colli, @Nonnull Annotation an) {
        if (colli.getModel().getTableName() != null) {
            return;
        }
        try {
            String tablename = (String)DomUtil.getClassValue(an, "name");
            String tableschema = (String)DomUtil.getClassValue(an, "schema");
            if (tablename != null) {
                if (!StringTool.isBlank((String)tableschema)) {
                    tablename = tableschema + "." + tablename;
                }
                colli.getModel().setTableName(tablename);
            }
        }
        catch (Exception x) {
            Trouble.wrapException(x);
        }
    }

    protected void decodeClassAnnotation(@Nonnull DefaultJavaClassInfo colli, @Nonnull Annotation an) {
        final DefaultClassMetaModel cmm = colli.getModel();
        if (an instanceof MetaCombo) {
            final MetaCombo c = (MetaCombo)an;
            if (c.dataSet() != UndefinedComboDataSet.class) {
                cmm.setComboDataSet(c.dataSet());
            }
            if (c.labelRenderer() != UndefinedLabelStringRenderer.class) {
                cmm.setComboLabelRenderer(c.labelRenderer());
            }
            if (c.nodeRenderer() != UndefinedLabelStringRenderer.class) {
                cmm.setComboNodeRenderer(c.nodeRenderer());
            }
            if (c.properties() != null && c.properties().length > 0) {
                colli.later(new Runnable(){

                    @Override
                    public void run() {
                        cmm.setComboDisplayProperties(DisplayPropertyMetaModel.decode((ClassMetaModel)cmm, c.properties()));
                    }
                });
            }
            if (c.preferred()) {
                cmm.setComponentTypeHint("comboLookup");
            }
        } else if (an instanceof MetaObject) {
            final MetaObject mo = (MetaObject)an;
            if (mo.defaultColumns().length > 0) {
                colli.later(new Runnable(){

                    @Override
                    public void run() {
                        cmm.setTableDisplayProperties(DisplayPropertyMetaModel.decode((ClassMetaModel)cmm, mo.defaultColumns()));
                    }
                });
            }
            if (!mo.defaultSortColumn().equals("$*$")) {
                cmm.setDefaultSortProperty(mo.defaultSortColumn());
            }
            cmm.setDefaultSortDirection(mo.defaultSortOrder());
            if (mo.selectedRenderer() != UndefinedLabelStringRenderer.class) {
                cmm.setLookupSelectedRenderer(mo.selectedRenderer());
            }
            if (mo.selectedProperties().length != 0) {
                colli.later(new Runnable(){

                    @Override
                    public void run() {
                        cmm.setLookupSelectedProperties(DisplayPropertyMetaModel.decode((ClassMetaModel)cmm, mo.selectedProperties()));
                    }
                });
            }
            int index = 0;
            for (MetaSearchItem msi : mo.searchProperties()) {
                List<PropertyMetaModel<?>> pl = MetaManager.parsePropertyPath(colli.getModel(), msi.name());
                SearchPropertyMetaModelImpl mm = new SearchPropertyMetaModelImpl(cmm, pl);
                mm.setIgnoreCase(msi.ignoreCase());
                mm.setOrder(msi.order() == -1 ? ++index : msi.order());
                mm.setMinLength(msi.minLength());
                mm.setPropertyName(msi.name());
                mm.setLookupLabelKey(msi.lookupLabelKey().length() == 0 ? null : msi.lookupLabelKey());
                mm.setLookupHintKey(msi.lookupHintKey().length() == 0 ? null : msi.lookupHintKey());
                if (msi.searchType() == SearchPropertyType.SEARCH_FIELD || msi.searchType() == SearchPropertyType.BOTH) {
                    colli.getSearchList().add(mm);
                }
                if (msi.searchType() != SearchPropertyType.KEYWORD && msi.searchType() != SearchPropertyType.BOTH) continue;
                colli.getKeySearchList().add(mm);
            }
        }
    }
}

