/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.component.meta.impl.BasicPropertyMetaModel;
import to.etc.domui.component.meta.impl.DefaultClassMetaModel;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.PropertyValueInvalidException;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.ILabelStringRenderer;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.util.PropertyInfo;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsContext;

public class DefaultPropertyMetaModel<T>
extends BasicPropertyMetaModel<T>
implements PropertyMetaModel<T> {
    @Nonnull
    private final DefaultClassMetaModel m_classModel;
    private final PropertyInfo m_descriptor;
    private int m_length = -1;
    private boolean m_primaryKey;
    @Nonnull
    private PropertyRelationType m_relationType = PropertyRelationType.NONE;
    private String m_componentTypeHint;
    private Class<? extends IComboDataSet<?>> m_comboDataSet;
    private Class<? extends ILabelStringRenderer<?>> m_comboLabelRenderer;
    private Class<? extends INodeContentRenderer<?>> m_comboNodeRenderer;
    @Nonnull
    private List<DisplayPropertyMetaModel> m_comboDisplayProperties = Collections.EMPTY_LIST;
    private IQueryManipulator<T> m_queryManipulator;
    private Class<? extends INodeContentRenderer<?>> m_lookupFieldRenderer;
    @Nonnull
    private List<DisplayPropertyMetaModel> m_lookupFieldDisplayProperties = Collections.EMPTY_LIST;
    @Nonnull
    private List<DisplayPropertyMetaModel> m_lookupFieldTableProperties = Collections.EMPTY_LIST;
    @Nonnull
    private List<SearchPropertyMetaModel> m_lookupFieldSearchProperties = Collections.EMPTY_LIST;
    @Nonnull
    private List<SearchPropertyMetaModel> m_lookupFieldKeySearchProperties = Collections.EMPTY_LIST;
    private static final Object[] BOOLS = new Object[]{Boolean.FALSE, Boolean.TRUE};

    public DefaultPropertyMetaModel(@Nonnull DefaultClassMetaModel classModel, PropertyInfo descriptor) {
        if (classModel == null) {
            throw new IllegalStateException("Cannot be null dude");
        }
        this.m_classModel = classModel;
        this.m_descriptor = descriptor;
        if (descriptor.getSetter() == null) {
            this.setReadOnly(YesNoType.YES);
        }
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_descriptor.getName();
    }

    @Override
    @Nonnull
    public Class<T> getActualType() {
        return this.m_descriptor.getActualType();
    }

    @Override
    public ClassMetaModel getValueModel() {
        return MetaManager.findClassMeta(this.getActualType());
    }

    @Override
    public Type getGenericActualType() {
        Method m = this.m_descriptor.getGetter();
        return m.getGenericReturnType();
    }

    @Override
    public void setValue(Object target, T value) throws Exception {
        if (target == null) {
            throw new IllegalStateException("The 'target' object is null");
        }
        Method setter = this.m_descriptor.getSetter();
        if (setter == null) {
            throw new IllegalAccessException("The property " + this + " is read-only.");
        }
        try {
            setter.setAccessible(true);
            setter.invoke(target, value);
        }
        catch (InvocationTargetException itx) {
            Throwable c = itx.getCause();
            if (c instanceof Exception) {
                throw (Exception)c;
            }
            if (c instanceof Error) {
                throw (Error)c;
            }
            throw itx;
        }
        catch (IllegalArgumentException x) {
            throw new PropertyValueInvalidException(value, target, this);
        }
        catch (Exception x) {
            throw x;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.m_descriptor.getSetter() == null || this.getReadOnly() == YesNoType.YES;
    }

    @Override
    public T getValue(Object in) throws Exception {
        if (in == null) {
            throw new IllegalStateException("The 'input' object is null (getter method=" + this.m_descriptor.getGetter() + ")");
        }
        try {
            this.m_descriptor.getGetter().setAccessible(true);
            return (T)this.m_descriptor.getGetter().invoke(in, new Object[0]);
        }
        catch (InvocationTargetException itx) {
            Throwable c = itx.getCause();
            if (c instanceof Exception) {
                throw (Exception)c;
            }
            if (c instanceof Error) {
                throw (Error)c;
            }
            throw itx;
        }
        catch (Exception x) {
            try {
                System.err.println(x + " in calling " + this.m_descriptor.getGetter() + " with input object " + in);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw x;
        }
    }

    @Override
    @Nonnull
    public String getDefaultLabel() {
        return this.m_classModel.getPropertyLabel(this, NlsContext.getLocale());
    }

    @Override
    public String getDefaultHint() {
        return this.m_classModel.getPropertyHint(this, NlsContext.getLocale());
    }

    @Override
    public Object[] getDomainValues() {
        if (this.getActualType() == Boolean.TYPE || this.getActualType() == Boolean.class) {
            return BOOLS;
        }
        if (Enum.class.isAssignableFrom(this.getActualType())) {
            Class<T> ec = this.getActualType();
            return ec.getEnumConstants();
        }
        return null;
    }

    @Override
    public String getDomainValueLabel(Locale loc, Object val) {
        BundleRef b = this.m_classModel.getClassBundle();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(".");
        if (val == Boolean.TRUE) {
            sb.append("true");
        } else if (val == Boolean.FALSE) {
            sb.append("false");
        } else if (val instanceof Enum) {
            sb.append(((Enum)val).name());
        } else if (val instanceof Boolean) {
            sb.append((Boolean)val != false ? "true" : "false");
        } else {
            throw new IllegalStateException("Property value " + val + " for property " + this + " is not an enumerable or boolean domain (class=" + val.getClass() + ")");
        }
        sb.append(".label");
        return b.findMessage(loc, sb.toString());
    }

    @Override
    public int getLength() {
        return this.m_length;
    }

    public void setLength(int length) {
        this.m_length = length;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.m_primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.m_primaryKey = primaryKey;
    }

    @Override
    public Class<? extends IComboDataSet<?>> getComboDataSet() {
        return this.m_comboDataSet;
    }

    public void setComboDataSet(Class<? extends IComboDataSet<?>> comboDataSet) {
        this.m_comboDataSet = comboDataSet;
    }

    @Override
    public Class<? extends ILabelStringRenderer<?>> getComboLabelRenderer() {
        return this.m_comboLabelRenderer;
    }

    public void setComboLabelRenderer(Class<? extends ILabelStringRenderer<?>> comboLabelRenderer) {
        this.m_comboLabelRenderer = comboLabelRenderer;
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getComboDisplayProperties() {
        return this.m_comboDisplayProperties;
    }

    public void setComboDisplayProperties(@Nonnull List<DisplayPropertyMetaModel> displayProperties) {
        this.m_comboDisplayProperties = displayProperties;
    }

    @Override
    @Nonnull
    public PropertyRelationType getRelationType() {
        return this.m_relationType;
    }

    public void setRelationType(@Nonnull PropertyRelationType relationType) {
        this.m_relationType = relationType;
    }

    @Override
    @Nonnull
    public ClassMetaModel getClassModel() {
        return this.m_classModel;
    }

    @Override
    @Nullable
    public Class<? extends INodeContentRenderer<?>> getComboNodeRenderer() {
        return this.m_comboNodeRenderer;
    }

    public void setComboNodeRenderer(@Nullable Class<? extends INodeContentRenderer<?>> comboNodeRenderer) {
        this.m_comboNodeRenderer = comboNodeRenderer;
    }

    public String toString() {
        return this.getClassModel().getActualClass().getName() + "." + this.m_descriptor.getName() + "[" + this.getActualType().getName() + "]";
    }

    @Override
    public Class<? extends INodeContentRenderer<?>> getLookupSelectedRenderer() {
        return this.m_lookupFieldRenderer;
    }

    public void setLookupSelectedRenderer(Class<? extends INodeContentRenderer<?>> lookupFieldRenderer) {
        this.m_lookupFieldRenderer = lookupFieldRenderer;
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getLookupSelectedProperties() {
        return this.m_lookupFieldDisplayProperties;
    }

    public void setLookupSelectedProperties(@Nonnull List<DisplayPropertyMetaModel> lookupFieldDisplayProperties) {
        this.m_lookupFieldDisplayProperties = lookupFieldDisplayProperties;
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getLookupTableProperties() {
        return this.m_lookupFieldTableProperties;
    }

    public void setLookupTableProperties(@Nonnull List<DisplayPropertyMetaModel> lookupFieldTableProperties) {
        this.m_lookupFieldTableProperties = lookupFieldTableProperties;
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getLookupFieldSearchProperties() {
        return this.m_lookupFieldSearchProperties;
    }

    public void setLookupFieldSearchProperties(@Nonnull List<SearchPropertyMetaModel> lookupFieldSearchProperties) {
        this.m_lookupFieldSearchProperties = lookupFieldSearchProperties;
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getLookupFieldKeySearchProperties() {
        return this.m_lookupFieldKeySearchProperties;
    }

    public void setLookupFieldKeySearchProperties(@Nonnull List<SearchPropertyMetaModel> lookupFieldKeySearchProperties) {
        this.m_lookupFieldKeySearchProperties = lookupFieldKeySearchProperties;
    }

    @Override
    @Nullable
    public String getComponentTypeHint() {
        return this.m_componentTypeHint;
    }

    public void setComponentTypeHint(@Nullable String componentTypeHint) {
        this.m_componentTypeHint = componentTypeHint;
    }

    @Override
    public IQueryManipulator<T> getQueryManipulator() {
        return this.m_queryManipulator;
    }

    public void setQueryManipulator(IQueryManipulator<T> queryManipulator) {
        this.m_queryManipulator = queryManipulator;
    }

    @Override
    @Nullable
    public <A> A getAnnotation(@Nonnull Class<A> annclass) {
        if (Annotation.class.isAssignableFrom(annclass) && this.m_descriptor != null && this.m_descriptor.getGetter() != null) {
            Class<A> aclz = annclass;
            return this.m_descriptor.getGetter().getAnnotation(aclz);
        }
        return null;
    }

    @Override
    @Nonnull
    public List<Object> getAnnotations() {
        if (this.m_descriptor != null && this.m_descriptor.getGetter() != null) {
            List<Object> res = Arrays.asList((Object[])this.m_descriptor.getGetter().getAnnotations());
            return res;
        }
        return Collections.emptyList();
    }
}

