/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaComboProperty;
import to.etc.domui.component.meta.MetaDisplayProperty;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.DummyConverter;
import to.etc.domui.converter.IConverter;
import to.etc.webapp.nls.NlsContext;

public class DisplayPropertyMetaModel {
    @Nonnull
    private final PropertyMetaModel<?> m_propertyModel;
    private String m_join;
    private String m_renderHint;
    private ClassMetaModel m_containedInClass;
    private String m_labelKey;
    private IConverter<?> m_converter;
    private SortableType m_sortable = SortableType.UNKNOWN;
    private int m_sortIndex;
    private int m_displayLength = -1;
    @Nonnull
    private YesNoType m_noWrap = YesNoType.UNKNOWN;

    public DisplayPropertyMetaModel(@Nonnull PropertyMetaModel<?> pmm) {
        this.m_propertyModel = pmm;
        if (null == this.m_propertyModel) {
            throw new IllegalArgumentException("Cannot be null");
        }
    }

    public DisplayPropertyMetaModel(@Nonnull ClassMetaModel cmm, @Nonnull MetaDisplayProperty p) {
        this.m_containedInClass = cmm;
        PropertyMetaModel<?> pmm = cmm.findProperty(p.name());
        if (null == pmm) {
            throw new IllegalStateException("Unknown property " + p.name() + " in " + cmm + " (bad @MetaDisplayProperty)");
        }
        this.m_propertyModel = pmm;
        if (!"$*$".equals(p.defaultLabel())) {
            this.m_labelKey = p.defaultLabel();
        }
        IConverter c = null;
        if (p.converterClass() != DummyConverter.class) {
            c = DisplayPropertyMetaModel.createconv(p.converterClass());
        }
        this.setConverter(c);
        this.setSortable(p.defaultSortable());
        this.setDisplayLength(p.displayLength());
        this.setNoWrap(p.noWrap());
        this.m_join = p.join().equals("$*$") ? null : p.join();
    }

    public DisplayPropertyMetaModel(@Nonnull ClassMetaModel cmm, @Nonnull MetaComboProperty p) {
        this.m_containedInClass = cmm;
        PropertyMetaModel<?> pmm = cmm.findProperty(p.name());
        if (null == pmm) {
            throw new IllegalStateException("Unknown property " + p.name() + " in " + cmm + " (bad @MetaComboProperty)");
        }
        this.m_propertyModel = pmm;
        IConverter c = null;
        if (p.converterClass() != DummyConverter.class) {
            c = DisplayPropertyMetaModel.createconv(p.converterClass());
        }
        this.setConverter(c);
        this.setSortIndex(p.sortIndex());
        this.setSortable(p.sortable());
        this.m_join = p.join().equals("$*$") ? null : p.join();
    }

    @Nonnull
    private static <T> IConverter<T> createconv(@Nonnull Class<?> clz) {
        return ConverterRegistry.getConverterInstance(clz);
    }

    public static List<DisplayPropertyMetaModel> decode(ClassMetaModel cmm, MetaDisplayProperty[] mar) {
        ArrayList<DisplayPropertyMetaModel> list = new ArrayList<DisplayPropertyMetaModel>(mar.length);
        for (MetaDisplayProperty p : mar) {
            list.add(new DisplayPropertyMetaModel(cmm, p));
        }
        return list;
    }

    public static List<DisplayPropertyMetaModel> decode(ClassMetaModel cmm, MetaComboProperty[] mar) {
        ArrayList<DisplayPropertyMetaModel> list = new ArrayList<DisplayPropertyMetaModel>(mar.length);
        for (MetaComboProperty p : mar) {
            list.add(new DisplayPropertyMetaModel(cmm, p));
        }
        return list;
    }

    public String getJoin() {
        return this.m_join;
    }

    public void setJoin(String join) {
        this.m_join = join;
    }

    public String getLabel() {
        if (this.m_labelKey == null) {
            return null;
        }
        return this.m_containedInClass.getClassBundle().getString(this.m_labelKey);
    }

    @Nonnull
    public PropertyMetaModel<?> getProperty() {
        return this.m_propertyModel;
    }

    public <X, TT extends IConverter<X>> String getAsString(Object root) throws Exception {
        Object value = this.getProperty().getValue(root);
        if (this.getConverter() != null) {
            return this.getConverter().convertObjectToString(NlsContext.getLocale(), value);
        }
        return value == null ? "" : value.toString();
    }

    public String getRenderHint() {
        return this.m_renderHint;
    }

    public void setRenderHint(String renderHint) {
        this.m_renderHint = renderHint;
    }

    public String toString() {
        return "DisplayPropertyMetaModel[" + this.getProperty().getName() + "]";
    }

    public IConverter<?> getConverter() {
        return this.m_converter;
    }

    public void setConverter(IConverter<?> converter) {
        this.m_converter = converter;
    }

    public SortableType getSortable() {
        return this.m_sortable;
    }

    public void setSortable(SortableType sortable) {
        this.m_sortable = sortable;
    }

    public int getDisplayLength() {
        return this.m_displayLength;
    }

    public void setDisplayLength(int displayLength) {
        this.m_displayLength = displayLength;
    }

    public int getSortIndex() {
        return this.m_sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.m_sortIndex = sortIndex;
    }

    @Nonnull
    public YesNoType getNoWrap() {
        return this.m_noWrap;
    }

    public void setNoWrap(@Nonnull YesNoType noWrap) {
        this.m_noWrap = noWrap;
    }
}

