/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyMetaValidator;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.TemporalPresentationType;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.component.meta.impl.BasicPropertyMetaModel;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayPropertyList;
import to.etc.domui.component.meta.impl.IdentityAccessor;
import to.etc.domui.component.meta.impl.JoinedDisplayProperty;
import to.etc.domui.component.meta.impl.SubAccessor;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.ILabelStringRenderer;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueAccessor;
import to.etc.webapp.nls.NlsContext;

public class ExpandedDisplayProperty<T>
implements PropertyMetaModel<T> {
    private ClassMetaModel m_classModel;
    private IValueAccessor<?> m_rootAccessor;
    private PropertyMetaModel<?> m_propertyMeta;
    private Class<T> m_actualType;
    private int m_displayLength;
    @Nonnull
    private YesNoType m_noWrap = YesNoType.UNKNOWN;
    private IConverter<T> m_converter;
    @Nonnull
    private SortableType m_sortableType = SortableType.UNKNOWN;
    private String m_propertyName;
    private String m_renderHint;
    private String m_defaultLabel;
    private IConverter<T> m_bestConverter;

    protected ExpandedDisplayProperty(Class<T> actual, PropertyMetaModel<?> propertyMeta, IValueAccessor<?> accessor) {
        this.m_actualType = actual;
        this.m_propertyMeta = propertyMeta;
        this.m_rootAccessor = accessor;
        if (propertyMeta != null) {
            this.m_defaultLabel = propertyMeta.getDefaultLabel();
            this.m_classModel = propertyMeta.getClassModel();
            if (this.m_sortableType == SortableType.UNKNOWN) {
                this.setSortable(propertyMeta.getSortable());
            }
            if (this.m_displayLength <= 0) {
                this.m_displayLength = propertyMeta.getDisplayLength();
                if (this.m_displayLength <= 0) {
                    this.m_displayLength = propertyMeta.getLength();
                }
            }
            this.m_noWrap = propertyMeta.getNowrap();
        }
    }

    protected ExpandedDisplayProperty(PropertyMetaModel<T> propertyMeta, IValueAccessor<T> accessor) {
        this((DisplayPropertyMetaModel)null, propertyMeta, accessor);
    }

    protected ExpandedDisplayProperty(DisplayPropertyMetaModel displayMeta, PropertyMetaModel<T> propertyMeta, IValueAccessor<T> accessor) {
        this.m_propertyMeta = propertyMeta;
        this.m_rootAccessor = accessor;
        if (propertyMeta != null) {
            this.m_defaultLabel = propertyMeta.getDefaultLabel();
            this.m_classModel = propertyMeta.getClassModel();
            this.m_actualType = propertyMeta.getActualType();
            this.m_propertyName = propertyMeta.getName();
            this.m_converter = propertyMeta.getConverter();
            if (this.m_sortableType == SortableType.UNKNOWN) {
                this.setSortable(propertyMeta.getSortable());
            }
            if (this.m_displayLength <= 0) {
                this.m_displayLength = propertyMeta.getDisplayLength();
                if (this.m_displayLength <= 0) {
                    this.m_displayLength = propertyMeta.getLength();
                }
            }
            this.m_noWrap = propertyMeta.getNowrap();
        }
        if (displayMeta != null) {
            if (displayMeta.getConverter() != null) {
                this.m_converter = displayMeta.getConverter();
            }
            if (displayMeta.getSortable() != SortableType.UNKNOWN) {
                this.setSortable(displayMeta.getSortable());
            }
            if (displayMeta.getDisplayLength() > 0) {
                this.m_displayLength = displayMeta.getDisplayLength();
            }
            if (displayMeta.getNoWrap() != YesNoType.UNKNOWN) {
                this.m_noWrap = displayMeta.getNoWrap();
            }
            this.m_renderHint = displayMeta.getRenderHint();
            String s = displayMeta.getLabel();
            if (s != null) {
                this.m_defaultLabel = s;
            }
        }
        if (this.m_converter != null) {
            this.m_bestConverter = this.m_converter;
        } else if (propertyMeta != null) {
            this.m_bestConverter = ConverterRegistry.findBestConverter(propertyMeta);
        }
    }

    public static ExpandedDisplayProperty<?> expandProperty(ClassMetaModel cmm, String property) {
        PropertyMetaModel<?> pmm = cmm.findProperty(property);
        if (pmm == null) {
            throw new IllegalStateException("Unknown property '" + property + "' on classModel=" + cmm);
        }
        return ExpandedDisplayProperty.expandProperty(pmm);
    }

    public static <X> ExpandedDisplayProperty<?> expandProperty(PropertyMetaModel<X> pmm) {
        if (pmm == null) {
            throw new IllegalArgumentException("Null property???");
        }
        Class<X> rescl = pmm.getActualType();
        if (!DomUtil.isBasicType(rescl)) {
            ClassMetaModel cmm = MetaManager.findClassMeta(rescl);
            if (pmm.getLookupTableProperties().size() > 0 || cmm.getTableDisplayProperties().size() > 0) {
                return ExpandedDisplayProperty.expandCompoundProperty(pmm, cmm);
            }
        }
        return new ExpandedDisplayProperty<X>((DisplayPropertyMetaModel)null, pmm, pmm);
    }

    public static List<ExpandedDisplayProperty<?>> expandProperties(Class<?> clz, String[] properties) {
        ClassMetaModel cmm = MetaManager.findClassMeta(clz);
        return ExpandedDisplayProperty.expandProperties(cmm, properties);
    }

    public static List<ExpandedDisplayProperty<?>> expandProperties(ClassMetaModel cmm, String[] properties) {
        ArrayList res = new ArrayList(properties.length);
        for (String p : properties) {
            res.add(ExpandedDisplayProperty.expandProperty(cmm, p));
        }
        return res;
    }

    private static <T> ExpandedDisplayProperty<?> expandCompoundProperty(PropertyMetaModel<T> pmm, ClassMetaModel cmm) {
        List<DisplayPropertyMetaModel> dpl = pmm.getLookupTableProperties();
        if (dpl.size() == 0 && (dpl = cmm.getTableDisplayProperties()).size() == 0) {
            return new ExpandedDisplayProperty<T>(pmm, pmm);
        }
        List<ExpandedDisplayProperty<?>> list = ExpandedDisplayProperty.expandDisplayProperties(dpl, cmm, pmm);
        return new ExpandedDisplayPropertyList(pmm, pmm, list);
    }

    public static List<ExpandedDisplayProperty<?>> expandDisplayProperties(List<DisplayPropertyMetaModel> dpl, ClassMetaModel cmm, IValueAccessor<?> rootAccessor) {
        if (rootAccessor == null) {
            rootAccessor = new IdentityAccessor();
        }
        ArrayList res = new ArrayList(dpl.size());
        ArrayList<DisplayPropertyMetaModel> joinList = null;
        for (DisplayPropertyMetaModel dpm : dpl) {
            if (dpm.getJoin() != null) {
                if (joinList == null) {
                    joinList = new ArrayList<DisplayPropertyMetaModel>();
                }
                joinList.add(dpm);
                continue;
            }
            if (joinList != null) {
                joinList.add(dpm);
                res.add(ExpandedDisplayProperty.createJoinedProperty(cmm, joinList, rootAccessor));
                joinList = null;
                continue;
            }
            PropertyMetaModel<?> pmm = dpm.getProperty();
            Class<?> clz = pmm.getActualType();
            List<DisplayPropertyMetaModel> subdpl = pmm.getLookupTableProperties();
            ClassMetaModel pcmm = ExpandedDisplayProperty.findCompoundClassModel(clz);
            if (subdpl.size() == 0 && pcmm != null) {
                subdpl = pcmm.getTableDisplayProperties();
            }
            SubAccessor sacc = new SubAccessor(rootAccessor, pmm);
            if (subdpl.size() != 0) {
                List<ExpandedDisplayProperty<?>> xlist = ExpandedDisplayProperty.expandDisplayProperties(subdpl, pcmm, sacc);
                res.add(new ExpandedDisplayPropertyList(pmm, pmm, xlist));
                continue;
            }
            ExpandedDisplayProperty xdp = new ExpandedDisplayProperty(dpm, pmm, sacc);
            res.add(xdp);
        }
        if (joinList != null) {
            res.add(ExpandedDisplayProperty.createJoinedProperty(cmm, joinList, rootAccessor));
        }
        return res;
    }

    private static ClassMetaModel findCompoundClassModel(Class<?> clz) {
        if (DomUtil.isBasicType(clz)) {
            return null;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(clz);
        return cmm;
    }

    private static ExpandedDisplayProperty<String> createJoinedProperty(ClassMetaModel cmm, List<DisplayPropertyMetaModel> dpl, IValueAccessor<?> accessor) {
        ArrayList plist = new ArrayList(dpl.size());
        for (DisplayPropertyMetaModel dm : dpl) {
            PropertyMetaModel<?> pm = dm.getProperty();
            plist.add(pm);
        }
        return new JoinedDisplayProperty(dpl, plist, accessor);
    }

    @Override
    @Nonnull
    public Class<T> getActualType() {
        return this.m_actualType;
    }

    @Override
    public final void setValue(Object target, Object value) throws Exception {
        throw new IllegalStateException("Expanded properties cannot be set to a value");
    }

    @Override
    public T getValue(Object in) throws Exception {
        return this.m_rootAccessor.getValue(in);
    }

    @Override
    public ClassMetaModel getValueModel() {
        return MetaManager.findClassMeta(this.getActualType());
    }

    @Override
    public Type getGenericActualType() {
        return null;
    }

    @Override
    @Nonnull
    public String getDefaultLabel() {
        return this.m_defaultLabel;
    }

    @Override
    public IConverter<T> getConverter() {
        return this.m_converter;
    }

    @Override
    public int getDisplayLength() {
        return this.m_displayLength;
    }

    public void setDisplayLength(int displayLength) {
        this.m_displayLength = displayLength;
    }

    @Override
    @Nonnull
    public SortableType getSortable() {
        if (this.m_sortableType == null) {
            throw new IllegalStateException("?? Sortable may never be null??");
        }
        return this.m_sortableType;
    }

    public void setSortable(SortableType sortableType) {
        if (sortableType == null) {
            throw new IllegalStateException("?? Sortable may never be null??");
        }
        this.m_sortableType = sortableType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_propertyName;
    }

    public void setName(String propertyName) {
        this.m_propertyName = propertyName;
    }

    public IConverter<T> getBestConverter() {
        return this.m_bestConverter;
    }

    public String getPresentationString(Object root) throws Exception {
        T colval = this.getValue(root);
        String s = colval == null ? "" : (this.getBestConverter() != null ? this.getBestConverter().convertObjectToString(NlsContext.getLocale(), colval) : colval.toString());
        return s;
    }

    public static List<ExpandedDisplayProperty<?>> flatten(List<ExpandedDisplayProperty<?>> in) {
        ArrayList res = new ArrayList(in.size() + 10);
        ExpandedDisplayProperty.flatten(res, in);
        return res;
    }

    private static void flatten(List<ExpandedDisplayProperty<?>> res, List<ExpandedDisplayProperty<?>> in) {
        for (ExpandedDisplayProperty<?> xd : in) {
            ExpandedDisplayProperty.flatten(res, xd);
        }
    }

    public static void flatten(List<ExpandedDisplayProperty<?>> res, ExpandedDisplayProperty<?> xd) {
        if (xd instanceof ExpandedDisplayPropertyList) {
            ExpandedDisplayProperty.flatten(res, ((ExpandedDisplayPropertyList)xd).getChildren());
        } else {
            res.add(xd);
        }
    }

    @Override
    @Nonnull
    public ClassMetaModel getClassModel() {
        return this.m_classModel;
    }

    @Override
    public Class<? extends IComboDataSet<?>> getComboDataSet() {
        return this.m_propertyMeta != null ? this.m_propertyMeta.getComboDataSet() : null;
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getComboDisplayProperties() {
        return this.m_propertyMeta == null ? Collections.EMPTY_LIST : this.m_propertyMeta.getComboDisplayProperties();
    }

    @Override
    public Class<? extends ILabelStringRenderer<?>> getComboLabelRenderer() {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getComboLabelRenderer();
    }

    @Override
    public Class<? extends INodeContentRenderer<?>> getComboNodeRenderer() {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getComboNodeRenderer();
    }

    @Override
    public String getComponentTypeHint() {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getComponentTypeHint();
    }

    @Override
    public String getDefaultHint() {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getDefaultHint();
    }

    @Override
    public String getDomainValueLabel(Locale loc, Object val) {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getDomainValueLabel(loc, val);
    }

    @Override
    public Object[] getDomainValues() {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getDomainValues();
    }

    @Override
    public int getLength() {
        return this.m_propertyMeta == null ? -1 : this.m_propertyMeta.getLength();
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getLookupSelectedProperties() {
        return this.m_propertyMeta == null ? Collections.EMPTY_LIST : this.m_propertyMeta.getLookupSelectedProperties();
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getLookupFieldSearchProperties() {
        return this.m_propertyMeta == null ? Collections.EMPTY_LIST : this.m_propertyMeta.getLookupFieldSearchProperties();
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getLookupFieldKeySearchProperties() {
        return this.m_propertyMeta == null ? Collections.EMPTY_LIST : this.m_propertyMeta.getLookupFieldKeySearchProperties();
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getLookupTableProperties() {
        return this.m_propertyMeta == null ? Collections.EMPTY_LIST : this.m_propertyMeta.getLookupTableProperties();
    }

    @Override
    public Class<? extends INodeContentRenderer<?>> getLookupSelectedRenderer() {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getLookupSelectedRenderer();
    }

    @Override
    public int getPrecision() {
        return this.m_propertyMeta == null ? -1 : this.m_propertyMeta.getPrecision();
    }

    @Override
    @Nonnull
    public YesNoType getReadOnly() {
        return this.m_propertyMeta == null ? YesNoType.UNKNOWN : this.m_propertyMeta.getReadOnly();
    }

    @Override
    @Nonnull
    public PropertyRelationType getRelationType() {
        return this.m_propertyMeta == null ? PropertyRelationType.NONE : this.m_propertyMeta.getRelationType();
    }

    @Override
    public int getScale() {
        return this.m_propertyMeta == null ? -1 : this.m_propertyMeta.getScale();
    }

    @Override
    public PropertyControlFactory getControlFactory() {
        return this.m_propertyMeta == null ? null : this.m_propertyMeta.getControlFactory();
    }

    @Override
    @Nonnull
    public TemporalPresentationType getTemporal() {
        return this.m_propertyMeta == null ? TemporalPresentationType.UNKNOWN : this.m_propertyMeta.getTemporal();
    }

    @Override
    @Nonnull
    public NumericPresentation getNumericPresentation() {
        return this.m_propertyMeta == null ? NumericPresentation.UNKNOWN : this.m_propertyMeta.getNumericPresentation();
    }

    @Override
    @Nonnull
    public PropertyMetaValidator[] getValidators() {
        return this.m_propertyMeta == null ? NO_VALIDATORS : this.m_propertyMeta.getValidators();
    }

    @Override
    public boolean isPrimaryKey() {
        return this.m_propertyMeta == null ? false : this.m_propertyMeta.isPrimaryKey();
    }

    @Override
    public boolean isRequired() {
        return this.m_propertyMeta == null ? false : this.m_propertyMeta.isRequired();
    }

    @Override
    public boolean isTransient() {
        return this.m_propertyMeta == null ? true : this.m_propertyMeta.isTransient();
    }

    @Override
    @Nonnull
    public YesNoType getNowrap() {
        return this.m_noWrap;
    }

    public String getRenderHint() {
        return this.m_renderHint;
    }

    public void setRenderHint(String renderHint) {
        this.m_renderHint = renderHint;
    }

    public String toString() {
        return "ExpandedDisplayProperty[" + this.m_propertyName + "]";
    }

    @Override
    public String getRegexpUserString() {
        return null;
    }

    @Override
    public String getRegexpValidator() {
        return null;
    }

    @Override
    @Nullable
    public <A> A getAnnotation(@Nonnull Class<A> annclass) {
        return null;
    }

    @Override
    @Nonnull
    public List<Object> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String[] getColumnNames() {
        return BasicPropertyMetaModel.NO_NAMES;
    }

    @Override
    public IQueryManipulator<T> getQueryManipulator() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

