/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.util.IValueAccessor;
import to.etc.webapp.nls.NlsContext;

public class JoinedDisplayProperty
extends ExpandedDisplayProperty<String>
implements IValueAccessor<String> {
    private List<DisplayPropertyMetaModel> m_displayList;
    private List<PropertyMetaModel<?>> m_propertyList;

    public JoinedDisplayProperty(List<DisplayPropertyMetaModel> list, List<PropertyMetaModel<?>> plist, IValueAccessor<?> rootAccessor) {
        super(String.class, null, rootAccessor);
        this.m_displayList = list;
        this.m_propertyList = plist;
        if (list.size() < 2) {
            throw new IllegalStateException("?? Expecting at least 2 properties in a joined display property.");
        }
        DisplayPropertyMetaModel dpm = list.get(0);
        this.setDisplayLength(dpm.getDisplayLength());
        this.setSortable(SortableType.UNSORTABLE);
        this.setName(dpm.getProperty().getName());
    }

    @Override
    public String getValue(Object in) throws Exception {
        Object root = super.getValue(in);
        if (root == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String join = null;
        for (int i = 0; i < this.m_displayList.size(); ++i) {
            IConverter<?> converter;
            String s;
            DisplayPropertyMetaModel dpm = this.m_displayList.get(i);
            PropertyMetaModel<?> pm = this.m_propertyList.get(i);
            Object value = pm.getValue(root);
            if (value == null || (s = (converter = pm.getConverter()) != null ? converter.convertObjectToString(NlsContext.getLocale(), value) : ConverterRegistry.convertToString(pm, value)) == null || s.length() == 0) continue;
            if (join != null) {
                sb.append(join);
            }
            join = dpm.getJoin();
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getDefaultLabel() {
        DisplayPropertyMetaModel dm = this.m_displayList.get(0);
        String lbl = dm.getLabel();
        if (lbl != null) {
            return lbl;
        }
        return this.m_propertyList.get(0).getDefaultLabel();
    }
}

