/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyMetaValidator;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.meta.TemporalPresentationType;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.converter.IConverter;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.ILabelStringRenderer;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueAccessor;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.NlsContext;

public class PathPropertyMetaModel<T>
implements PropertyMetaModel<T>,
IValueAccessor<T> {
    private PropertyMetaModel<T> m_original;
    private String m_dottedName;
    private PropertyMetaModel<?>[] m_accessPath;

    public PathPropertyMetaModel(String dottedName, PropertyMetaModel<?>[] accessPath) {
        this.m_accessPath = accessPath;
        this.m_original = accessPath[accessPath.length - 1];
        this.m_dottedName = dottedName;
    }

    @Nonnull
    public String toString() {
        return "PathProperty[" + this.m_dottedName + "@" + this.m_accessPath[0].getClassModel().toString() + "]";
    }

    @Nonnull
    public List<PropertyMetaModel<?>> getAccessPath() {
        return Arrays.asList(this.m_accessPath);
    }

    @Override
    public T getValue(Object in) throws Exception {
        Object cv = in;
        for (PropertyMetaModel<?> pmm : this.m_accessPath) {
            if ((cv = pmm.getValue(cv)) != null) continue;
            return null;
        }
        return (T)cv;
    }

    @Override
    public void setValue(Object target, T value) throws Exception {
        Object cv = target;
        for (PropertyMetaModel<?> pmm : this.m_accessPath) {
            if (pmm == this.m_original) {
                pmm.setValue(cv, value);
                return;
            }
            if ((cv = pmm.getValue(cv)) != null) continue;
            throw new IllegalStateException("In path '" + this.m_dottedName + "', property '" + pmm.getName() + "' in classModel=" + pmm.getClassModel() + " is null - cannot set a value!!");
        }
    }

    @Override
    @Nullable
    public String getDefaultHint() {
        return this.locateProperty("hint");
    }

    @Override
    @Nonnull
    public String getDefaultLabel() {
        String toReturn = this.locateProperty("label");
        return toReturn == null ? this.getName() : toReturn;
    }

    @Nullable
    private String locateProperty(String type) {
        String s;
        Locale loc = NlsContext.getLocale();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m_accessPath.length - 1; ++i) {
            PropertyMetaModel<?> pmm = this.m_accessPath[i];
            BundleRef br = pmm.getClassModel().getClassBundle();
            String v = this.attemptProperty(sb, br, i, type, loc);
            if (v == null) continue;
            return v;
        }
        sb.setLength(0);
        sb.append(this.m_original.getName());
        sb.append('.');
        sb.append(type);
        BundleRef cb = this.m_original.getClassModel().getClassBundle();
        if (null != cb && (s = cb.findMessage(loc, sb.toString())) != null) {
            return s;
        }
        return null;
    }

    private String attemptProperty(StringBuilder sb, BundleRef br, int startix, String type, Locale loc) {
        for (int i = this.m_accessPath.length; i > startix; --i) {
            sb.setLength(0);
            for (int j = startix; j < this.m_accessPath.length; ++j) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                if (j >= i) {
                    sb.append('*');
                    continue;
                }
                sb.append(this.m_accessPath[j].getName());
            }
            sb.append('.');
            sb.append(type);
            String k = sb.toString();
            String s = br.findMessage(loc, k);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Override
    @Nonnull
    public Class<T> getActualType() {
        return this.m_original.getActualType();
    }

    @Override
    public ClassMetaModel getValueModel() {
        return this.m_original.getValueModel();
    }

    @Override
    public Type getGenericActualType() {
        return this.m_original.getGenericActualType();
    }

    @Override
    @Nonnull
    public ClassMetaModel getClassModel() {
        return this.m_original.getClassModel();
    }

    @Override
    public Class<? extends IComboDataSet<?>> getComboDataSet() {
        return this.m_original.getComboDataSet();
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getComboDisplayProperties() {
        return this.m_original.getComboDisplayProperties();
    }

    @Override
    public Class<? extends ILabelStringRenderer<?>> getComboLabelRenderer() {
        return this.m_original.getComboLabelRenderer();
    }

    @Override
    public Class<? extends INodeContentRenderer<?>> getComboNodeRenderer() {
        return this.m_original.getComboNodeRenderer();
    }

    @Override
    public String getComponentTypeHint() {
        return this.m_original.getComponentTypeHint();
    }

    @Override
    public IConverter<T> getConverter() {
        return this.m_original.getConverter();
    }

    @Override
    public int getDisplayLength() {
        return this.m_original.getDisplayLength();
    }

    @Override
    public String getDomainValueLabel(Locale loc, Object val) {
        return this.m_original.getDomainValueLabel(loc, val);
    }

    @Override
    public Object[] getDomainValues() {
        return this.m_original.getDomainValues();
    }

    @Override
    public int getLength() {
        return this.m_original.getLength();
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getLookupSelectedProperties() {
        return this.m_original.getLookupSelectedProperties();
    }

    @Override
    public Class<? extends INodeContentRenderer<?>> getLookupSelectedRenderer() {
        return this.m_original.getLookupSelectedRenderer();
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getLookupFieldSearchProperties() {
        return this.m_original.getLookupFieldSearchProperties();
    }

    @Override
    @Nonnull
    public List<SearchPropertyMetaModel> getLookupFieldKeySearchProperties() {
        return this.m_original.getLookupFieldKeySearchProperties();
    }

    @Override
    @Nonnull
    public List<DisplayPropertyMetaModel> getLookupTableProperties() {
        return this.m_original.getLookupTableProperties();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_dottedName;
    }

    @Override
    public int getPrecision() {
        return this.m_original.getPrecision();
    }

    @Override
    @Nonnull
    public YesNoType getReadOnly() {
        return this.m_original.getReadOnly();
    }

    @Override
    @Nonnull
    public PropertyRelationType getRelationType() {
        return this.m_original.getRelationType();
    }

    @Override
    @Nonnull
    public YesNoType getNowrap() {
        return this.m_original.getNowrap();
    }

    @Override
    public int getScale() {
        return this.m_original.getScale();
    }

    @Override
    @Nonnull
    public SortableType getSortable() {
        return this.m_original.getSortable();
    }

    @Override
    @Nonnull
    public TemporalPresentationType getTemporal() {
        return this.m_original.getTemporal();
    }

    @Override
    @Nonnull
    public NumericPresentation getNumericPresentation() {
        return this.m_original.getNumericPresentation();
    }

    @Override
    @Nonnull
    public PropertyMetaValidator[] getValidators() {
        return this.m_original.getValidators();
    }

    @Override
    public boolean isPrimaryKey() {
        return this.m_original.isPrimaryKey();
    }

    @Override
    public boolean isRequired() {
        return this.m_original.isRequired();
    }

    @Override
    public boolean isTransient() {
        return this.m_original.isTransient();
    }

    @Override
    public String getRegexpUserString() {
        return this.m_original.getRegexpUserString();
    }

    @Override
    public String getRegexpValidator() {
        return this.m_original.getRegexpValidator();
    }

    @Override
    public PropertyControlFactory getControlFactory() {
        return this.m_original.getControlFactory();
    }

    @Override
    public <A> A getAnnotation(@Nonnull Class<A> annclass) {
        return this.m_original.getAnnotation(annclass);
    }

    @Override
    @Nonnull
    public List<Object> getAnnotations() {
        return this.m_original.getAnnotations();
    }

    @Override
    @Nonnull
    public String[] getColumnNames() {
        return this.m_original.getColumnNames();
    }

    @Override
    @Nullable
    public IQueryManipulator<T> getQueryManipulator() {
        return this.m_original.getQueryManipulator();
    }

    @Override
    public boolean isReadOnly() {
        return this.m_original.isReadOnly();
    }
}

