/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.meta.impl;

import java.util.List;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;

public class SearchPropertyMetaModelImpl
implements SearchPropertyMetaModel {
    private ClassMetaModel m_classModel;
    private String m_propertyName;
    private List<PropertyMetaModel<?>> m_propertyPath;
    private boolean m_ignoreCase;
    private int m_order;
    private int m_minLength;
    private String m_lookupLabelKey;
    private String m_lookupHintKey;

    public SearchPropertyMetaModelImpl(ClassMetaModel cmm, List<PropertyMetaModel<?>> mli) {
        this.m_classModel = cmm;
        this.m_propertyPath = mli;
    }

    public SearchPropertyMetaModelImpl(ClassMetaModel cmm) {
        this(cmm, null);
    }

    @Override
    public synchronized List<PropertyMetaModel<?>> getPropertyPath() {
        if (this.m_propertyPath == null && this.m_propertyName != null) {
            this.m_propertyPath = MetaManager.parsePropertyPath(this.m_classModel, this.m_propertyName);
            if (this.m_propertyPath.size() == 0) {
                throw new IllegalStateException("? No path for compound property " + this.m_propertyName + " in " + this.m_classModel);
            }
        }
        return this.m_propertyPath;
    }

    public synchronized void setPropertyPath(List<PropertyMetaModel<?>> propertyPath) {
        this.m_propertyPath = propertyPath;
    }

    @Override
    public boolean isIgnoreCase() {
        return this.m_ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.m_ignoreCase = ignoreCase;
    }

    @Override
    public int getOrder() {
        return this.m_order;
    }

    public void setOrder(int order) {
        this.m_order = order;
    }

    @Override
    public int getMinLength() {
        return this.m_minLength;
    }

    public void setMinLength(int minLength) {
        this.m_minLength = minLength;
    }

    @Override
    public synchronized String getPropertyName() {
        return this.m_propertyName;
    }

    public synchronized void setPropertyName(String propertyName) {
        this.m_propertyName = propertyName;
    }

    public String getLookupLabelKey() {
        return this.m_lookupLabelKey;
    }

    public void setLookupLabelKey(String lookupLabelKey) {
        this.m_lookupLabelKey = lookupLabelKey;
    }

    @Override
    public String getLookupLabel() {
        if (this.m_lookupLabelKey == null) {
            return null;
        }
        return this.m_classModel.getClassBundle().getString(this.m_lookupLabelKey);
    }

    public String getLookupHintKey() {
        return this.m_lookupHintKey;
    }

    public void setLookupHintKey(String lookupHintKey) {
        this.m_lookupHintKey = lookupHintKey;
    }

    @Override
    public String getLookupHint() {
        if (this.m_lookupHintKey == null) {
            return null;
        }
        return this.m_classModel.getClassBundle().getString(this.m_lookupHintKey);
    }
}

